/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBOutputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class TestDBOutputFormat
extends TestCase {
    private String[] fieldNames = new String[]{"id", "name", "value"};
    private String[] nullFieldNames = new String[]{null, null, null};
    private String expected = "INSERT INTO hadoop_output (id,name,value) VALUES (?,?,?);";
    private String nullExpected = "INSERT INTO hadoop_output VALUES (?,?,?);";
    private DBOutputFormat<DBWritable, NullWritable> format = new DBOutputFormat();

    public void testConstructQuery() {
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        TestDBOutputFormat.assertEquals((String)this.expected, (String)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        TestDBOutputFormat.assertEquals((String)this.nullExpected, (String)actual);
    }

    public void testSetOutput() throws IOException {
        Job job = new Job(new Configuration());
        DBOutputFormat.setOutput((Job)job, (String)"hadoop_output", (String[])this.fieldNames);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        String actual = this.format.constructQuery(dbConf.getOutputTableName(), dbConf.getOutputFieldNames());
        TestDBOutputFormat.assertEquals((String)this.expected, (String)actual);
        job = new Job(new Configuration());
        dbConf = new DBConfiguration(job.getConfiguration());
        DBOutputFormat.setOutput((Job)job, (String)"hadoop_output", (int)this.nullFieldNames.length);
        TestDBOutputFormat.assertNull((Object)dbConf.getOutputFieldNames());
        TestDBOutputFormat.assertEquals((int)this.nullFieldNames.length, (int)dbConf.getOutputFieldCount());
        actual = this.format.constructQuery(dbConf.getOutputTableName(), new String[dbConf.getOutputFieldCount()]);
        TestDBOutputFormat.assertEquals((String)this.nullExpected, (String)actual);
    }
}

