/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TestMiniMRMapRedDebugScript;
import org.apache.hadoop.mapred.TestTaskFail;
import org.junit.Ignore;

@Ignore
public class TestJvmReuse
extends TestCase {
    private static Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), TestJvmReuse.class.getName());
    private int numMappers = 5;
    private static int taskWithCleanup = 2;

    public RunningJob launchJob(JobConf conf, Path inDir, Path outDir) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        for (int i = 0; i < this.numMappers; ++i) {
            FSDataOutputStream file = inFs.create(new Path(inDir, "part-" + i));
            file.writeBytes("input");
            file.close();
        }
        conf.setMapperClass(MapperClass.class);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumTasksToExecutePerJvm(-1);
        return new JobClient(conf).submitJob(conf);
    }

    private void validateAttempt(TaskInProgress tip, TaskAttemptID attemptId, TaskStatus ts, boolean isCleanup) throws IOException {
        TestJvmReuse.assertEquals((boolean)isCleanup, (boolean)tip.isCleanupAttempt(attemptId));
        String log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, false);
        TestJvmReuse.assertTrue((boolean)log.equals(attemptId.toString()));
        TestJvmReuse.assertTrue((ts != null ? 1 : 0) != 0);
        if (!isCleanup) {
            TestJvmReuse.assertEquals((Object)TaskStatus.State.SUCCEEDED, (Object)ts.getRunState());
        } else {
            TestJvmReuse.assertEquals((Object)TaskStatus.State.FAILED, (Object)ts.getRunState());
            log = TestMiniMRMapRedDebugScript.readTaskLog(TaskLog.LogName.STDERR, attemptId, true);
            TestJvmReuse.assertTrue((boolean)log.equals(TestTaskFail.cleanupLog));
        }
    }

    private void validateJob(RunningJob job, MiniMRCluster mr) throws IOException {
        TestJvmReuse.assertEquals((int)2, (int)job.getJobState());
        long uses = job.getCounters().findCounter("jvm", "use").getValue();
        System.out.println("maps:" + this.numMappers + " uses:" + uses);
        TestJvmReuse.assertTrue((String)("maps = " + this.numMappers + ", jvms = " + uses), ((long)this.numMappers < uses ? 1 : 0) != 0);
        JobID jobId = job.getID();
        for (int i = 0; i < this.numMappers; ++i) {
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, i), 0);
            TaskInProgress tip = mr.getJobTrackerRunner().getJobTracker().getTip(attemptId.getTaskID());
            TaskStatus ts = mr.getJobTrackerRunner().getJobTracker().getTaskStatus(attemptId);
            this.validateAttempt(tip, attemptId, ts, i == taskWithCleanup);
            if (i != taskWithCleanup) continue;
            attemptId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, true, i), 1);
            ts = mr.getJobTrackerRunner().getJobTracker().getTaskStatus(attemptId);
            this.validateAttempt(tip, attemptId, ts, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskLogs() throws IOException {
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            boolean taskTrackers = true;
            conf.setInt("mapred.tasktracker.map.tasks.maximum", 1);
            mr = new MiniMRCluster(1, "file:///", 1);
            Path inDir = new Path(rootDir, "input");
            Path outDir = new Path(rootDir, "output");
            JobConf jobConf = mr.createJobConf();
            jobConf.setOutputCommitter(TestTaskFail.CommitterWithLogs.class);
            RunningJob rJob = this.launchJob(jobConf, inDir, outDir);
            rJob.waitForCompletion();
            this.validateJob(rJob, mr);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static class MapperClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        String taskid;
        static int instances = 0;
        Reporter reporter = null;

        public void configure(JobConf job) {
            this.taskid = job.get("mapred.task.id");
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            System.err.println(this.taskid);
            this.reporter = reporter;
            if (TaskAttemptID.forName((String)this.taskid).getTaskID().getId() == taskWithCleanup && this.taskid.endsWith("_0")) {
                System.exit(-1);
            }
        }

        public void close() throws IOException {
            this.reporter.incrCounter("jvm", "use", (long)(++instances));
        }
    }
}

