/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Random;
import javax.net.SocketFactory;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestIPC
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestIPC.class);
    private static final Configuration conf = new Configuration();
    private static final int PING_INTERVAL = 1000;
    private static final int MIN_SLEEP_TIME = 1000;
    private static final Random RANDOM;
    private static final String ADDRESS = "0.0.0.0";

    public TestIPC(String name) {
        super(name);
    }

    public void testSerial() throws Exception {
        this.testSerial(3, false, 2, 5, 10);
    }

    public void testSerial(int handlerCount, boolean handlerSleep, int clientCount, int callerCount, int callCount) throws Exception {
        int i;
        TestServer server = new TestServer(handlerCount, handlerSleep);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Client[] clients = new Client[clientCount];
        for (int i2 = 0; i2 < clientCount; ++i2) {
            clients[i2] = new Client(LongWritable.class, conf);
        }
        SerialCaller[] callers = new SerialCaller[callerCount];
        for (i = 0; i < callerCount; ++i) {
            callers[i] = new SerialCaller(clients[i % clientCount], addr, callCount);
            callers[i].start();
        }
        for (i = 0; i < callerCount; ++i) {
            callers[i].join();
            TestIPC.assertFalse((boolean)callers[i].failed);
        }
        for (i = 0; i < clientCount; ++i) {
            clients[i].stop();
        }
        server.stop();
    }

    public void testParallel() throws Exception {
        this.testParallel(10, false, 2, 4, 2, 4, 100);
    }

    public void testParallel(int handlerCount, boolean handlerSleep, int serverCount, int addressCount, int clientCount, int callerCount, int callCount) throws Exception {
        int i;
        Server[] servers = new Server[serverCount];
        for (int i2 = 0; i2 < serverCount; ++i2) {
            servers[i2] = new TestServer(handlerCount, handlerSleep);
            servers[i2].start();
        }
        InetSocketAddress[] addresses = new InetSocketAddress[addressCount];
        for (int i3 = 0; i3 < addressCount; ++i3) {
            addresses[i3] = NetUtils.getConnectAddress((Server)servers[i3 % serverCount]);
        }
        Client[] clients = new Client[clientCount];
        for (int i4 = 0; i4 < clientCount; ++i4) {
            clients[i4] = new Client(LongWritable.class, conf);
        }
        ParallelCaller[] callers = new ParallelCaller[callerCount];
        for (i = 0; i < callerCount; ++i) {
            callers[i] = new ParallelCaller(clients[i % clientCount], addresses, callCount);
            callers[i].start();
        }
        for (i = 0; i < callerCount; ++i) {
            callers[i].join();
            TestIPC.assertFalse((boolean)callers[i].failed);
        }
        for (i = 0; i < clientCount; ++i) {
            clients[i].stop();
        }
        for (i = 0; i < serverCount; ++i) {
            servers[i].stop();
        }
    }

    public void testStandAloneClient() throws Exception {
        this.testParallel(10, false, 2, 4, 2, 4, 100);
        Client client = new Client(LongWritable.class, conf);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 10);
        try {
            client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
            TestIPC.fail((String)"Expected an exception to have been thrown");
        }
        catch (IOException e) {
            String message = e.getMessage();
            String addressText = address.toString();
            TestIPC.assertTrue((String)("Did not find " + addressText + " in " + message), (boolean)message.contains(addressText));
            Throwable cause = e.getCause();
            TestIPC.assertNotNull((String)("No nested exception in " + e), (Object)cause);
            String causeText = cause.getMessage();
            TestIPC.assertTrue((String)("Did not find " + causeText + " in " + message), (boolean)message.contains(causeText));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRTEDuringConnectionSetup() throws Exception {
        SocketFactory spyFactory = (SocketFactory)Mockito.spy((Object)NetUtils.getDefaultSocketFactory((Configuration)conf));
        ((SocketFactory)Mockito.doAnswer((Answer)new Answer<Socket>(){

            public Socket answer(InvocationOnMock invocation) throws Throwable {
                Socket s = (Socket)Mockito.spy((Object)((Socket)invocation.callRealMethod()));
                ((Socket)Mockito.doThrow((Throwable)new RuntimeException("Injected fault")).when((Object)s)).setSoTimeout(Mockito.anyInt());
                return s;
            }
        }).when((Object)spyFactory)).createSocket();
        TestServer server = new TestServer(1, true);
        server.start();
        try {
            InetSocketAddress address = NetUtils.getConnectAddress((Server)server);
            Client client = new Client(LongWritable.class, conf, spyFactory);
            try {
                client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
                TestIPC.fail((String)"Expected an exception to have been thrown");
            }
            catch (Exception e) {
                LOG.info((Object)"caught expected exception", (Throwable)e);
                TestIPC.assertTrue((boolean)StringUtils.stringifyException((Throwable)e).contains("Injected fault"));
            }
            Mockito.reset((Object[])new SocketFactory[]{spyFactory});
            client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
        }
        finally {
            server.stop();
        }
    }

    public void testIpcTimeout() throws Exception {
        TestServer server = new TestServer(1, true);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Client client = new Client(LongWritable.class, conf);
        try {
            client.call((Writable)new LongWritable(RANDOM.nextLong()), addr, null, null, 500);
            TestIPC.fail((String)"Expected an exception to have been thrown");
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Get a SocketTimeoutException ", (Throwable)e);
        }
        client.call((Writable)new LongWritable(RANDOM.nextLong()), addr, null, null, 4000);
    }

    public void testErrorClient() throws Exception {
        TestServer server = new TestServer(1, false);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Client client = new Client(LongErrorWritable.class, conf);
        try {
            client.call((Writable)new LongErrorWritable(RANDOM.nextLong()), addr, null, null, 0, conf);
            TestIPC.fail((String)"Expected an exception to have been thrown");
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            TestIPC.assertTrue((boolean)(cause instanceof IOException));
            TestIPC.assertEquals((String)"Come across an exception while reading", (String)cause.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        new TestIPC("test").testParallel(10, false, 2, 4, 2, 4, 1000);
    }

    static {
        Client.setPingInterval((Configuration)conf, (int)1000);
        RANDOM = new Random();
    }

    private static class LongErrorWritable
    extends LongWritable {
        private static final String ERR_MSG = "Come across an exception while reading";

        LongErrorWritable() {
        }

        LongErrorWritable(long longValue) {
            super(longValue);
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            throw new IOException(ERR_MSG);
        }
    }

    private static class ParallelCaller
    extends Thread {
        private Client client;
        private int count;
        private InetSocketAddress[] addresses;
        private boolean failed;

        public ParallelCaller(Client client, InetSocketAddress[] addresses, int count) {
            this.client = client;
            this.addresses = addresses;
            this.count = count;
        }

        @Override
        public void run() {
            block2: for (int i = 0; i < this.count; ++i) {
                try {
                    Writable[] params = new Writable[this.addresses.length];
                    for (int j = 0; j < this.addresses.length; ++j) {
                        params[j] = new LongWritable(RANDOM.nextLong());
                    }
                    Writable[] values = this.client.call(params, this.addresses, null, null, conf);
                    for (int j = 0; j < this.addresses.length; ++j) {
                        if (params[j].equals(values[j])) continue;
                        LOG.fatal((Object)"Call failed!");
                        this.failed = true;
                        continue block2;
                    }
                    continue;
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Caught: " + StringUtils.stringifyException((Throwable)e)));
                    this.failed = true;
                }
            }
        }
    }

    private static class SerialCaller
    extends Thread {
        private Client client;
        private InetSocketAddress server;
        private int count;
        private boolean failed;

        public SerialCaller(Client client, InetSocketAddress server, int count) {
            this.client = client;
            this.server = server;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    LongWritable param = new LongWritable(RANDOM.nextLong());
                    LongWritable value = (LongWritable)this.client.call((Writable)param, this.server, null, null, 0, conf);
                    if (param.equals((Object)value)) continue;
                    LOG.fatal((Object)"Call failed!");
                    this.failed = true;
                    break;
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Caught: " + StringUtils.stringifyException((Throwable)e)));
                    this.failed = true;
                }
            }
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            super(TestIPC.ADDRESS, 0, LongWritable.class, handlerCount, conf);
            this.sleep = sleep;
        }

        public Writable call(Class<?> protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(RANDOM.nextInt(1000) + 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return param;
        }
    }
}

