/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeVersionCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultVersionCheck() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 1, true, null);
            DataNode dn = cluster.getDataNodes().get(0);
            NamespaceInfo currInfo = new NamespaceInfo(0, 0L, 0);
            Assert.assertTrue((boolean)dn.isPermittedVersion(currInfo));
            NamespaceInfo infoDiffRev = new NamespaceInfo(0, 0L, 0){

                public String getRevision() {
                    return "bogus";
                }
            };
            Assert.assertFalse((String)"Different revision is not permitted", (boolean)dn.isPermittedVersion(infoDiffRev));
            NamespaceInfo infoDiffVersion = new NamespaceInfo(0, 0L, 0){

                public String getVersion() {
                    return "bogus";
                }

                public String getRevision() {
                    return "bogus";
                }
            };
            Assert.assertFalse((String)"Different version is not permitted", (boolean)dn.isPermittedVersion(infoDiffVersion));
            NamespaceInfo bogusVersion = new NamespaceInfo(0, 0L, 0){

                public String getVersion() {
                    return "bogus";
                }
            };
            try {
                dn.isPermittedVersion(bogusVersion);
                Assert.fail((String)"Matched revision with mismatched version");
            }
            catch (AssertionError ae) {
                // empty catch block
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelaxedVersionCheck() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setBoolean("hadoop.relaxed.worker.version.check", true);
            cluster = new MiniDFSCluster(conf, 1, true, null);
            DataNode dn = cluster.getDataNodes().get(0);
            NamespaceInfo currInfo = new NamespaceInfo(0, 0L, 0);
            Assert.assertTrue((boolean)dn.isPermittedVersion(currInfo));
            NamespaceInfo infoDiffRev = new NamespaceInfo(0, 0L, 0){

                public String getRevision() {
                    return "bogus";
                }
            };
            Assert.assertTrue((String)"Different revisions should be permitted", (boolean)dn.isPermittedVersion(infoDiffRev));
            NamespaceInfo infoDiffVersion = new NamespaceInfo(0, 0L, 0){

                public String getVersion() {
                    return "bogus";
                }

                public String getRevision() {
                    return "bogus";
                }
            };
            Assert.assertFalse((String)"Different version is not permitted", (boolean)dn.isPermittedVersion(infoDiffVersion));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

