/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.TestInterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.BlockMetaDataInfo;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;

public class TestLeaseRecovery
extends TestCase {
    static final int BLOCK_SIZE = 1024;
    static final short REPLICATION_NUM = 3;

    static void checkMetaInfo(Block b, InterDatanodeProtocol idp) throws IOException {
        TestInterDatanodeProtocol.checkMetaInfo(b, idp, null);
    }

    static int min(Integer ... x) {
        int m = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (x[i] >= m) continue;
            m = x[i];
        }
        return m;
    }

    public void testBlockSynchronization() throws Exception {
        this.runTestBlockSynchronization(false);
    }

    public void testBlockSynchronizationWithZeroBlock() throws Exception {
        this.runTestBlockSynchronization(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestBlockSynchronization(boolean forceOneBlockToZero) throws Exception {
        int ORG_FILE_SIZE = 3000;
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.size", 1024L);
        conf.setBoolean("dfs.support.broken.append", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 5, true, null);
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            String filestr = "/foo";
            Path filepath = new Path(filestr);
            DFSTestUtil.createFile((FileSystem)dfs, filepath, 3000L, (short)3, 0L);
            TestLeaseRecovery.assertTrue((boolean)dfs.dfs.exists(filestr));
            DFSTestUtil.waitReplication((FileSystem)dfs, filepath, (short)3);
            LocatedBlock locatedblock = TestInterDatanodeProtocol.getLastLocatedBlock(dfs.dfs.namenode, filestr);
            DatanodeInfo[] datanodeinfos = locatedblock.getLocations();
            TestLeaseRecovery.assertEquals((int)3, (int)datanodeinfos.length);
            DataNode[] datanodes = new DataNode[3];
            for (int i = 0; i < 3; ++i) {
                datanodes[i] = cluster.getDataNode(datanodeinfos[i].getIpcPort());
                TestLeaseRecovery.assertTrue((datanodes[i] != null ? 1 : 0) != 0);
            }
            Block lastblock = locatedblock.getBlock();
            DataNode.LOG.info((Object)("newblocks=" + lastblock));
            for (int i = 0; i < 3; ++i) {
                TestLeaseRecovery.checkMetaInfo(lastblock, (InterDatanodeProtocol)datanodes[i]);
            }
            int lastblocksize = 952;
            Integer[] newblocksizes = new Integer[3];
            for (int i = 0; i < 3; ++i) {
                newblocksizes[i] = AppendTestUtil.nextInt(lastblocksize);
            }
            if (forceOneBlockToZero) {
                newblocksizes[0] = 0;
            }
            DataNode.LOG.info((Object)("newblocksizes = " + Arrays.asList(newblocksizes)));
            Block[] newblocks = new Block[3];
            for (int i = 0; i < 3; ++i) {
                DataNode dn = datanodes[i];
                FSDatasetTestUtil.truncateBlock(dn, lastblock, newblocksizes[i].intValue());
                newblocks[i] = new Block(lastblock.getBlockId(), (long)newblocksizes[i].intValue(), lastblock.getGenerationStamp());
                TestLeaseRecovery.checkMetaInfo(newblocks[i], (InterDatanodeProtocol)datanodes[i]);
            }
            DataNode.LOG.info((Object)("dfs.dfs.clientName=" + dfs.dfs.clientName));
            cluster.getNameNode().append(filestr, dfs.dfs.clientName);
            int primarydatanodeindex = AppendTestUtil.nextInt(datanodes.length);
            DataNode.LOG.info((Object)("primarydatanodeindex  =" + primarydatanodeindex));
            DataNode primary = datanodes[primarydatanodeindex];
            DataNode.LOG.info((Object)("primary.dnRegistration=" + primary.dnRegistration));
            primary.recoverBlocks(new Block[]{lastblock}, (DatanodeInfo[][])new DatanodeInfo[][]{datanodeinfos}).join();
            BlockMetaDataInfo[] updatedmetainfo = new BlockMetaDataInfo[3];
            int minsize = TestLeaseRecovery.min(newblocksizes);
            long currentGS = cluster.getNameNode().namesystem.getGenerationStamp();
            lastblock.setGenerationStamp(currentGS);
            for (int i = 0; i < 3; ++i) {
                updatedmetainfo[i] = datanodes[i].getBlockMetaDataInfo(lastblock);
                TestLeaseRecovery.assertEquals((long)lastblock.getBlockId(), (long)updatedmetainfo[i].getBlockId());
                TestLeaseRecovery.assertEquals((long)minsize, (long)updatedmetainfo[i].getNumBytes());
                TestLeaseRecovery.assertEquals((long)currentGS, (long)updatedmetainfo[i].getGenerationStamp());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

