/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.log4j.Level;

public class TestFileCreationDelete
extends TestCase {
    public TestFileCreationDelete() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationDeleteParent() throws IOException {
        Configuration conf = new Configuration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("heartbeat.recheck.interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            int nnport = cluster.getNameNodePort();
            Path dir = new Path("/foo");
            Path file1 = new Path(dir, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile(fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1, 1000);
            stm1.sync();
            Path file2 = new Path("/file2");
            FSDataOutputStream stm2 = TestFileCreation.createFile(fs, file2, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file2);
            TestFileCreation.writeFile(stm2, 1000);
            stm2.sync();
            fs.delete(dir, true);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster(nnport, conf, 1, false, true, null, null, null);
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster(nnport, conf, 1, false, true, null, null, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            TestFileCreationDelete.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            TestFileCreationDelete.assertTrue((boolean)fs.exists(file2));
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

