/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestHarFileSystem
extends TestCase {
    private Path inputPath;
    private Path inputrelPath;
    private MiniDFSCluster dfscluster;
    private MiniMRCluster mapred;
    private FileSystem fs;
    private Path filea;
    private Path fileb;
    private Path filec;
    private Path archivePath;

    protected void setUp() throws Exception {
        super.setUp();
        this.dfscluster = new MiniDFSCluster(new Configuration(), 2, true, null);
        this.fs = this.dfscluster.getFileSystem();
        this.mapred = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        this.inputPath = new Path(this.fs.getHomeDirectory(), "test");
        this.inputrelPath = new Path(this.fs.getHomeDirectory().toUri().getPath().substring(1), "test");
        this.filea = new Path(this.inputPath, "a");
        this.fileb = new Path(this.inputPath, "b");
        this.filec = new Path(this.inputPath, "c c");
        this.archivePath = new Path(this.fs.getHomeDirectory(), "tmp");
        this.fs.mkdirs(this.inputPath);
        FSDataOutputStream out = this.fs.create(this.filea);
        out.write("a".getBytes());
        out.close();
        out = this.fs.create(this.fileb);
        out.write("b".getBytes());
        out.close();
        out = this.fs.create(this.filec);
        out.write("c".getBytes());
        out.close();
    }

    protected void tearDown() throws Exception {
        try {
            if (this.mapred != null) {
                this.mapred.shutdown();
            }
            if (this.dfscluster != null) {
                this.dfscluster.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        super.tearDown();
    }

    private void checkBytes(Path harPath, Configuration conf) throws IOException {
        Path harFilea = new Path(harPath, "a");
        Path harFileb = new Path(harPath, "b");
        Path harFilec = new Path(harPath, "c c");
        FileSystem harFs = harFilea.getFileSystem(conf);
        FSDataInputStream fin = harFs.open(harFilea);
        byte[] b = new byte[4];
        int readBytes = fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "a".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFileb);
        fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "b".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFilec);
        fin.read(b);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "c".getBytes()[0] ? 1 : 0) != 0);
    }

    private void checkProperties(Path harPath, Configuration conf) throws IOException {
        Path harFilea = new Path(harPath, "a");
        Path harFileb = new Path(harPath, "b");
        Path harFilec = new Path(harPath, "c c");
        FileSystem harFs = harFilea.getFileSystem(conf);
        Path nonharFilea = new Path(this.inputPath, "a");
        Path nonharFileb = new Path(this.inputPath, "b");
        Path nonharFilec = new Path(this.inputPath, "c c");
        FileSystem nonharFs = nonharFilea.getFileSystem(conf);
        TestHarFileSystem.assertEquals((String)"Modification times do not match for a", (long)harFs.getFileStatus(harFilea).getModificationTime(), (long)nonharFs.getFileStatus(nonharFilea).getModificationTime());
        TestHarFileSystem.assertEquals((String)"Modification times do not match for b", (long)harFs.getFileStatus(harFileb).getModificationTime(), (long)nonharFs.getFileStatus(nonharFileb).getModificationTime());
        TestHarFileSystem.assertEquals((String)"Modification times do not match for c", (long)harFs.getFileStatus(harFilec).getModificationTime(), (long)nonharFs.getFileStatus(nonharFilec).getModificationTime());
    }

    private void checkBlockSize(FileSystem fs, Path finalPath, long blockSize) throws IOException {
        FileStatus[] statuses;
        for (FileStatus status : statuses = fs.globStatus(new Path(finalPath, "part-*"))) {
            TestHarFileSystem.assertTrue((status.getBlockSize() == blockSize ? 1 : 0) != 0);
        }
    }

    public void testRelativeArchives() throws Exception {
        this.fs.delete(this.archivePath, true);
        JobConf conf = this.mapred.createJobConf();
        HadoopArchives har = new HadoopArchives((Configuration)conf);
        String[] args = new String[]{"-archiveName", "foo1.har", "-p", this.fs.getHomeDirectory().toString(), "test", this.archivePath.toString()};
        int ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((String)"failed test", (ret == 0 ? 1 : 0) != 0);
        Path finalPath = new Path(this.archivePath, "foo1.har");
        Path fsPath = new Path(this.inputPath.toUri().getPath());
        Path filePath = new Path(finalPath, "test");
        Path harPath = new Path("har://" + filePath.toUri().getPath());
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_index")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_masterindex")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "part-0")));
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "part-1")) ? 1 : 0) != 0);
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "part-2")) ? 1 : 0) != 0);
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "_logs")) ? 1 : 0) != 0);
        FileStatus[] statuses = this.fs.listStatus(finalPath);
        args = new String[]{"-ls", harPath.toString()};
        FsShell shell = new FsShell((Configuration)conf);
        ret = ToolRunner.run((Tool)shell, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        this.checkBytes(harPath, (Configuration)conf);
        this.checkProperties(harPath, (Configuration)conf);
        this.checkBlockSize(this.fs, finalPath, 0x20000000L);
        args = new String[]{"-Dhar.block.size=512", "-Dhar.partfile.size=1", "-archiveName", "foo.har", "-p", this.fs.getHomeDirectory().toString(), "test", this.archivePath.toString()};
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((String)"failed test", (ret == 0 ? 1 : 0) != 0);
        finalPath = new Path(this.archivePath, "foo.har");
        fsPath = new Path(this.inputPath.toUri().getPath());
        filePath = new Path(finalPath, "test");
        harPath = new Path("har://" + filePath.toUri().getPath());
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_index")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_masterindex")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "part-0")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "part-1")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "part-2")));
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "_logs")) ? 1 : 0) != 0);
        statuses = this.fs.listStatus(finalPath);
        args = new String[]{"-ls", harPath.toString()};
        shell = new FsShell((Configuration)conf);
        ret = ToolRunner.run((Tool)shell, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        this.checkBytes(harPath, (Configuration)conf);
        this.checkProperties(harPath, (Configuration)conf);
        this.checkBlockSize(this.fs, finalPath, 512L);
    }

    public void testArchivesWithMapred() throws Exception {
        this.fs.delete(this.archivePath, true);
        JobConf conf = this.mapred.createJobConf();
        HadoopArchives har = new HadoopArchives((Configuration)conf);
        String[] args = new String[]{"-archiveName", "foo.har", "-p", "/"};
        int ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args = new String[]{"-archiveName", "/d/foo.har", "-p", "/", this.inputrelPath.toString(), this.archivePath.toString()};
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args[1] = "foo.har";
        args[5] = this.filec.toString();
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        args[0] = "-archiveName";
        args[1] = "foo.har";
        args[2] = "-p";
        args[3] = "/";
        args[4] = this.inputrelPath.toString();
        args[5] = this.archivePath.toString();
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((ret != 0 ? 1 : 0) != 0);
        Path finalPath = new Path(this.archivePath, "foo.har");
        Path fsPath = new Path(this.inputPath.toUri().getPath());
        String relative = fsPath.toString().substring(1);
        Path filePath = new Path(finalPath, relative);
        URI uri = this.fs.getUri();
        Path harPath = new Path("har://hdfs-" + uri.getHost() + ":" + uri.getPort() + filePath.toUri().getPath());
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_index")));
        TestHarFileSystem.assertTrue((boolean)this.fs.exists(new Path(finalPath, "_masterindex")));
        TestHarFileSystem.assertTrue((!this.fs.exists(new Path(finalPath, "_logs")) ? 1 : 0) != 0);
        FsShell shell = new FsShell((Configuration)conf);
        args = new String[]{"-ls", harPath.toString()};
        ret = ToolRunner.run((Tool)shell, (String[])args);
        TestHarFileSystem.assertTrue((ret == 0 ? 1 : 0) != 0);
        Path harFilea = new Path(harPath, "a");
        Path harFileb = new Path(harPath, "b");
        Path harFilec = new Path(harPath, "c c");
        FileSystem harFs = harFilea.getFileSystem((Configuration)conf);
        FSDataInputStream fin = harFs.open(harFilea);
        byte[] b = new byte[4];
        int readBytes = fin.read(b);
        TestHarFileSystem.assertTrue((String)"Empty read.", (readBytes > 0 ? 1 : 0) != 0);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "a".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFileb);
        readBytes = fin.read(b);
        TestHarFileSystem.assertTrue((String)"Empty read.", (readBytes > 0 ? 1 : 0) != 0);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "b".getBytes()[0] ? 1 : 0) != 0);
        fin = harFs.open(harFilec);
        readBytes = fin.read(b);
        TestHarFileSystem.assertTrue((String)"Empty read.", (readBytes > 0 ? 1 : 0) != 0);
        fin.close();
        TestHarFileSystem.assertTrue((String)"strings are equal ", (b[0] == "c".getBytes()[0] ? 1 : 0) != 0);
        FileSystem fsHar = harPath.getFileSystem((Configuration)conf);
        FileStatus[] bla = fsHar.listStatus(harPath);
        Path outdir = new Path(this.fs.getHomeDirectory(), "mapout");
        JobConf jobconf = this.mapred.createJobConf();
        FileInputFormat.addInputPath((JobConf)jobconf, (Path)harPath);
        jobconf.setInputFormat(TextInputFormat.class);
        jobconf.setOutputFormat(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)jobconf, (Path)outdir);
        jobconf.setMapperClass(TextMapperReducer.class);
        jobconf.setMapOutputKeyClass(Text.class);
        jobconf.setMapOutputValueClass(Text.class);
        jobconf.setReducerClass(TextMapperReducer.class);
        jobconf.setNumReduceTasks(1);
        JobClient.runJob((JobConf)jobconf);
        args[1] = outdir.toString();
        ret = ToolRunner.run((Tool)shell, (String[])args);
        FileStatus[] status = this.fs.globStatus(new Path(outdir, "part*"));
        Path reduceFile = status[0].getPath();
        FSDataInputStream reduceIn = this.fs.open(reduceFile);
        b = new byte[6];
        readBytes = reduceIn.read(b);
        TestHarFileSystem.assertTrue((String)("Should read 6 bytes instead of " + readBytes + "."), (readBytes == 6 ? 1 : 0) != 0);
        Text readTxt = new Text(b);
        TestHarFileSystem.assertTrue((boolean)"a\nb\nc\n".equals(readTxt.toString()));
        TestHarFileSystem.assertTrue((String)"number of bytes left should be -1", (reduceIn.read(b) == -1 ? 1 : 0) != 0);
        reduceIn.close();
    }

    public void testGetFileBlockLocations() throws Exception {
        FileStatus[] statuses;
        this.fs.delete(this.archivePath, true);
        JobConf conf = this.mapred.createJobConf();
        HadoopArchives har = new HadoopArchives((Configuration)conf);
        String[] args = new String[]{"-Dhar.block.size=512", "-Dhar.partfile.size=1", "-archiveName", "foo bar.har", "-p", this.fs.getHomeDirectory().toString(), "test", this.archivePath.toString()};
        int ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((String)"failed test", (ret == 0 ? 1 : 0) != 0);
        Path finalPath = new Path(this.archivePath, "foo bar.har");
        Path fsPath = new Path(this.inputPath.toUri().getPath());
        Path filePath = new Path(finalPath, "test");
        Path filea = new Path(filePath, "a");
        Path harPath = new Path("har://" + filea.toUri().getPath());
        FileSystem harFs = harPath.getFileSystem((Configuration)conf);
        for (FileStatus status : statuses = harFs.listStatus(filePath)) {
            BlockLocation[] locations = harFs.getFileBlockLocations(status, 0L, status.getLen());
            long lastOffset = 0L;
            TestHarFileSystem.assertEquals((String)"Only one block location expected for files this small", (int)1, (int)locations.length);
            TestHarFileSystem.assertEquals((String)"Block location should start at offset 0", (long)0L, (long)locations[0].getOffset());
        }
    }

    public void testSpaces() throws Exception {
        this.fs.delete(this.archivePath, true);
        JobConf conf = this.mapred.createJobConf();
        HadoopArchives har = new HadoopArchives((Configuration)conf);
        String[] args = new String[]{"-archiveName", "foo bar.har", "-p", this.fs.getHomeDirectory().toString(), "test", this.archivePath.toString()};
        int ret = ToolRunner.run((Tool)har, (String[])args);
        TestHarFileSystem.assertTrue((String)"failed test", (ret == 0 ? 1 : 0) != 0);
        Path finalPath = new Path(this.archivePath, "foo bar.har");
        Path fsPath = new Path(this.inputPath.toUri().getPath());
        Path filePath = new Path(finalPath, "test");
        Path harPath = new Path("har://" + filePath.toUri().getPath());
        FileSystem harFs = harPath.getFileSystem((Configuration)conf);
        FileStatus[] statuses = harFs.listStatus(finalPath);
    }

    static class TextMapperReducer
    implements Mapper<LongWritable, Text, Text, Text>,
    Reducer<Text, Text, Text, Text> {
        TextMapperReducer() {
        }

        public void configure(JobConf conf) {
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            output.collect((Object)value, (Object)new Text(""));
        }

        public void close() throws IOException {
        }

        public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                values.next();
                output.collect((Object)key, null);
            }
        }
    }
}

