/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class TestCodec
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestCodec.class);
    private Configuration conf = new Configuration();
    private int count = 10000;
    private int seed = new Random().nextInt();

    public void testDefaultCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.DefaultCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.DefaultCodec");
    }

    public void testGzipCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    public void testBZip2Codec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    private static void codecTest(Configuration conf, int seed, int count, String codecClass) throws IOException {
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        LOG.info((Object)("Created a Codec object of type: " + codecClass));
        DataOutputBuffer data = new DataOutputBuffer();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        DataInputBuffer originalData = new DataInputBuffer();
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
        originalData.reset(data.getData(), 0, data.getLength());
        LOG.info((Object)("Generated " + count + " records"));
        DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
        CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)compressedDataBuffer);
        DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
        deflateOut.write(data.getData(), 0, data.getLength());
        deflateOut.flush();
        deflateFilter.finish();
        LOG.info((Object)"Finished compressing data");
        DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        CompressionInputStream inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);
        DataInputStream inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
        for (int i = 0; i < count; ++i) {
            RandomDatum k1 = new RandomDatum();
            RandomDatum v1 = new RandomDatum();
            k1.readFields(originalIn);
            v1.readFields(originalIn);
            RandomDatum k2 = new RandomDatum();
            RandomDatum v2 = new RandomDatum();
            k2.readFields(inflateIn);
            v2.readFields(inflateIn);
        }
        LOG.info((Object)("SUCCESS! Completed checking " + count + " records"));
    }

    public void testCodecPoolGzipReuse() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.native.lib", true);
        if (!ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            LOG.warn((Object)"testCodecPoolGzipReuse skipped: native libs not loaded");
            return;
        }
        GzipCodec gzc = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        DefaultCodec dfc = (DefaultCodec)ReflectionUtils.newInstance(DefaultCodec.class, (Configuration)conf);
        Compressor c1 = CodecPool.getCompressor((CompressionCodec)gzc);
        Compressor c2 = CodecPool.getCompressor((CompressionCodec)dfc);
        CodecPool.returnCompressor((Compressor)c1);
        CodecPool.returnCompressor((Compressor)c2);
        TestCodec.assertTrue((String)"Got mismatched ZlibCompressor", (c2 != CodecPool.getCompressor((CompressionCodec)gzc) ? 1 : 0) != 0);
    }

    public void testSequenceFileDefaultCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.DefaultCodec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.DefaultCodec", 1000000);
    }

    public void testSequenceFileBZip2Codec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 0, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.BZip2Codec", 1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequenceFileCodecTest(Configuration conf, int lines, String codecClass, int blockSize) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Writable value;
        Text key;
        Path filePath = new Path("SequenceFileCodecTest." + codecClass);
        conf.setInt("io.seqfile.compress.blocksize", blockSize);
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Creating SequenceFile with codec \"" + codecClass + "\""));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)filePath, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)((CompressionCodec)Class.forName(codecClass).newInstance()));
        LOG.info((Object)"Writing to SequenceFile...");
        for (int i = 0; i < lines; ++i) {
            key = new Text("key" + i);
            value = new Text("value" + i);
            writer.append((Writable)key, value);
        }
        writer.close();
        LOG.info((Object)"Reading from the SequenceFile...");
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, filePath, conf);
        key = (Writable)reader.getKeyClass().newInstance();
        value = (Writable)reader.getValueClass().newInstance();
        int lc = 0;
        try {
            while (reader.next((Writable)key, value)) {
                TestCodec.assertEquals((String)("key" + lc), (String)key.toString());
                TestCodec.assertEquals((String)("value" + lc), (String)value.toString());
                ++lc;
            }
        }
        finally {
            reader.close();
        }
        TestCodec.assertEquals((int)lines, (int)lc);
        fs.delete(filePath, false);
        LOG.info((Object)("SUCCESS! Completed SequenceFileCodecTest with codec \"" + codecClass + "\""));
    }

    public static void main(String[] args) {
        int count = 10000;
        String codecClass = "org.apache.hadoop.io.compress.DefaultCodec";
        String usage = "TestCodec [-count N] [-codec <codec class>]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (!args[i].equals("-codec")) continue;
                codecClass = args[++i];
            }
            Configuration conf = new Configuration();
            int seed = 0;
            TestCodec.codecTest(conf, seed, count, codecClass);
        }
        catch (Exception e) {
            System.err.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public TestCodec(String name) {
        super(name);
    }

    public void testCodecPoolAndGzipDecompressor() {
        Decompressor poolDecompressor;
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.native.lib", false);
        TestCodec.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        TestCodec.assertNotNull((String)"zlibDecompressor is null!", (Object)zlibDecompressor);
        TestCodec.assertTrue((String)"ZlibFactory returned unexpected inflator", (boolean)(zlibDecompressor instanceof BuiltInZlibInflater));
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        TestCodec.assertTrue((String)"Codec for .gz file is not GzipCodec", (boolean)(codec instanceof GzipCodec));
        Decompressor codecDecompressor = codec.createDecompressor();
        if (null != codecDecompressor) {
            TestCodec.fail((String)("Got non-null codecDecompressor: " + codecDecompressor));
        }
        if (null != (poolDecompressor = CodecPool.getDecompressor((CompressionCodec)codec))) {
            TestCodec.fail((String)("Got non-null poolDecompressor: " + poolDecompressor));
        }
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        poolDecompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        if (null != poolDecompressor) {
            TestCodec.fail((String)("Second time, got non-null poolDecompressor: " + poolDecompressor));
        }
    }

    public void testGzipCodecRead() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.native.lib", false);
        TestCodec.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        TestCodec.assertNotNull((String)"zlibDecompressor is null!", (Object)zlibDecompressor);
        TestCodec.assertTrue((String)"ZlibFactory returned unexpected inflator", (boolean)(zlibDecompressor instanceof BuiltInZlibInflater));
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        Path f = new Path(new Path(tmpDir), "testGzipCodecRead.txt.gz");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f.toString()))));
        String msg = "This is the message in the file!";
        bw.write("This is the message in the file!");
        bw.close();
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));
        String line = br.readLine();
        TestCodec.assertEquals((String)"Didn't get the same message back!", (String)"This is the message in the file!", (String)line);
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGzipFile(String filename, String msg) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        try {
            String line = r.readLine();
            TestCodec.assertEquals((String)("Got invalid line back from " + filename), (String)msg, (String)line);
        }
        finally {
            r.close();
            new File(filename).delete();
        }
    }

    public void testGzipCodecWrite() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.native.lib", false);
        TestCodec.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
        TestCodec.assertNotNull((String)"zlibCompressor is null!", (Object)zlibCompressor);
        TestCodec.assertTrue((String)"ZlibFactory returned unexpected deflator", (boolean)(zlibCompressor instanceof BuiltInZlibDeflater));
        CodecPool.returnCompressor((Compressor)zlibCompressor);
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        TestCodec.assertTrue((String)"Codec for .gz file is not GzipCodec", (boolean)(codec instanceof GzipCodec));
        String msg = "This is the message we are going to compress.";
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        String fileName = new Path(new Path(tmpDir), "testGzipCodecWrite.txt.gz").toString();
        BufferedWriter w = null;
        Compressor gzipCompressor = CodecPool.getCompressor((CompressionCodec)codec);
        if (null != gzipCompressor) {
            CompressorStream os = new CompressorStream((OutputStream)new FileOutputStream(fileName), gzipCompressor);
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
            w.write("This is the message we are going to compress.");
            w.close();
            CodecPool.returnCompressor((Compressor)gzipCompressor);
            this.verifyGzipFile(fileName, "This is the message we are going to compress.");
        }
        w = new BufferedWriter(new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(fileName))));
        w.write("This is the message we are going to compress.");
        w.close();
        this.verifyGzipFile(fileName, "This is the message we are going to compress.");
    }
}

