/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMetrics;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.mortbay.log.Log;

public class TestNameNodeMetrics
extends TestCase {
    private static final int DATANODE_COUNT = 3;
    private static final Configuration CONF = new Configuration();
    private MiniDFSCluster cluster;
    private FSNamesystemMetrics metrics;
    private DistributedFileSystem fs;
    private Random rand = new Random();
    private FSNamesystem namesystem;
    private NameNodeMetrics nnMetrics;
    private NameNode nn;

    protected void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(CONF, 3, true, null);
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.fs = (DistributedFileSystem)this.cluster.getFileSystem();
        this.metrics = this.namesystem.getFSNamesystemMetrics();
        this.nn = this.cluster.getNameNode();
        TestNameNodeMetrics testNameNodeMetrics = this;
        this.nnMetrics = testNameNodeMetrics.nn.getNameNodeMetrics();
    }

    protected void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(String fileName, long fileLen, short replicas) throws IOException {
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, fileLen, replicas, this.rand.nextLong());
    }

    private void updateMetrics() throws Exception {
        Thread.sleep(1000L);
        this.metrics.doUpdates(null);
    }

    private void updateNNMetrics() throws Exception {
        Thread.sleep(1000L);
        this.nnMetrics.doUpdates(null);
    }

    private void readFile(FileSystem fileSys, String path) throws IOException {
        Path name = new Path(path);
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        int bytesRead = stm.read(buffer, 0, 4);
        stm.close();
    }

    public void testFileAdd() throws Exception {
        String file = "/tmp/t";
        this.createFile("/tmp/t", 3200L, (short)3);
        int blockCount = 32;
        int blockCapacity = this.namesystem.getBlockCapacity();
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)blockCapacity, (int)this.metrics.blockCapacity.get());
        int threshold = (int)((float)blockCapacity * 0.75f);
        while (threshold < 32) {
            blockCapacity <<= 1;
        }
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)3, (int)this.metrics.filesTotal.get());
        TestNameNodeMetrics.assertEquals((long)32L, (long)this.metrics.blocksTotal.get());
        TestNameNodeMetrics.assertEquals((int)blockCapacity, (int)this.metrics.blockCapacity.get());
        this.fs.delete(new Path("/tmp/t"), true);
    }

    public void testCorruptBlock() throws Exception {
        String file = "/tmp/t";
        this.createFile(file, 100L, (short)2);
        LocatedBlock block = this.namesystem.getBlockLocations(file, 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.corruptBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.pendingReplicationBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.scheduledReplicationBlocks.get());
        this.fs.delete(new Path(file), true);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.corruptBlocks.get());
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.pendingReplicationBlocks.get());
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.scheduledReplicationBlocks.get());
    }

    public void testExcessBlocks() throws Exception {
        String file = "/tmp/t";
        this.createFile(file, 100L, (short)2);
        int totalBlocks = 1;
        this.namesystem.setReplication(file, (short)1);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)totalBlocks, (int)this.metrics.excessBlocks.get());
        TestNameNodeMetrics.assertEquals((int)totalBlocks, (int)this.metrics.pendingDeletionBlocks.get());
        this.fs.delete(new Path(file), true);
    }

    public void testMissingBlock() throws Exception {
        String file = "/tmp/t";
        this.createFile(file, 100L, (short)1);
        LocatedBlock block = this.namesystem.getBlockLocations(file, 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.underReplicatedBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.missingBlocks.get());
        this.fs.delete(new Path(file), true);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.underReplicatedBlocks.get());
    }

    public void testGetBlockLocationMetric() throws Exception {
        String METHOD_NAME = "TestGetBlockLocationMetric";
        Log.info((String)"Running test TestGetBlockLocationMetric");
        String file1_path = "/tmp/filePath";
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.createFile(file1_path, 100L, (short)2);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.readFile((FileSystem)this.fs, file1_path);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)1, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.readFile((FileSystem)this.fs, file1_path);
        this.readFile((FileSystem)this.fs, file1_path);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)2, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((String)"Metrics TotalLoad is incorrect", (int)3, (int)this.metrics.totalLoad.get());
    }

    static {
        CONF.setLong("dfs.block.size", 100L);
        CONF.setInt("io.bytes.per.checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.replication.interval", 1);
    }
}

