/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.PermissionChecker;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class TestFsck
extends TestCase {
    static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        PrintStream oldOut = System.out;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(bStream, true);
        System.setOut(newOut);
        ((Log4JLogger)PermissionChecker.LOG).getLogger().setLevel(Level.ALL);
        int errCode = ToolRunner.run((Tool)new DFSck(conf), (String[])path);
        if (checkErrorCode) {
            TestFsck.assertEquals((int)expectedErrCode, (int)errCode);
        }
        ((Log4JLogger)PermissionChecker.LOG).getLogger().setLevel(Level.INFO);
        System.setOut(oldOut);
        return bStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsck() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 20, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster(conf, 4, true, null);
            fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            util.waitReplication(fs, "/srcdat", (short)3);
            String outStr = TestFsck.runFsck(conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            System.out.println(outStr);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
            cluster = new MiniDFSCluster(conf, 0, false, null);
            outStr = TestFsck.runFsck(conf, 1, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            System.out.println(outStr);
            cluster.startDataNodes(conf, 4, true, null, null);
            cluster.waitActive();
            cluster.waitClusterUp();
            fs = cluster.getFileSystem();
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckNonExistent() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 20, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster(conf, 4, true, null);
            fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            util.waitReplication(fs, "/srcdat", (short)3);
            String outStr = TestFsck.runFsck(conf, 0, true, "/non-existent");
            TestFsck.assertEquals((int)-1, (int)outStr.indexOf("is HEALTHY"));
            System.out.println(outStr);
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckMove() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 5, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster(conf, 4, true, null);
            String topDir = "/srcdat";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles(fs, topDir);
            util.waitReplication(fs, topDir, (short)3);
            String outStr = TestFsck.runFsck(conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            String[] fileNames = util.getFileNames(topDir);
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            String block = dfsClient.namenode.getBlockLocations(fileNames[0], 0L, Long.MAX_VALUE).get(0).getBlock().getBlockName();
            File baseDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/data");
            for (int i = 0; i < 8; ++i) {
                File blockFile = new File(baseDir, "data" + (i + 1) + "/current/" + block);
                if (!blockFile.exists()) continue;
                TestFsck.assertTrue((boolean)blockFile.delete());
            }
            outStr = TestFsck.runFsck(conf, 1, false, "/");
            while (!outStr.contains("is CORRUPT")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                outStr = TestFsck.runFsck(conf, 1, false, "/");
            }
            outStr = TestFsck.runFsck(conf, 1, true, "/", "-move");
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            outStr = TestFsck.runFsck(conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            util.cleanup(fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckOpenFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFsck", 4, 3, 8192);
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("dfs.blockreport.intervalMsec", 10000L);
            cluster = new MiniDFSCluster(conf, 4, true, null);
            String topDir = "/srcdat";
            String randomString = "HADOOP  ";
            fs = cluster.getFileSystem();
            cluster.waitActive();
            util.createFiles(fs, topDir);
            util.waitReplication(fs, topDir, (short)3);
            String outStr = TestFsck.runFsck(conf, 0, true, "/");
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Path openFile = new Path(topDir + "/openFile");
            FSDataOutputStream out = fs.create(openFile);
            for (int writeCount = 0; writeCount != 100; ++writeCount) {
                out.write(randomString.getBytes());
            }
            outStr = TestFsck.runFsck(conf, 0, true, topDir);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            TestFsck.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            outStr = TestFsck.runFsck(conf, 0, true, topDir, "-openforwrite");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
            TestFsck.assertTrue((boolean)outStr.contains("openFile"));
            out.close();
            outStr = TestFsck.runFsck(conf, 0, true, topDir);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            TestFsck.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
            util.cleanup(fs, topDir);
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cluster.shutdown();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {}
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorruptBlock() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        FileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 3, true, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path file1 = new Path("/testCorruptBlock");
            DFSTestUtil.createFile(fs, file1, 1024L, (short)3, 0L);
            DFSTestUtil.waitReplication(fs, file1, (short)3);
            String block = DFSTestUtil.getFirstBlock(fs, file1).getBlockName();
            outStr = TestFsck.runFsck(conf, 0, true, "/");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is HEALTHY"));
            File baseDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/data");
            for (int i = 0; i < 6; ++i) {
                File blockFile = new File(baseDir, "data" + (i + 1) + "/current/" + block);
                if (!blockFile.exists()) continue;
                RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
                FileChannel channel = raFile.getChannel();
                String badString = "BADBAD";
                int rand = random.nextInt((int)channel.size() / 2);
                raFile.seek(rand);
                raFile.write(badString.getBytes());
                raFile.close();
            }
            try {
                IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            }
            catch (IOException ie) {
                // empty catch block
            }
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            blocks = dfsClient.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
            while (replicaCount != 3) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                blocks = dfsClient.namenode.getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
                replicaCount = blocks.get(0).getLocations().length;
            }
            TestFsck.assertTrue((boolean)blocks.get(0).isCorrupt());
            outStr = TestFsck.runFsck(conf, 1, true, "/");
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("is CORRUPT"));
            TestFsck.assertTrue((boolean)outStr.contains("testCorruptBlock"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsckError() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 1, true, null);
            String fileName = "/test.txt";
            Path filePath = new Path(fileName);
            FileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, filePath, 1L, (short)1, 1L);
            DFSTestUtil.waitReplication(fs, filePath, (short)1);
            INodeFile node = (INodeFile)cluster.getNameNode().namesystem.dir.rootDir.getNode(fileName);
            TestFsck.assertEquals((int)node.blocks.length, (int)1);
            node.blocks[0].setNumBytes(-1L);
            String outStr = TestFsck.runFsck(conf, -1, true, fileName);
            System.out.println(outStr);
            TestFsck.assertTrue((boolean)outStr.contains("FAILED"));
            fs.delete(filePath, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

