/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class AutoInputFormat
extends FileInputFormat {
    private TextInputFormat textInputFormat = new TextInputFormat();
    private SequenceFileInputFormat seqFileInputFormat = new SequenceFileInputFormat();

    public void configure(JobConf job) {
        this.textInputFormat.configure(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        FileSystem fs = FileSystem.get((Configuration)job);
        FSDataInputStream is = fs.open(fileSplit.getPath());
        byte[] header = new byte[3];
        RecordReader reader = null;
        try {
            is.readFully(header);
        }
        catch (EOFException eof) {
            reader = this.textInputFormat.getRecordReader(split, job, reporter);
        }
        finally {
            is.close();
        }
        reader = header[0] == 83 && header[1] == 69 && header[2] == 81 ? this.seqFileInputFormat.getRecordReader(split, job, reporter) : this.textInputFormat.getRecordReader(split, job, reporter);
        return reader;
    }
}

