/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.ssl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEncryptedShuffle {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestEncryptedShuffle.class.getSimpleName();
    private String classpathDir;
    private MiniDFSCluster dfsCluster = null;
    private MiniMRClientCluster mrCluster = null;

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @Before
    public void createCustomYarnClasspath() throws Exception {
        this.classpathDir = KeyStoreTestUtil.getClasspathDir(TestEncryptedShuffle.class);
        new File(this.classpathDir, "core-site.xml").delete();
    }

    @After
    public void cleanUpMiniClusterSpecialConfig() throws Exception {
        new File(this.classpathDir, "core-site.xml").delete();
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)this.classpathDir);
    }

    private void startCluster(Configuration conf) throws Exception {
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", "target/test-dir");
        }
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        String cp = conf.get("yarn.application.classpath", StringUtils.join((CharSequence)",", (String[])YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) + File.pathSeparator + this.classpathDir;
        conf.set("yarn.application.classpath", cp);
        this.dfsCluster = new MiniDFSCluster(conf, 1, true, null);
        DistributedFileSystem fileSystem = this.dfsCluster.getFileSystem();
        fileSystem.mkdirs(new Path("/tmp"));
        fileSystem.mkdirs(new Path("/user"));
        fileSystem.mkdirs(new Path("/hadoop/mapred/system"));
        fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/hadoop/mapred/system"), FsPermission.valueOf((String)"-rwx------"));
        FileSystem.setDefaultUri((Configuration)conf, (URI)fileSystem.getUri());
        this.mrCluster = MiniMRClientClusterFactory.create(this.getClass(), 1, conf);
        FileWriter writer = new FileWriter(this.classpathDir + "/core-site.xml");
        this.mrCluster.getConfig().writeXml((Writer)writer);
        ((Writer)writer).close();
    }

    private void stopCluster() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.stop();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
    }

    protected JobConf getJobConf() throws IOException {
        return new JobConf(this.mrCluster.getConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptedShuffleWithCerts(boolean useClientCerts) throws Exception {
        try {
            Configuration conf = new Configuration();
            String keystoresDir = new File(BASEDIR).getAbsolutePath();
            String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestEncryptedShuffle.class);
            KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfsDir, (Configuration)conf, (boolean)useClientCerts);
            conf.setBoolean("mapreduce.shuffle.ssl.enabled", true);
            this.startCluster(conf);
            FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
            Path inputDir = new Path("input");
            fs.mkdirs(inputDir);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
            writer.write("hello");
            ((Writer)writer).close();
            Path outputDir = new Path("output", "output");
            JobConf jobConf = new JobConf((Configuration)this.getJobConf());
            jobConf.setInt("mapred.map.tasks", 1);
            jobConf.setInt("mapred.map.max.attempts", 1);
            jobConf.setInt("mapred.reduce.max.attempts", 1);
            jobConf.set("mapred.input.dir", inputDir.toString());
            jobConf.set("mapred.output.dir", outputDir.toString());
            JobClient jobClient = new JobClient(jobConf);
            RunningJob runJob = jobClient.submitJob(jobConf);
            runJob.waitForCompletion();
            Assert.assertTrue((boolean)runJob.isComplete());
            Assert.assertTrue((boolean)runJob.isSuccessful());
        }
        finally {
            this.stopCluster();
        }
    }

    @Test
    public void encryptedShuffleWithClientCerts() throws Exception {
        this.encryptedShuffleWithCerts(true);
    }

    @Test
    public void encryptedShuffleWithoutClientCerts() throws Exception {
        this.encryptedShuffleWithCerts(false);
    }
}

