/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestMRJobClient
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestMRJobClient.class);

    private Job runJob(Configuration conf) throws Exception {
        String input = "hello1\nhello2\nhello3\n";
        Job job = MapReduceTestUtil.createJob(conf, this.getInputDir(), this.getOutputDir(), 1, 1, input);
        job.setJobName("mr");
        job.setPriority(JobPriority.HIGH);
        job.waitForCompletion(true);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runTool(Configuration conf, Tool tool, String[] args, OutputStream out) throws Exception {
        PrintStream oldOut = System.out;
        PrintStream newOut = new PrintStream(out, true);
        try {
            System.setOut(newOut);
            int n = ToolRunner.run((Configuration)conf, (Tool)tool, (String[])args);
            return n;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    @Test
    public void testJobClient() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = this.runJob((Configuration)conf);
        String jobId = job.getJobID().toString();
        this.testGetCounter(jobId, (Configuration)conf);
        this.testJobList(jobId, (Configuration)conf);
        this.testChangingJobPriority(jobId, (Configuration)conf);
    }

    @Test
    public void testGetCounter(String jobId, Configuration conf) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-counter", jobId, "org.apache.hadoop.mapreduce.TaskCounter", "MAP_INPUT_RECORDS"}, out);
        TestMRJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        TestMRJobClient.assertEquals((String)"Counter", (String)"3", (String)out.toString().trim());
    }

    @Test
    public void testJobList(String jobId, Configuration conf) throws Exception {
        this.verifyJobPriority(jobId, "HIGH", conf, this.createJobClient());
    }

    protected void verifyJobPriority(String jobId, String priority, Configuration conf, CLI jc) throws Exception {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list", "all"}, pos);
        TestMRJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(pis));
        String line = null;
        while ((line = br.readLine()) != null) {
            LOG.info((Object)("line = " + line));
            if (!line.startsWith(jobId)) continue;
            TestMRJobClient.assertTrue((boolean)line.contains(priority));
            break;
        }
        pis.close();
    }

    @Test
    public void testChangingJobPriority(String jobId, Configuration conf) throws Exception {
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-set-priority", jobId, "VERY_LOW"}, new ByteArrayOutputStream());
        TestMRJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        this.verifyJobPriority(jobId, "VERY_LOW", conf, this.createJobClient());
    }

    @Test
    public void testMissingProfileOutput() throws Exception {
        JobConf conf = this.createJobConf();
        String input = "hello1\n";
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "hello1\n");
        job.setJobName("disable-profile-fetch");
        job.setProfileEnabled(true);
        job.setProfileParams("-agentlib:,verbose=n,file=%s");
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(1);
        job.setJobSetupCleanupNeeded(false);
        job.waitForCompletion(true);
        Job job2 = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "hello1\n");
        job2.setJobName("enable-profile-fetch");
        job2.setProfileEnabled(true);
        job2.setProfileParams("-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s");
        job2.setProfileTaskRange(true, "0-1");
        job2.setProfileTaskRange(false, "");
        job2.setMaxMapAttempts(1);
        job2.setMaxReduceAttempts(1);
        job2.setJobSetupCleanupNeeded(false);
        job2.waitForCompletion(true);
        TaskReport[] reports = job2.getTaskReports(TaskType.MAP);
        TestMRJobClient.assertTrue((String)"No task reports found!", (reports.length > 0 ? 1 : 0) != 0);
        TaskReport report = reports[0];
        TaskID id = report.getTaskId();
        TestMRJobClient.assertTrue((TaskType.MAP == id.getTaskType() ? 1 : 0) != 0);
        System.out.println("Using task id: " + id);
        TaskAttemptID attemptId = new TaskAttemptID(id, 0);
        File profileOutFile = new File(attemptId.toString() + ".profile");
        TestMRJobClient.assertTrue((String)"Couldn't find profiler output", (boolean)profileOutFile.exists());
        TestMRJobClient.assertTrue((String)"Couldn't remove profiler output", (boolean)profileOutFile.delete());
    }

    protected CLI createJobClient() throws IOException {
        return new CLI();
    }
}

