/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.HistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.ClusterInfo;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.Service;

public class JobHistory
extends AbstractService
implements HistoryContext {
    private static final Log LOG = LogFactory.getLog(JobHistory.class);
    public static final Pattern CONF_FILENAME_REGEX = Pattern.compile("(job_[0-9]+_[0-9]+)_conf.xml(?:\\.[0-9]+\\.old)?");
    public static final String OLD_SUFFIX = ".old";
    private long moveThreadInterval;
    private Configuration conf;
    private ScheduledThreadPoolExecutor scheduledExecutor = null;
    private HistoryStorage storage = null;
    private HistoryFileManager hsManager = null;
    private ApplicationAttemptId appAttemptID;
    private ApplicationId appID;
    private String userName;

    public void init(Configuration conf) throws YarnException {
        LOG.info((Object)"JobHistory Init");
        this.conf = conf;
        this.appID = (ApplicationId)RecordFactoryProvider.getRecordFactory((Configuration)conf).newRecordInstance(ApplicationId.class);
        this.appAttemptID = (ApplicationAttemptId)RecordFactoryProvider.getRecordFactory((Configuration)conf).newRecordInstance(ApplicationAttemptId.class);
        this.moveThreadInterval = conf.getLong("mapreduce.jobhistory.move.interval-ms", 180000L);
        this.hsManager = new HistoryFileManager();
        this.hsManager.init(conf);
        try {
            this.hsManager.initExisting();
        }
        catch (IOException e) {
            throw new YarnException("Failed to intialize existing directories", (Throwable)e);
        }
        this.storage = (HistoryStorage)ReflectionUtils.newInstance((Class)conf.getClass("mapreduce.jobhistory.store.class", CachedHistoryStorage.class, HistoryStorage.class), (Configuration)conf);
        if (this.storage instanceof Service) {
            ((Service)this.storage).init(conf);
        }
        this.storage.setHistoryFileManager(this.hsManager);
        super.init(conf);
    }

    public void start() {
        this.hsManager.start();
        if (this.storage instanceof Service) {
            ((Service)this.storage).start();
        }
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setNameFormat("Log Scanner/Cleaner #%d").build());
        this.scheduledExecutor.scheduleAtFixedRate(new MoveIntermediateToDoneRunnable(), this.moveThreadInterval, this.moveThreadInterval, TimeUnit.MILLISECONDS);
        boolean startCleanerService = this.conf.getBoolean("mapreduce.jobhistory.cleaner.enable", true);
        if (startCleanerService) {
            long runInterval = this.conf.getLong("mapreduce.jobhistory.cleaner.interval-ms", 86400000L);
            this.scheduledExecutor.scheduleAtFixedRate(new HistoryCleaner(), 30000L, runInterval, TimeUnit.MILLISECONDS);
        }
        super.start();
    }

    public void stop() {
        LOG.info((Object)"Stopping JobHistory");
        if (this.scheduledExecutor != null) {
            LOG.info((Object)"Stopping History Cleaner/Move To Done");
            this.scheduledExecutor.shutdown();
            boolean interrupted = false;
            long currentTime = System.currentTimeMillis();
            while (!this.scheduledExecutor.isShutdown() && System.currentTimeMillis() > currentTime + 1000L && !interrupted) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (!this.scheduledExecutor.isShutdown()) {
                LOG.warn((Object)"HistoryCleanerService/move to done shutdown may not have succeeded, Forcing a shutdown");
                this.scheduledExecutor.shutdownNow();
            }
        }
        if (this.storage instanceof Service) {
            ((Service)this.storage).stop();
        }
        this.hsManager.stop();
        super.stop();
    }

    public JobHistory() {
        super(JobHistory.class.getName());
    }

    public String getApplicationName() {
        return "Job History Server";
    }

    HistoryFileManager.HistoryFileInfo getJobFileInfo(JobId jobId) throws IOException {
        return this.hsManager.getFileInfo(jobId);
    }

    public Job getJob(JobId jobId) {
        return this.storage.getFullJob(jobId);
    }

    @Override
    public Map<JobId, Job> getAllJobs(ApplicationId appID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Called getAllJobs(AppId): " + appID));
        }
        JobID oldJobID = TypeConverter.fromYarn((ApplicationId)appID);
        HashMap<JobId, Job> jobs = new HashMap<JobId, Job>();
        JobId jobID = TypeConverter.toYarn((JobID)oldJobID);
        jobs.put(jobID, this.getJob(jobID));
        return jobs;
    }

    public Map<JobId, Job> getAllJobs() {
        return this.storage.getAllPartialJobs();
    }

    @Override
    public JobsInfo getPartialJobs(Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        return this.storage.getPartialJobs(offset, count, user, queue, sBegin, sEnd, fBegin, fEnd, jobState);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptID;
    }

    public ApplicationId getApplicationID() {
        return this.appID;
    }

    public EventHandler getEventHandler() {
        return null;
    }

    public CharSequence getUser() {
        if (this.userName != null) {
            this.userName = this.conf.get("mapreduce.job.user.name", "history-user");
        }
        return this.userName;
    }

    public Clock getClock() {
        return null;
    }

    public ClusterInfo getClusterInfo() {
        return null;
    }

    private class HistoryCleaner
    implements Runnable {
        private HistoryCleaner() {
        }

        @Override
        public void run() {
            LOG.info((Object)"History Cleaner started");
            try {
                JobHistory.this.hsManager.clean();
            }
            catch (IOException e) {
                LOG.warn((Object)"Error trying to clean up ", (Throwable)e);
            }
            LOG.info((Object)"History Cleaner complete");
        }
    }

    private class MoveIntermediateToDoneRunnable
    implements Runnable {
        private MoveIntermediateToDoneRunnable() {
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)"Starting scan to move intermediate done files");
                JobHistory.this.hsManager.scanIntermediateDirectory();
            }
            catch (IOException e) {
                LOG.error((Object)"Error while scanning intermediate done dir ", (Throwable)e);
            }
        }
    }
}

