/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public class TestAuditLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", DummyAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            Assert.assertTrue((boolean)DummyAuditLogger.initialized);
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.assertEquals((long)1L, (long)DummyAuditLogger.logCount);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokenLogger() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.audit.loggers", BrokenAuditLogger.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            long time = System.currentTimeMillis();
            fs.setTimes(new Path("/"), time, time);
            Assert.fail((String)"Expected exception due to broken audit logger.");
        }
        catch (RemoteException remoteException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    public static class BrokenAuditLogger
    implements AuditLogger {
        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            throw new RuntimeException("uh oh");
        }
    }

    public static class DummyAuditLogger
    implements AuditLogger {
        static boolean initialized;
        static int logCount;

        public void initialize(Configuration conf) {
            initialized = true;
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
            ++logCount;
        }
    }
}

