/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public class TestWebHdfsFileSystemContract
extends FileSystemContractBaseTest {
    private static final Configuration conf = new Configuration();
    private static final MiniDFSCluster cluster;
    private String defaultWorkingDirectory;
    private UserGroupInformation ugi;

    protected void setUp() throws Exception {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        this.ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        this.fs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.ugi, conf);
        this.defaultWorkingDirectory = this.fs.getWorkingDirectory().toUri().getPath();
    }

    protected String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("/test/hadoop");
        TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testDir));
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.mkdirs(testDir));
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("/test/hadoop/file"));
        Path testSubDir = this.path("/test/hadoop/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            TestWebHdfsFileSystemContract.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        Path testDeepSubDir = this.path("/test/hadoop/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            TestWebHdfsFileSystemContract.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.exists(testDeepSubDir));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
    }

    public void testGetFileBlockLocations() throws IOException {
        String f = "/test/testGetFileBlockLocations";
        this.createFile(this.path("/test/testGetFileBlockLocations"));
        BlockLocation[] computed = this.fs.getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        BlockLocation[] expected = cluster.getFileSystem().getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        TestWebHdfsFileSystemContract.assertEquals((int)expected.length, (int)computed.length);
        for (int i = 0; i < computed.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)expected[i].toString(), (String)computed[i].toString());
            Object[] names1 = expected[i].getNames();
            Object[] names2 = computed[i].getNames();
            Arrays.sort(names1);
            Arrays.sort(names2);
            Assert.assertArrayEquals((String)"Names differ", (Object[])names1, (Object[])names2);
            Object[] topos1 = expected[i].getTopologyPaths();
            Object[] topos2 = computed[i].getTopologyPaths();
            Arrays.sort(topos1);
            Arrays.sort(topos2);
            Assert.assertArrayEquals((String)"Topology differs", (Object[])topos1, (Object[])topos2);
        }
    }

    public void testCaseInsensitive() throws IOException {
        String line;
        Path p = new Path("/test/testCaseInsensitive");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, p, new Param[0]);
        WebHdfsFileSystem.LOG.info((Object)("url      = " + url));
        URL replaced = new URL(url.toString().replace(op.toQueryString(), "Op=mkDIrs"));
        WebHdfsFileSystem.LOG.info((Object)("replaced = " + replaced));
        HttpURLConnection conn = (HttpURLConnection)replaced.openConnection();
        conn.setRequestMethod(op.getType().toString());
        conn.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            WebHdfsFileSystem.LOG.info((Object)("> " + line));
        }
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.getFileStatus(p).isDirectory());
    }

    public void testOpenNonExistFile() throws IOException {
        Path p = new Path("/test/testOpenNonExistFile");
        try {
            FSDataInputStream in = this.fs.open(p);
            in.read();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (FileNotFoundException fnfe) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)fnfe);
        }
    }

    public void testSeek() throws IOException {
        int i;
        Path dir = new Path("/test/testSeek");
        TestWebHdfsFileSystemContract.assertTrue((boolean)this.fs.mkdirs(dir));
        Path zero = new Path(dir, "zero");
        this.fs.create(zero).close();
        int count = 0;
        FSDataInputStream in = this.fs.open(zero);
        while (in.read() != -1) {
            ++count;
        }
        in.close();
        TestWebHdfsFileSystemContract.assertEquals((int)0, (int)count);
        byte[] mydata = new byte[0x100000];
        new Random().nextBytes(mydata);
        Path p = new Path(dir, "file");
        FSDataOutputStream out = this.fs.create(p, false, 4096, (short)3, 131072L);
        out.write(mydata, 0, mydata.length);
        out.close();
        int one_third = mydata.length / 3;
        int two_third = one_third * 2;
        int offset = one_third;
        int len = mydata.length - offset;
        byte[] buf = new byte[len];
        FSDataInputStream in2 = this.fs.open(p);
        in2.seek((long)offset);
        in2.readFully(buf);
        in2.close();
        for (i = 0; i < buf.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (byte)mydata[i + offset], (byte)buf[i]);
        }
        offset = two_third;
        len = mydata.length - offset;
        buf = new byte[len];
        in2 = this.fs.open(p);
        in2.readFully((long)offset, buf);
        in2.close();
        for (i = 0; i < buf.length; ++i) {
            TestWebHdfsFileSystemContract.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (byte)mydata[i + offset], (byte)buf[i]);
        }
    }

    public void testRootDir() throws IOException {
        Path root = new Path("/");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.NULL, root, new Param[0]);
        WebHdfsFileSystem.LOG.info((Object)("null url=" + url));
        Assert.assertTrue((boolean)url.toString().contains("v1"));
        FileStatus status = this.fs.getFileStatus(root);
        TestWebHdfsFileSystemContract.assertTrue((status != null ? 1 : 0) != 0);
        TestWebHdfsFileSystemContract.assertEquals((int)511, (int)status.getPermission().toShort());
        TestWebHdfsFileSystemContract.assertFalse((boolean)this.fs.delete(root, true));
        try {
            FSDataOutputStream out = this.fs.create(root);
            out.write(1);
            out.close();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)e);
        }
        try {
            FSDataInputStream in = this.fs.open(root);
            in.read();
            TestWebHdfsFileSystemContract.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info((Object)"This is expected.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResponseCode() throws IOException {
        String redirect;
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path root = new Path("/");
        Path dir = new Path("/test/testUrl");
        TestWebHdfsFileSystemContract.assertTrue((boolean)webhdfs.mkdirs(dir));
        Path file = new Path("/test/file");
        FSDataOutputStream out = webhdfs.create(file);
        out.write(1);
        out.close();
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[0]);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map<?, ?> m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        TestWebHdfsFileSystemContract.assertEquals((Object)WebHdfsFileSystem.getHomeDirectoryString((UserGroupInformation)this.ugi), m.get(Path.class.getSimpleName()));
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(this.ugi.getShortUserName() + "proxy")});
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)401, (int)conn.getResponseCode());
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.SETOWNER, dir, new Param[0]);
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)400, (int)conn.getResponseCode());
        conn.disconnect();
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        URL url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)200, (int)conn2.getResponseCode());
        TestWebHdfsFileSystemContract.assertFalse((boolean)webhdfs.setReplication(dir, (short)1));
        conn2.disconnect();
        Path p = new Path(dir, "non-exist");
        url2 = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, p, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)404, (int)conn2.getResponseCode());
        conn2.disconnect();
        op = PutOpParam.Op.SETPERMISSION;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)200, (int)conn2.getResponseCode());
        TestWebHdfsFileSystemContract.assertEquals((int)0, (int)conn2.getContentLength());
        TestWebHdfsFileSystemContract.assertEquals((String)"application/octet-stream", (String)conn2.getContentType());
        TestWebHdfsFileSystemContract.assertEquals((short)493, (short)webhdfs.getFileStatus(dir).getPermission().toShort());
        conn2.disconnect();
        AppendTestUtil.testAppend(this.fs, new Path(dir, "append"));
        op = PutOpParam.Op.CREATE;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.setDoOutput(false);
        conn2.setInstanceFollowRedirects(false);
        conn2.connect();
        String redirect2 = conn2.getHeaderField("Location");
        conn2.disconnect();
        WebHdfsFileSystem.LOG.info((Object)("redirect = " + redirect2));
        int i = redirect2.indexOf("namenoderpcaddress");
        int j = redirect2.indexOf("&", i);
        String modified = redirect2.substring(0, i - 1) + redirect2.substring(j);
        WebHdfsFileSystem.LOG.info((Object)("modified = " + modified));
        conn2 = (HttpURLConnection)new URL(modified).openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.setDoOutput(op.getDoOutput());
        conn2.connect();
        TestWebHdfsFileSystemContract.assertEquals((int)400, (int)conn2.getResponseCode());
        op = GetOpParam.Op.OPEN;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, file, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        try {
            WebHdfsFileSystem.jsonParse((HttpURLConnection)conn2, (boolean)false);
            TestWebHdfsFileSystemContract.fail();
        }
        catch (IOException ioe) {
            WebHdfsFileSystem.LOG.info((Object)"GOOD", (Throwable)ioe);
        }
        conn2.disconnect();
        op = PutOpParam.Op.CREATE;
        Path path = new Path("/test/path%20with%20spaces");
        URL url3 = webhdfs.toUrl((HttpOpParam.Op)op, path, new Param[0]);
        HttpURLConnection conn3 = (HttpURLConnection)url3.openConnection();
        conn3.setRequestMethod(op.getType().toString());
        conn3.setDoOutput(false);
        conn3.setInstanceFollowRedirects(false);
        try {
            conn3.connect();
            TestWebHdfsFileSystemContract.assertEquals((int)307, (int)conn3.getResponseCode());
            redirect = conn3.getHeaderField("Location");
        }
        finally {
            conn3.disconnect();
        }
        conn3 = (HttpURLConnection)new URL(redirect).openConnection();
        conn3.setRequestMethod(op.getType().toString());
        conn3.setDoOutput(op.getDoOutput());
        try {
            conn3.connect();
            TestWebHdfsFileSystemContract.assertEquals((int)201, (int)conn3.getResponseCode());
        }
        finally {
            conn3.disconnect();
        }
    }

    static {
        conf.setBoolean("dfs.webhdfs.enabled", true);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

