/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.util.LightWeightCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRetryCacheWithHA {
    private static final Log LOG = LogFactory.getLog(TestRetryCacheWithHA.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static Configuration conf;
    private static final int BlockSize = 1024;
    private static final short DataNodes = 3;
    private static final Map<String, Object> results;

    @Before
    public void setup() throws Exception {
        conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        cluster.waitActive();
        cluster.transitionToActive(0);
        HATestUtil.setFailoverConfigurations(cluster, conf);
        dfs = (DistributedFileSystem)HATestUtil.configureFailoverFs(cluster, conf);
    }

    @After
    public void cleanup() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testRetryCacheOnStandbyNN() throws Exception {
        DFSTestUtil.runOperations(cluster, dfs, conf, 1024L, 0);
        FSNamesystem fsn0 = cluster.getNamesystem(0);
        LightWeightCache cacheSet = (LightWeightCache)fsn0.getRetryCache().getCacheSet();
        Assert.assertEquals((long)14L, (long)cacheSet.size());
        HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry> oldEntries = new HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry>();
        for (RetryCache.CacheEntry entry : cacheSet) {
            oldEntries.put(entry, entry);
        }
        cluster.getNameNode(0).getRpcServer().rollEditLog();
        cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
        cluster.shutdownNameNode(0);
        cluster.transitionToActive(1);
        FSNamesystem fsn1 = cluster.getNamesystem(1);
        cacheSet = (LightWeightCache)fsn1.getRetryCache().getCacheSet();
        Assert.assertEquals((long)14L, (long)cacheSet.size());
        for (RetryCache.CacheEntry entry : cacheSet) {
            Assert.assertTrue((boolean)oldEntries.containsKey(entry));
        }
    }

    private DFSClient genClientWithDummyHandler() throws IOException {
        URI nnUri = dfs.getUri();
        Class failoverProxyProviderClass = NameNodeProxies.getFailoverProxyProviderClass((Configuration)conf, (URI)nnUri, ClientProtocol.class);
        FailoverProxyProvider failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider((Configuration)conf, (Class)failoverProxyProviderClass, ClientProtocol.class, (URI)nnUri);
        DummyRetryInvocationHandler dummyHandler = new DummyRetryInvocationHandler((FailoverProxyProvider<ClientProtocol>)failoverProxyProvider, RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)Integer.MAX_VALUE, (long)500L, (long)15000L));
        ClientProtocol proxy = (ClientProtocol)Proxy.newProxyInstance(failoverProxyProvider.getInterface().getClassLoader(), new Class[]{ClientProtocol.class}, (InvocationHandler)((Object)dummyHandler));
        DFSClient client = new DFSClient(null, proxy, conf, null);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRetryWithFailover() throws Exception {
        String dir = "/test";
        Path dirPath = new Path("/test");
        String sName = "s1";
        String dirSnapshot = "/test/.snapshot/s1";
        dfs.mkdirs(dirPath);
        dfs.allowSnapshot(dirPath);
        final DFSClient client = this.genClientWithDummyHandler();
        DummyRetryInvocationHandler.block.set(true);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String snapshotPath = client.createSnapshot("/test", "s1");
                    Assert.assertEquals((Object)"/test/.snapshot/s1", (Object)snapshotPath);
                    LOG.info((Object)("Created snapshot " + snapshotPath));
                    TestRetryCacheWithHA testRetryCacheWithHA = TestRetryCacheWithHA.this;
                    synchronized (testRetryCacheWithHA) {
                        results.put("createSnapshot", snapshotPath);
                        TestRetryCacheWithHA.this.notifyAll();
                    }
                }
                catch (IOException e) {
                    try {
                        LOG.info((Object)("Got IOException " + e + " while creating snapshot"));
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{client});
                        throw throwable;
                    }
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{client});
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{client});
            }
        }.start();
        boolean snapshotCreated = dfs.exists(new Path("/test/.snapshot/s1"));
        while (!snapshotCreated) {
            Thread.sleep(1000L);
            snapshotCreated = dfs.exists(new Path("/test/.snapshot/s1"));
        }
        cluster.transitionToStandby(0);
        cluster.transitionToActive(1);
        LOG.info((Object)"Setting block to false");
        DummyRetryInvocationHandler.block.set(false);
        TestRetryCacheWithHA testRetryCacheWithHA = this;
        synchronized (testRetryCacheWithHA) {
            while (!results.containsKey("createSnapshot")) {
                this.wait();
            }
            LOG.info((Object)("Got the result of createSnapshot: " + results.get("createSnapshot")));
        }
    }

    static {
        conf = new HdfsConfiguration();
        results = new HashMap<String, Object>();
    }

    private static class DummyRetryInvocationHandler
    extends RetryInvocationHandler {
        static AtomicBoolean block = new AtomicBoolean(false);

        DummyRetryInvocationHandler(FailoverProxyProvider<ClientProtocol> proxyProvider, RetryPolicy retryPolicy) {
            super(proxyProvider, retryPolicy);
        }

        protected Object invokeMethod(Method method, Object[] args) throws Throwable {
            Object result = super.invokeMethod(method, args);
            if (block.get()) {
                throw new UnknownHostException("Fake Exception");
            }
            return result;
        }
    }
}

