/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestNameNodeMXBean {
    private static final double DELTA = 1.0E-6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assert.assertEquals((Object)fsn.getClusterId(), (Object)clusterId);
            String blockpoolId = (String)mbs.getAttribute(mxbeanName, "BlockPoolId");
            Assert.assertEquals((Object)fsn.getBlockPoolId(), (Object)blockpoolId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((Object)fsn.getVersion(), (Object)version);
            Assert.assertTrue((boolean)version.equals(VersionInfo.getVersion() + ", r" + VersionInfo.getRevision()));
            Long used = (Long)mbs.getAttribute(mxbeanName, "Used");
            Assert.assertEquals((long)fsn.getUsed(), (long)used);
            Long total = (Long)mbs.getAttribute(mxbeanName, "Total");
            Assert.assertEquals((long)fsn.getTotal(), (long)total);
            String safemode = (String)mbs.getAttribute(mxbeanName, "Safemode");
            Assert.assertEquals((Object)fsn.getSafemode(), (Object)safemode);
            Long nondfs = (Long)mbs.getAttribute(mxbeanName, "NonDfsUsedSpace");
            Assert.assertEquals((long)fsn.getNonDfsUsedSpace(), (long)nondfs);
            Float percentremaining = (Float)mbs.getAttribute(mxbeanName, "PercentRemaining");
            Assert.assertEquals((double)fsn.getPercentRemaining(), (double)percentremaining.floatValue(), (double)1.0E-6);
            Long totalblocks = (Long)mbs.getAttribute(mxbeanName, "TotalBlocks");
            Assert.assertEquals((long)fsn.getTotalBlocks(), (long)totalblocks);
            String alivenodeinfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes = (Map)JSON.parse((String)alivenodeinfo);
            Assert.assertTrue((liveNodes.size() > 0 ? 1 : 0) != 0);
            for (Map liveNode : liveNodes.values()) {
                Assert.assertTrue((boolean)liveNode.containsKey("nonDfsUsedSpace"));
                Assert.assertTrue(((Long)liveNode.get("nonDfsUsedSpace") > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)liveNode.containsKey("capacity"));
                Assert.assertTrue(((Long)liveNode.get("capacity") > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)liveNode.containsKey("numBlocks"));
                Assert.assertTrue(((Long)liveNode.get("numBlocks") == 0L ? 1 : 0) != 0);
            }
            Assert.assertEquals((Object)fsn.getLiveNodes(), (Object)alivenodeinfo);
            String deadnodeinfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assert.assertEquals((Object)fsn.getDeadNodes(), (Object)deadnodeinfo);
            String nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            Assert.assertEquals((Object)fsn.getNameDirStatuses(), (Object)nameDirStatuses);
            Map statusMap = (Map)JSON.parse((String)nameDirStatuses);
            Collection<URI> nameDirUris = cluster.getNameDirs(0);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                System.out.println("Checking for the presence of " + nameDir + " in active name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get("active")).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)2L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)0L, (long)((Map)statusMap.get("failed")).size());
            File failedNameDir = new File(nameDirUris.toArray(new URI[0])[0]);
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)new File(failedNameDir, "current").getAbsolutePath(), (String)"000"));
            cluster.getNameNodeRpc().rollEditLog();
            nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            statusMap = (Map)JSON.parse((String)nameDirStatuses);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                String expectedStatus = nameDir.equals(failedNameDir) ? "failed" : "active";
                System.out.println("Checking for the presence of " + nameDir + " in " + expectedStatus + " name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get(expectedStatus)).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("failed")).size());
        }
        finally {
            if (cluster != null) {
                for (URI dir : cluster.getNameDirs(0)) {
                    FileUtil.chmod((String)new File(new File(dir), "current").getAbsolutePath(), (String)"755");
                }
                cluster.shutdown();
            }
        }
    }
}

