/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.HsftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.ServletUtil;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHftpFileSystem {
    private static final Random RAN = new Random();
    private static Configuration config = null;
    private static MiniDFSCluster cluster = null;
    private static String blockPoolId = null;
    private static String hftpUri = null;
    private FileSystem hdfs = null;
    private HftpFileSystem hftpFs = null;
    private static Path[] TEST_PATHS = new Path[]{new Path("/foo;bar"), new Path("/foo+"), new Path("/foo+bar/foo+bar"), new Path("/foo=bar/foo=bar"), new Path("/foo,bar/foo,bar"), new Path("/foo@bar/foo@bar"), new Path("/foo&bar/foo&bar"), new Path("/foo$bar/foo$bar"), new Path("/foo_bar/foo_bar"), new Path("/foo~bar/foo~bar"), new Path("/foo.bar/foo.bar"), new Path("/foo../bar/foo../bar"), new Path("/foo.../bar/foo.../bar"), new Path("/foo'bar/foo'bar"), new Path("/foo#bar/foo#bar"), new Path("/foo!bar/foo!bar"), new Path("/foo bar/foo bar"), new Path("/foo?bar/foo?bar"), new Path("/foo\">bar/foo\">bar")};

    @BeforeClass
    public static void setUp() throws IOException {
        ((Log4JLogger)HftpFileSystem.LOG).getLogger().setLevel(Level.ALL);
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        config = new Configuration();
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(2).build();
        blockPoolId = cluster.getNamesystem().getBlockPoolId();
        hftpUri = "hftp://" + config.get("dfs.namenode.http-address");
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void initFileSystems() throws IOException {
        this.hdfs = cluster.getFileSystem();
        this.hftpFs = (HftpFileSystem)new Path(hftpUri).getFileSystem(config);
        for (FileStatus stat : this.hdfs.listStatus(new Path("/"))) {
            this.hdfs.delete(stat.getPath(), true);
        }
    }

    @After
    public void resetFileSystems() throws IOException {
        FileSystem.closeAll();
    }

    @Test
    public void testFileNameEncoding() throws IOException, URISyntaxException {
        for (Path p : TEST_PATHS) {
            FSDataOutputStream out = this.hdfs.create(p, true);
            out.writeBytes("0123456789");
            out.close();
            FSDataInputStream in = this.hftpFs.open(p);
            Assert.assertEquals((long)48L, (long)in.read());
            Assert.assertEquals((Object)p, (Object)new Path(this.hftpFs.getFileStatus(p).getPath().toUri().getPath()));
            Assert.assertEquals((long)1L, (long)this.hftpFs.listStatus(p).length);
            Assert.assertNotNull((String)"No content summary", (Object)this.hftpFs.getContentSummary(p));
            Assert.assertNotNull((String)"No file checksum", (Object)this.hftpFs.getFileChecksum(p));
        }
    }

    private void testDataNodeRedirect(Path path) throws IOException {
        if (this.hdfs.exists(path)) {
            this.hdfs.delete(path, true);
        }
        FSDataOutputStream out = this.hdfs.create(path, (short)1);
        out.writeBytes("0123456789");
        out.close();
        BlockLocation[] locations = this.hdfs.getFileBlockLocations(path, 0L, 10L);
        String xferAddr = locations[0].getNames()[0];
        URL u = this.hftpFs.getNamenodeURL("/data" + ServletUtil.encodePath((String)path.toUri().getPath()), "ugi=userx,groupy");
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        HttpURLConnection.setFollowRedirects(true);
        conn.connect();
        conn.getInputStream();
        boolean checked = false;
        for (DataNode node : cluster.getDataNodes()) {
            DatanodeRegistration dnR = DataNodeTestUtils.getDNRegistrationForBP(node, blockPoolId);
            if (!dnR.getXferAddr().equals(xferAddr)) continue;
            checked = true;
            Assert.assertEquals((long)dnR.getInfoPort(), (long)conn.getURL().getPort());
        }
        Assert.assertTrue((String)"The test never checked that location of the block and hftp desitnation are the same", (boolean)checked);
    }

    @Test
    public void testDataNodeRedirect() throws IOException {
        for (Path p : TEST_PATHS) {
            this.testDataNodeRedirect(p);
        }
    }

    @Test
    public void testGetPos() throws IOException {
        Path testFile = new Path("/testfile+1");
        FSDataOutputStream out = this.hdfs.create(testFile, true);
        out.writeBytes("0123456789");
        out.close();
        FSDataInputStream in = this.hftpFs.open(testFile);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)i, (long)in.getPos());
            in.read();
        }
        Assert.assertEquals((long)5L, (long)in.getPos());
        byte[] buffer = new byte[10];
        Assert.assertEquals((long)2L, (long)in.read(buffer, 0, 2));
        Assert.assertEquals((long)7L, (long)in.getPos());
        int bytesRead = in.read(buffer);
        Assert.assertEquals((long)(7 + bytesRead), (long)in.getPos());
        for (int i = 0; i < 100; ++i) {
            in.read();
        }
        Assert.assertEquals((long)10L, (long)in.getPos());
        in.close();
    }

    @Test
    public void testSeek() throws IOException {
        Path testFile = new Path("/testfile+1");
        FSDataOutputStream out = this.hdfs.create(testFile, true);
        out.writeBytes("0123456789");
        out.close();
        FSDataInputStream in = this.hftpFs.open(testFile);
        in.seek(7L);
        Assert.assertEquals((long)55L, (long)in.read());
    }

    @Test
    public void testReadClosedStream() throws IOException {
        Path testFile = new Path("/testfile+2");
        FSDataOutputStream os = this.hdfs.create(testFile, true);
        os.writeBytes("0123456789");
        os.close();
        FSDataInputStream in = this.hftpFs.open(testFile);
        in.close();
        this.checkClosedStream((InputStream)in);
        this.checkClosedStream(in.getWrappedStream());
        in = this.hftpFs.open(testFile);
        int ch = in.read();
        Assert.assertEquals((long)48L, (long)ch);
        in.close();
        this.checkClosedStream((InputStream)in);
        this.checkClosedStream(in.getWrappedStream());
        in.seek(4L);
        this.checkClosedStream((InputStream)in);
        this.checkClosedStream(in.getWrappedStream());
    }

    private void checkClosedStream(InputStream is) {
        IOException ioe = null;
        try {
            is.read();
        }
        catch (IOException e) {
            ioe = e;
        }
        Assert.assertNotNull((String)"No exception on closed read", (Object)ioe);
        Assert.assertEquals((Object)"Stream closed", (Object)ioe.getMessage());
    }

    @Test
    public void testHftpDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hftp://localhost");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50070L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)50470L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:50470", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hftp://localhost");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)456L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:456", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomUriPortWithDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hftp://localhost:123");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50070L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)50470L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:50470", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomUriPortWithCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hftp://localhost:789");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)456L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:456", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hsftp://localhost");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50470L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)50470L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:50470", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hsftp://localhost");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)456L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:456", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomUriPortWithDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hsftp://localhost:123");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50470L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)50470L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:123", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomUriPortWithCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hsftp://localhost:789");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        Assert.assertEquals((long)456L, (long)fs.getDefaultSecurePort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:789", (Object)fs.getCanonicalServiceName());
    }
}

