/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.FileInputStreamCache;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.junit.Test;

public class TestFileInputStreamCache {
    static final Log LOG = LogFactory.getLog(TestFileInputStreamCache.class);

    @Test
    public void testCreateAndDestroy() throws Exception {
        FileInputStreamCache cache = new FileInputStreamCache(10, 1000L);
        cache.close();
    }

    @Test
    public void testAddAndRetrieve() throws Exception {
        FileInputStreamCache cache = new FileInputStreamCache(1, 1000000L);
        DatanodeID dnId = new DatanodeID("127.0.0.1", "localhost", "xyzzy", 8080, 9090, 7070);
        ExtendedBlock block = new ExtendedBlock("poolid", 123L);
        TestFileDescriptorPair pair = new TestFileDescriptorPair();
        cache.put(dnId, block, pair.getFileInputStreams());
        FileInputStream[] fis = cache.get(dnId, block);
        Assert.assertTrue((boolean)pair.compareWith(fis));
        pair.close();
        cache.close();
    }

    @Test
    public void testExpiry() throws Exception {
        FileInputStreamCache cache = new FileInputStreamCache(1, 10L);
        DatanodeID dnId = new DatanodeID("127.0.0.1", "localhost", "xyzzy", 8080, 9090, 7070);
        ExtendedBlock block = new ExtendedBlock("poolid", 123L);
        TestFileDescriptorPair pair = new TestFileDescriptorPair();
        cache.put(dnId, block, pair.getFileInputStreams());
        Thread.sleep(cache.getExpiryTimeMs() * 100L);
        FileInputStream[] fis = cache.get(dnId, block);
        Assert.assertNull((Object)fis);
        pair.close();
        cache.close();
    }

    @Test
    public void testEviction() throws Exception {
        FileInputStreamCache cache = new FileInputStreamCache(1, 10000000L);
        DatanodeID dnId = new DatanodeID("127.0.0.1", "localhost", "xyzzy", 8080, 9090, 7070);
        ExtendedBlock block = new ExtendedBlock("poolid", 123L);
        TestFileDescriptorPair pair = new TestFileDescriptorPair();
        cache.put(dnId, block, pair.getFileInputStreams());
        DatanodeID dnId2 = new DatanodeID("127.0.0.1", "localhost", "xyzzy", 8081, 9091, 7071);
        TestFileDescriptorPair pair2 = new TestFileDescriptorPair();
        cache.put(dnId2, block, pair2.getFileInputStreams());
        FileInputStream[] fis = cache.get(dnId, block);
        Assert.assertNull((Object)fis);
        FileInputStream[] fis2 = cache.get(dnId2, block);
        Assert.assertTrue((boolean)pair2.compareWith(fis2));
        pair.close();
        cache.close();
    }

    private static class TestFileDescriptorPair {
        TemporarySocketDirectory dir = new TemporarySocketDirectory();
        FileInputStream[] fis = new FileInputStream[2];

        public TestFileDescriptorPair() throws IOException {
            for (int i = 0; i < 2; ++i) {
                String name = this.dir.getDir() + "/file" + i;
                FileOutputStream fos = new FileOutputStream(name);
                fos.write(1);
                fos.close();
                this.fis[i] = new FileInputStream(name);
            }
        }

        public FileInputStream[] getFileInputStreams() {
            return this.fis;
        }

        public void close() throws IOException {
            IOUtils.cleanup((Log)LOG, (Closeable[])this.fis);
            this.dir.close();
        }

        public boolean compareWith(FileInputStream[] other) {
            if (other == null || this.fis == null) {
                return other == this.fis;
            }
            if (this.fis.length != other.length) {
                return false;
            }
            for (int i = 0; i < this.fis.length; ++i) {
                if (this.fis[i] == other[i]) continue;
                return false;
            }
            return true;
        }
    }
}

