/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextSymlinkBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFcHdfsSymlink
extends FileContextSymlinkBaseTest {
    private static FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestFcHdfsSymlink");
    private static MiniDFSCluster cluster;
    private static WebHdfsFileSystem webhdfs;
    private static DistributedFileSystem dfs;

    public TestFcHdfsSymlink() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
    }

    protected String getScheme() {
        return "hdfs";
    }

    protected String testBaseDir1() throws IOException {
        return "/test1";
    }

    protected String testBaseDir2() throws IOException {
        return "/test2";
    }

    protected URI testURI() {
        return cluster.getURI(0);
    }

    protected IOException unwrapException(IOException e) {
        if (e instanceof RemoteException) {
            return ((RemoteException)((Object)e)).unwrapRemoteException();
        }
        return e;
    }

    @BeforeClass
    public static void testSetUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.set("fs.permissions.umask-mode", "000");
        cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        fc = FileContext.getFileContext((URI)cluster.getURI(0));
        webhdfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)conf);
        dfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void testTearDown() throws Exception {
        cluster.shutdown();
    }

    @Test
    public void testLinkAcrossFileSystems() throws IOException {
        FileContext localFc = FileContext.getLocalFSFileContext();
        Path localDir = new Path("file://" + fileContextTestHelper.getAbsoluteTestRootDir(localFc) + "/test");
        Path localFile = new Path("file://" + fileContextTestHelper.getAbsoluteTestRootDir(localFc) + "/test/file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        localFc.delete(localDir, true);
        localFc.mkdir(localDir, FileContext.DEFAULT_PERM, true);
        localFc.setWorkingDirectory(localDir);
        Assert.assertEquals((Object)localDir, (Object)localFc.getWorkingDirectory());
        TestFcHdfsSymlink.createAndWriteFile((FileContext)localFc, (Path)localFile);
        fc.createSymlink(localFile, link, false);
        TestFcHdfsSymlink.readFile((Path)link);
        Assert.assertEquals((long)16384L, (long)fc.getFileStatus(link).getLen());
    }

    @Test
    public void testRenameAcrossFileSystemsViaLink() throws IOException {
        FileContext localFc = FileContext.getLocalFSFileContext();
        Path localDir = new Path("file://" + fileContextTestHelper.getAbsoluteTestRootDir(localFc) + "/test");
        Path hdfsFile = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        Path hdfsFileNew = new Path(this.testBaseDir1(), "fileNew");
        Path hdfsFileNewViaLink = new Path(link, "fileNew");
        localFc.delete(localDir, true);
        localFc.mkdir(localDir, FileContext.DEFAULT_PERM, true);
        localFc.setWorkingDirectory(localDir);
        TestFcHdfsSymlink.createAndWriteFile((FileContext)fc, (Path)hdfsFile);
        fc.createSymlink(localDir, link, false);
        try {
            fc.rename(hdfsFile, hdfsFileNewViaLink, new Options.Rename[0]);
            Assert.fail((String)"Renamed across file systems");
        }
        catch (InvalidPathException ipe) {
            // empty catch block
        }
        TestFcHdfsSymlink.createAndWriteFile((FileContext)fc, (Path)hdfsFileNewViaLink);
        try {
            fc.rename(hdfsFileNewViaLink, hdfsFileNew, new Options.Rename[0]);
            Assert.fail((String)"Renamed across file systems");
        }
        catch (InvalidPathException ipe) {
            // empty catch block
        }
    }

    @Test
    public void testAccessLinkFromAbstractFileSystem() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.createSymlink(file, link, false);
        try {
            AbstractFileSystem afs = fc.getDefaultFileSystem();
            afs.open(link);
            Assert.fail((String)"Opened a link using AFS");
        }
        catch (UnresolvedLinkException unresolvedLinkException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLinkToSlash() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToSlash");
        Path fileViaLink = new Path(this.testBaseDir1() + "/linkToSlash" + this.testBaseDir1() + "/file");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.setWorkingDirectory(dir);
        fc.createSymlink(new Path("/"), link, false);
        TestFcHdfsSymlink.readFile((Path)fileViaLink);
        Assert.assertEquals((long)16384L, (long)fc.getFileStatus(fileViaLink).getLen());
        FileContext localFc = FileContext.getLocalFSFileContext();
        Path linkQual = new Path(cluster.getURI(0).toString(), fileViaLink);
        Assert.assertEquals((long)16384L, (long)localFc.getFileStatus(linkQual).getLen());
    }

    @Test
    public void testSetPermissionAffectsTarget() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path dir = new Path(this.testBaseDir2());
        Path linkToFile = new Path(this.testBaseDir1(), "linkToFile");
        Path linkToDir = new Path(this.testBaseDir1(), "linkToDir");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.createSymlink(file, linkToFile, false);
        fc.createSymlink(dir, linkToDir, false);
        FsPermission perms = fc.getFileLinkStatus(linkToFile).getPermission();
        fc.setPermission(linkToFile, new FsPermission(436));
        fc.setOwner(linkToFile, "user", "group");
        Assert.assertEquals((Object)perms, (Object)fc.getFileLinkStatus(linkToFile).getPermission());
        FileStatus stat = fc.getFileStatus(file);
        Assert.assertEquals((long)436L, (long)stat.getPermission().toShort());
        Assert.assertEquals((Object)"user", (Object)stat.getOwner());
        Assert.assertEquals((Object)"group", (Object)stat.getGroup());
        Assert.assertEquals((Object)stat.getPermission(), (Object)fc.getFileStatus(linkToFile).getPermission());
        perms = fc.getFileLinkStatus(linkToDir).getPermission();
        fc.setPermission(linkToDir, new FsPermission(436));
        fc.setOwner(linkToDir, "user", "group");
        Assert.assertEquals((Object)perms, (Object)fc.getFileLinkStatus(linkToDir).getPermission());
        stat = fc.getFileStatus(dir);
        Assert.assertEquals((long)436L, (long)stat.getPermission().toShort());
        Assert.assertEquals((Object)"user", (Object)stat.getOwner());
        Assert.assertEquals((Object)"group", (Object)stat.getGroup());
        Assert.assertEquals((Object)stat.getPermission(), (Object)fc.getFileStatus(linkToDir).getPermission());
    }

    @Test
    public void testCreateWithPartQualPathFails() throws IOException {
        Path fileWoAuth = new Path("hdfs:///test/file");
        Path linkWoAuth = new Path("hdfs:///test/link");
        try {
            TestFcHdfsSymlink.createAndWriteFile((Path)fileWoAuth);
            Assert.fail((String)"HDFS requires URIs with schemes have an authority");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            fc.createSymlink(new Path("foo"), linkWoAuth, false);
            Assert.fail((String)"HDFS requires URIs with schemes have an authority");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetReplication() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.createSymlink(file, link, false);
        fc.setReplication(link, (short)2);
        Assert.assertEquals((long)0L, (long)fc.getFileLinkStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)fc.getFileStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)fc.getFileStatus(file).getReplication());
    }

    @Test
    public void testCreateLinkMaxPathLink() throws IOException {
        int i;
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        int maxPathLen = HdfsConstants.MAX_PATH_LENGTH;
        int dirLen = dir.toString().length() + 1;
        int len = maxPathLen - dirLen;
        StringBuilder sb = new StringBuilder("");
        for (i = 0; i < len / 10; ++i) {
            sb.append("0123456789");
        }
        for (i = 0; i < len % 10; ++i) {
            sb.append("x");
        }
        Path link = new Path(sb.toString());
        Assert.assertEquals((long)maxPathLen, (long)(dirLen + link.toString().length()));
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.setWorkingDirectory(dir);
        fc.createSymlink(file, link, false);
        TestFcHdfsSymlink.readFile((Path)link);
        link = new Path(sb.toString() + "x");
        try {
            fc.createSymlink(file, link, false);
            Assert.fail((String)"Path name should be too long");
        }
        catch (IOException x) {
            // empty catch block
        }
    }

    @Test
    public void testLinkOwner() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "symlinkToFile");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        fc.createSymlink(file, link, false);
        FileStatus statFile = fc.getFileStatus(file);
        FileStatus statLink = fc.getFileStatus(link);
        Assert.assertEquals((Object)statLink.getOwner(), (Object)statFile.getOwner());
    }

    @Test
    public void testWebHDFS() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        webhdfs.createSymlink(file, link, false);
        fc.setReplication(link, (short)2);
        Assert.assertEquals((long)0L, (long)fc.getFileLinkStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)fc.getFileStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)fc.getFileStatus(file).getReplication());
    }

    @Test
    public void testQuota() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        dfs.setQuota(dir, 3L, Long.MAX_VALUE);
        Path file = new Path(dir, "file");
        TestFcHdfsSymlink.createAndWriteFile((Path)file);
        Path link1 = new Path(dir, "link1");
        fc.createSymlink(file, link1, false);
        try {
            Path link2 = new Path(dir, "link2");
            fc.createSymlink(file, link2, false);
            Assert.fail((String)"Created symlink despite quota violation");
        }
        catch (QuotaExceededException qee) {
            // empty catch block
        }
    }
}

