/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.CredentialShell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCredShell {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private static final File tmpDir = new File(System.getProperty("test.build.data", "/tmp"), "creds");
    private String jceksProvider;

    @Before
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
        Path jksPath = new Path(tmpDir.toString(), "keystore.jceks");
        this.jceksProvider = "jceks://file" + jksPath.toUri();
    }

    @Test
    public void testCredentialSuccessfulLifecycle() throws Exception {
        this.outContent.reset();
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", this.jceksProvider};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully created."));
        this.outContent.reset();
        String[] args2 = new String[]{"list", "-provider", this.jceksProvider};
        rc = cs.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1"));
        this.outContent.reset();
        String[] args4 = new String[]{"delete", "credential1", "-provider", this.jceksProvider};
        rc = cs.run(args4);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully deleted."));
        this.outContent.reset();
        String[] args5 = new String[]{"list", "-provider", this.jceksProvider};
        rc = cs.run(args5);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertFalse((String)this.outContent.toString(), (boolean)this.outContent.toString().contains("credential1"));
    }

    @Test
    public void testInvalidProvider() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", "sdff://file/tmp/credstore.jceks"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid CredentialProviders configured."));
    }

    @Test
    public void testTransientProviderWarning() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-value", "p@ssw0rd", "-provider", "user:///"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        cs.setConf(new Configuration());
        rc = cs.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("WARNING: you are modifying a transient provider."));
        String[] args2 = new String[]{"delete", "credential1", "-provider", "user:///"};
        rc = cs.run(args2);
        Assert.assertEquals((String)this.outContent.toString(), (long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully deleted."));
    }

    @Test
    public void testTransientProviderOnlyConfig() throws Exception {
        String[] args1 = new String[]{"create", "credential1"};
        int rc = 0;
        CredentialShell cs = new CredentialShell();
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", "user:///");
        cs.setConf(config);
        rc = cs.run(args1);
        Assert.assertEquals((long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("There are no valid CredentialProviders configured."));
    }

    @Test
    public void testPromptForCredentialWithEmptyPasswd() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-provider", this.jceksProvider};
        ArrayList<String> passwords = new ArrayList<String>();
        passwords.add(null);
        passwords.add("p@ssw0rd");
        int rc = 0;
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(passwords));
        rc = shell.run(args1);
        Assert.assertEquals((String)this.outContent.toString(), (long)1L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("Passwords don't match"));
    }

    @Test
    public void testPromptForCredential() throws Exception {
        String[] args1 = new String[]{"create", "credential1", "-provider", this.jceksProvider};
        ArrayList<String> passwords = new ArrayList<String>();
        passwords.add("p@ssw0rd");
        passwords.add("p@ssw0rd");
        int rc = 0;
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        shell.setPasswordReader((CredentialShell.PasswordReader)new MockPasswordReader(passwords));
        rc = shell.run(args1);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully created."));
        String[] args2 = new String[]{"delete", "credential1", "-provider", this.jceksProvider};
        rc = shell.run(args2);
        Assert.assertEquals((long)0L, (long)rc);
        Assert.assertTrue((boolean)this.outContent.toString().contains("credential1 has been successfully deleted."));
    }

    @Test
    public void testEmptyArgList() throws Exception {
        CredentialShell shell = new CredentialShell();
        shell.setConf(new Configuration());
        Assert.assertEquals((long)1L, (long)shell.init(new String[0]));
    }

    @Test
    public void testCommandHelpExitsNormally() throws Exception {
        for (String cmd : Arrays.asList("create", "list", "delete")) {
            CredentialShell shell = new CredentialShell();
            shell.setConf(new Configuration());
            Assert.assertEquals((String)("Expected help argument on " + cmd + " to return 0"), (long)0L, (long)shell.init(new String[]{cmd, "-help"}));
        }
    }

    public class MockPasswordReader
    extends CredentialShell.PasswordReader {
        List<String> passwords = null;

        public MockPasswordReader(List<String> passwds) {
            this.passwords = passwds;
        }

        public char[] readPassword(String prompt) {
            if (this.passwords.size() == 0) {
                return null;
            }
            String pass = this.passwords.remove(0);
            return pass == null ? null : pass.toCharArray();
        }

        public void format(String message) {
            System.out.println(message);
        }
    }
}

