/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.ActiveStandbyElectorTestUtil;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.log4j.Level;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestActiveStandbyElectorRealZK
extends ClientBaseWithFixes {
    static final int NUM_ELECTORS = 2;
    static final String PARENT_DIR;
    ActiveStandbyElector[] electors = new ActiveStandbyElector[2];
    private byte[][] appDatas = new byte[2][];
    private ActiveStandbyElector.ActiveStandbyElectorCallback[] cbs = new ActiveStandbyElector.ActiveStandbyElectorCallback[2];
    private ZooKeeperServer zkServer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zkServer = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        for (int i = 0; i < 2; ++i) {
            this.cbs[i] = (ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.mock(ActiveStandbyElector.ActiveStandbyElectorCallback.class);
            this.appDatas[i] = Ints.toByteArray((int)i);
            this.electors[i] = new ActiveStandbyElector(this.hostPort, 5000, PARENT_DIR, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, Collections.emptyList(), this.cbs[i], 3);
        }
    }

    private void checkFatalsAndReset() throws Exception {
        for (int i = 0; i < 2; ++i) {
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[i], (VerificationMode)Mockito.never())).notifyFatalError(Mockito.anyString());
            Mockito.reset((Object[])new ActiveStandbyElector.ActiveStandbyElectorCallback[]{this.cbs[i]});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testActiveStandbyTransition() throws Exception {
        LOG.info("starting test with parentDir:" + PARENT_DIR);
        Assert.assertFalse((boolean)this.electors[0].parentZNodeExists());
        this.electors[0].ensureParentZNode();
        Assert.assertTrue((boolean)this.electors[0].parentZNodeExists());
        this.electors[0].joinElection(this.appDatas[0]);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[1].joinElection(this.appDatas[1]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[0].quitElection(true);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[1]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[0].joinElection(this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[1].preventSessionReestablishmentForTests();
        try {
            this.zkServer.closeSession(this.electors[1].getZKSessionIdForTests());
            ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[0]);
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).enterNeutralMode();
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).fenceOldActive(AdditionalMatchers.aryEq((byte[])this.appDatas[1]));
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        }
        finally {
            this.electors[1].allowSessionReestablishmentForTests();
        }
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)5000))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[0].preventSessionReestablishmentForTests();
        try {
            this.zkServer.closeSession(this.electors[0].getZKSessionIdForTests());
            ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[1]);
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).enterNeutralMode();
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).fenceOldActive(AdditionalMatchers.aryEq((byte[])this.appDatas[0]));
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        }
        finally {
            this.electors[0].allowSessionReestablishmentForTests();
        }
        this.checkFatalsAndReset();
    }

    @Test(timeout=15000L)
    public void testHandleSessionExpiration() throws Exception {
        ActiveStandbyElector.ActiveStandbyElectorCallback cb = this.cbs[0];
        byte[] appData = this.appDatas[0];
        ActiveStandbyElector elector = this.electors[0];
        elector.ensureParentZNode();
        elector.joinElection(appData);
        ZooKeeperServer zks = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, appData);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        this.checkFatalsAndReset();
        LOG.info("========================== Expiring session");
        zks.closeSession(elector.getZKSessionIdForTests());
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((int)1000))).enterNeutralMode();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, appData);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        this.checkFatalsAndReset();
        LOG.info("========================== Quitting election");
        elector.quitElection(false);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        Thread.sleep(1000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.never())).becomeActive();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        this.checkFatalsAndReset();
    }

    @Test(timeout=15000L)
    public void testHandleSessionExpirationOfStandby() throws Exception {
        this.electors[0].ensureParentZNode();
        this.electors[0].joinElection(this.appDatas[0]);
        ZooKeeperServer zks = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((int)1000))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[1].joinElection(this.appDatas[1]);
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[1], ActiveStandbyElector.State.STANDBY);
        LOG.info("========================== Expiring standby's session");
        zks.closeSession(this.electors[1].getZKSessionIdForTests());
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((int)1000))).enterNeutralMode();
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[1], ActiveStandbyElector.State.STANDBY);
        this.checkFatalsAndReset();
        LOG.info("========================== Quitting election");
        this.electors[1].quitElection(false);
        this.electors[0].quitElection(false);
        Thread.sleep(1000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.never())).becomeActive();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        this.checkFatalsAndReset();
    }

    @Test(timeout=15000L)
    public void testDontJoinElectionOnDisconnectAndReconnect() throws Exception {
        this.electors[0].ensureParentZNode();
        this.stopServer();
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[0], ActiveStandbyElector.State.NEUTRAL);
        this.startServer();
        TestActiveStandbyElectorRealZK.waitForServerUp(this.hostPort, CONNECTION_TIMEOUT);
        Thread.sleep(2000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.never())).becomeActive();
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.never())).becomeActive();
        this.checkFatalsAndReset();
    }

    static {
        ((Log4JLogger)ActiveStandbyElector.LOG).getLogger().setLevel(Level.ALL);
        PARENT_DIR = "/" + UUID.randomUUID();
    }
}

