/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewFileSystemBaseTest {
    FileSystem fsView;
    FileSystem fsTarget;
    Path targetTestRoot;
    Configuration conf;
    final FileSystemTestHelper fileSystemTestHelper = this.createFileSystemHelper();
    protected static boolean SupportsBlocks = false;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper();
    }

    @Before
    public void setUp() throws Exception {
        this.initializeTargetTestRoot();
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "user"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "data"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "dir2"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "dir3"));
        FileSystemTestHelper.createFile(this.fsTarget, new Path(this.targetTestRoot, "aFile"));
        this.conf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
    }

    void setupMountPoints() {
        ConfigUtil.addLink((Configuration)this.conf, (String)"/targetRoot", (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user2", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data", (URI)new Path(this.targetTestRoot, "data").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/internalDir2/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
    }

    @Test
    public void testGetMountPoints() {
        ViewFileSystem viewfs = (ViewFileSystem)this.fsView;
        ViewFileSystem.MountPoint[] mountPoints = viewfs.getMountPoints();
        Assert.assertEquals((long)this.getExpectedMountPoints(), (long)mountPoints.length);
    }

    int getExpectedMountPoints() {
        return 8;
    }

    @Test
    public void testGetDelegationTokens() throws IOException {
        Token[] delTokens = this.fsView.addDelegationTokens("sanjay", new Credentials());
        Assert.assertEquals((long)this.getExpectedDelegationTokenCount(), (long)delTokens.length);
    }

    int getExpectedDelegationTokenCount() {
        return 0;
    }

    @Test
    public void testGetDelegationTokensWithCredentials() throws IOException {
        Credentials credentials = new Credentials();
        List<Token> delTokens = Arrays.asList(this.fsView.addDelegationTokens("sanjay", credentials));
        int expectedTokenCount = this.getExpectedDelegationTokenCountWithCredentials();
        Assert.assertEquals((long)expectedTokenCount, (long)delTokens.size());
        Credentials newCredentials = new Credentials();
        for (int i = 0; i < expectedTokenCount / 2; ++i) {
            Token token = delTokens.get(i);
            newCredentials.addToken(token.getService(), token);
        }
        List<Token> delTokens2 = Arrays.asList(this.fsView.addDelegationTokens("sanjay", newCredentials));
        Assert.assertEquals((long)((expectedTokenCount + 1) / 2), (long)delTokens2.size());
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 0;
    }

    @Test
    public void testBasicPaths() {
        Assert.assertEquals((Object)FsConstants.VIEWFS_URI, (Object)this.fsView.getUri());
        Assert.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getWorkingDirectory());
        Assert.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.VIEWFS_URI, null), (Object)this.fsView.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testOperationsThroughMountLinks() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        Assert.assertTrue((String)"Created file should be type file", (boolean)this.fsView.isFile(new Path("/user/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/foo")));
        Assert.assertTrue((String)"Delete should suceed", (boolean)this.fsView.delete(new Path("/user/foo"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)this.fsView.exists(new Path("/user/foo")));
        Assert.assertFalse((String)"Target File should not exist after delete", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/foo")));
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/linkToDir2/foo");
        Assert.assertTrue((String)"Created file should be type file", (boolean)this.fsView.isFile(new Path("/internalDir/linkToDir2/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir2/foo")));
        Assert.assertTrue((String)"Delete should suceed", (boolean)this.fsView.delete(new Path("/internalDir/linkToDir2/foo"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)this.fsView.exists(new Path("/internalDir/linkToDir2/foo")));
        Assert.assertFalse((String)"Target File should not exist after delete", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "dir2/foo")));
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/internalDir2/linkToDir3/foo");
        Assert.assertTrue((String)"Created file should be type file", (boolean)this.fsView.isFile(new Path("/internalDir/internalDir2/linkToDir3/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir3/foo")));
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/linkToDir2/missingDir/miss2/foo");
        Assert.assertTrue((String)"Created file should be type file", (boolean)this.fsView.isFile(new Path("/internalDir/linkToDir2/missingDir/miss2/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir2/missingDir/miss2/foo")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fsView.delete(new Path("/internalDir/internalDir2/linkToDir3/foo"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)this.fsView.exists(new Path("/internalDir/internalDir2/linkToDir3/foo")));
        Assert.assertFalse((String)"Target File should not exist after delete", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "dir3/foo")));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        Assert.assertTrue((String)"New dir should be type dir", (boolean)this.fsView.isDirectory(new Path("/user/dirX")));
        Assert.assertTrue((String)"Target of new dir should be of type dir", (boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirX")));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX/dirY"));
        Assert.assertTrue((String)"New dir should be type dir", (boolean)this.fsView.isDirectory(new Path("/user/dirX/dirY")));
        Assert.assertTrue((String)"Target of new dir should be of type dir", (boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirX/dirY")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fsView.delete(new Path("/user/dirX/dirY"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)this.fsView.exists(new Path("/user/dirX/dirY")));
        Assert.assertFalse((String)"Target File should not exist after delete", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirX/dirY")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fsView.delete(new Path("/user/dirX"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)this.fsView.exists(new Path("/user/dirX")));
        Assert.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirX")));
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        this.fsView.rename(new Path("/user/foo"), new Path("/user/fooBar"));
        Assert.assertFalse((String)"Renamed src should not exist", (boolean)this.fsView.exists(new Path("/user/foo")));
        Assert.assertFalse((String)"Renamed src should not exist in target", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/foo")));
        Assert.assertTrue((String)"Renamed dest should  exist as file", (boolean)this.fsView.isFile(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/fooBar")));
        Assert.assertTrue((String)"Renamed dest should  exist as file in target", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/fooBar")));
        this.fsView.mkdirs(new Path("/user/dirFoo"));
        this.fsView.rename(new Path("/user/dirFoo"), new Path("/user/dirFooBar"));
        Assert.assertFalse((String)"Renamed src should not exist", (boolean)this.fsView.exists(new Path("/user/dirFoo")));
        Assert.assertFalse((String)"Renamed src should not exist in target", (boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirFoo")));
        Assert.assertTrue((String)"Renamed dest should  exist as dir", (boolean)this.fsView.isDirectory(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirFooBar")));
        Assert.assertTrue((String)"Renamed dest should  exist as dir in target", (boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirFooBar")));
        this.fsView.mkdirs(new Path("/targetRoot/dirFoo"));
        Assert.assertTrue((boolean)this.fsView.exists(new Path("/targetRoot/dirFoo")));
        boolean dirFooPresent = false;
        for (FileStatus fileStatus : this.fsView.listStatus(new Path("/targetRoot/"))) {
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        Assert.assertTrue((boolean)dirFooPresent);
    }

    @Test(expected=IOException.class)
    public void testRenameAcrossMounts1() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        this.fsView.rename(new Path("/user/foo"), new Path("/user2/fooBarBar"));
    }

    @Test(expected=IOException.class)
    public void testRenameAcrossMounts2() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        this.fsView.rename(new Path("/user/foo"), new Path("/data/fooBar"));
    }

    @Test
    public void testGetBlockLocations() throws IOException {
        Path targetFilePath = new Path(this.targetTestRoot, "data/largeFile");
        FileSystemTestHelper.createFile(this.fsTarget, targetFilePath, 10, 1024);
        Path viewFilePath = new Path("/data/largeFile");
        Assert.assertTrue((String)"Created File should be type File", (boolean)this.fsView.isFile(viewFilePath));
        BlockLocation[] viewBL = this.fsView.getFileBlockLocations(this.fsView.getFileStatus(viewFilePath), 0L, 10340L);
        Assert.assertEquals((long)(SupportsBlocks ? 10L : 1L), (long)viewBL.length);
        BlockLocation[] targetBL = this.fsTarget.getFileBlockLocations(this.fsTarget.getFileStatus(targetFilePath), 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
        this.fsView.getFileBlockLocations(this.fsView.getFileStatus(viewFilePath), 0L, 10340L);
        targetBL = this.fsTarget.getFileBlockLocations(this.fsTarget.getFileStatus(targetFilePath), 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
    }

    void compareBLs(BlockLocation[] viewBL, BlockLocation[] targetBL) {
        Assert.assertEquals((long)targetBL.length, (long)viewBL.length);
        int i = 0;
        for (BlockLocation vbl : viewBL) {
            Assert.assertEquals((Object)vbl.toString(), (Object)targetBL[i].toString());
            Assert.assertEquals((long)targetBL[i].getOffset(), (long)vbl.getOffset());
            Assert.assertEquals((long)targetBL[i].getLength(), (long)vbl.getLength());
            ++i;
        }
    }

    @Test
    public void testListOnInternalDirsOfMountTable() throws IOException {
        FileStatus[] dirPaths = this.fsView.listStatus(new Path("/"));
        this.verifyRootChildren(dirPaths);
        dirPaths = this.fsView.listStatus(new Path("/internalDir"));
        Assert.assertEquals((long)2L, (long)dirPaths.length);
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir/internalDir2", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isDirectory());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir/linkToDir2", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
    }

    private void verifyRootChildren(FileStatus[] dirPaths) throws IOException {
        Assert.assertEquals((long)this.getExpectedDirPaths(), (long)dirPaths.length);
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/user", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isDirectory());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/danglingLink", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/linkToAFile", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
    }

    int getExpectedDirPaths() {
        return 7;
    }

    @Test
    public void testListOnMountTargetDirs() throws IOException {
        FileStatus[] dirPaths = this.fsView.listStatus(new Path("/data"));
        Assert.assertEquals((long)0L, (long)dirPaths.length);
        long len = this.fileSystemTestHelper.createFile(this.fsView, "/data/foo");
        dirPaths = this.fsView.listStatus(new Path("/data"));
        Assert.assertEquals((long)1L, (long)dirPaths.length);
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/foo", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"Created file shoudl appear as a file", (boolean)fs.isFile());
        Assert.assertEquals((long)len, (long)fs.getLen());
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/data/dirX"));
        dirPaths = this.fsView.listStatus(new Path("/data"));
        Assert.assertEquals((long)2L, (long)dirPaths.length);
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/foo", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"Created file shoudl appear as a file", (boolean)fs.isFile());
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/dirX", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"Created dir should appear as a dir", (boolean)fs.isDirectory());
    }

    @Test
    public void testFileStatusOnMountLink() throws IOException {
        Assert.assertTrue((boolean)this.fsView.getFileStatus(new Path("/")).isDirectory());
        FileSystemTestHelper.checkFileStatus(this.fsView, "/", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/user", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/data", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir/linkToDir2", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir/internalDir2/linkToDir3", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/linkToAFile", FileSystemTestHelper.fileType.isFile);
    }

    @Test(expected=FileNotFoundException.class)
    public void testgetFSonDanglingLink() throws IOException {
        this.fsView.getFileStatus(new Path("/danglingLink"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testgetFSonNonExistingInternalDir() throws IOException {
        this.fsView.getFileStatus(new Path("/internalDir/nonExisting"));
    }

    @Test
    public void testResolvePathInternalPaths() throws IOException {
        Assert.assertEquals((Object)new Path("/"), (Object)this.fsView.resolvePath(new Path("/")));
        Assert.assertEquals((Object)new Path("/internalDir"), (Object)this.fsView.resolvePath(new Path("/internalDir")));
    }

    @Test
    public void testResolvePathMountPoints() throws IOException {
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user"), (Object)this.fsView.resolvePath(new Path("/user")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "data"), (Object)this.fsView.resolvePath(new Path("/data")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "dir2"), (Object)this.fsView.resolvePath(new Path("/internalDir/linkToDir2")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "dir3"), (Object)this.fsView.resolvePath(new Path("/internalDir/internalDir2/linkToDir3")));
    }

    @Test
    public void testResolvePathThroughMountPoints() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/foo"), (Object)this.fsView.resolvePath(new Path("/user/foo")));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX"), (Object)this.fsView.resolvePath(new Path("/user/dirX")));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX/dirY"));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX/dirY"), (Object)this.fsView.resolvePath(new Path("/user/dirX/dirY")));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathDanglingLink() throws IOException {
        this.fsView.resolvePath(new Path("/danglingLink"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathMissingThroughMountPoints() throws IOException {
        this.fsView.resolvePath(new Path("/user/nonExisting"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathMissingThroughMountPoints2() throws IOException {
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        this.fsView.resolvePath(new Path("/user/dirX/nonExisting"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirSlash() throws IOException {
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/"));
    }

    public void testInternalMkdirExisting1() throws IOException {
        Assert.assertTrue((String)"mkdir of existing dir should succeed", (boolean)this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir")));
    }

    public void testInternalMkdirExisting2() throws IOException {
        Assert.assertTrue((String)"mkdir of existing dir should succeed", (boolean)this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir/linkToDir2")));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirNew() throws IOException {
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/dirNew"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirNew2() throws IOException {
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir/dirNew"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreate1() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreate2() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/missingDir/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir2() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/missingDir/miss2/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir3() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/miss2/foo");
    }

    @Test(expected=FileNotFoundException.class)
    public void testInternalDeleteNonExisting() throws IOException {
        this.fsView.delete(new Path("/NonExisting"), false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testInternalDeleteNonExisting2() throws IOException {
        this.fsView.delete(new Path("/internalDir/NonExisting"), false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalDeleteExisting() throws IOException {
        this.fsView.delete(new Path("/internalDir"), false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalDeleteExisting2() throws IOException {
        this.fsView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory();
        this.fsView.delete(new Path("/internalDir/linkToDir2"), false);
    }

    @Test
    public void testMkdirOfMountLink() throws IOException {
        Assert.assertTrue((String)"mkdir of existing mount link should succeed", (boolean)this.fsView.mkdirs(new Path("/data")));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename1() throws IOException {
        this.fsView.rename(new Path("/internalDir"), new Path("/newDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename2() throws IOException {
        this.fsView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory();
        this.fsView.rename(new Path("/internalDir/linkToDir2"), new Path("/internalDir/dir1"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename3() throws IOException {
        this.fsView.rename(new Path("/user"), new Path("/internalDir/linkToDir2"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRenameToSlash() throws IOException {
        this.fsView.rename(new Path("/internalDir/linkToDir2/foo"), new Path("/"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRenameFromSlash() throws IOException {
        this.fsView.rename(new Path("/"), new Path("/bar"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetOwner() throws IOException {
        this.fsView.setOwner(new Path("/internalDir"), "foo", "bar");
    }

    @Test
    public void testCreateNonRecursive() throws IOException {
        Path path = this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/foo");
        this.fsView.createNonRecursive(path, false, 1024, (short)1, 1024L, null);
        FileStatus status = this.fsView.getFileStatus(new Path("/user/foo"));
        Assert.assertTrue((String)"Created file should be type file", (boolean)this.fsView.isFile(new Path("/user/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/foo")));
    }

    @Test
    public void testRootReadableExecutable() throws IOException {
        Assert.assertFalse((String)"In root before cd", (boolean)this.fsView.getWorkingDirectory().isRoot());
        this.fsView.setWorkingDirectory(new Path("/"));
        Assert.assertTrue((String)"Not in root dir after cd", (boolean)this.fsView.getWorkingDirectory().isRoot());
        this.verifyRootChildren(this.fsView.listStatus(this.fsView.getWorkingDirectory()));
        FileStatus rootStatus = this.fsView.getFileStatus(this.fsView.getWorkingDirectory());
        FsPermission perms = rootStatus.getPermission();
        Assert.assertTrue((String)"User-executable permission not set!", (boolean)perms.getUserAction().implies(FsAction.EXECUTE));
        Assert.assertTrue((String)"User-readable permission not set!", (boolean)perms.getUserAction().implies(FsAction.READ));
        Assert.assertTrue((String)"Group-executable permission not set!", (boolean)perms.getGroupAction().implies(FsAction.EXECUTE));
        Assert.assertTrue((String)"Group-readable permission not set!", (boolean)perms.getGroupAction().implies(FsAction.READ));
        Assert.assertTrue((String)"Other-executable permission not set!", (boolean)perms.getOtherAction().implies(FsAction.EXECUTE));
        Assert.assertTrue((String)"Other-readable permission not set!", (boolean)perms.getOtherAction().implies(FsAction.READ));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalModifyAclEntries() throws IOException {
        this.fsView.modifyAclEntries(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveAclEntries() throws IOException {
        this.fsView.removeAclEntries(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveDefaultAcl() throws IOException {
        this.fsView.removeDefaultAcl(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveAcl() throws IOException {
        this.fsView.removeAcl(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetAcl() throws IOException {
        this.fsView.setAcl(new Path("/internalDir"), new ArrayList());
    }

    @Test
    public void testInternalGetAclStatus() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        AclStatus aclStatus = this.fsView.getAclStatus(new Path("/internalDir"));
        Assert.assertEquals((Object)aclStatus.getOwner(), (Object)currentUser.getUserName());
        Assert.assertEquals((Object)aclStatus.getGroup(), (Object)currentUser.getGroupNames()[0]);
        Assert.assertEquals((Object)aclStatus.getEntries(), (Object)AclUtil.getMinimalAcl((FsPermission)Constants.PERMISSION_555));
        Assert.assertFalse((boolean)aclStatus.isStickyBit());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetXAttr() throws IOException {
        this.fsView.setXAttr(new Path("/internalDir"), "xattrName", null);
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttr() throws IOException {
        this.fsView.getXAttr(new Path("/internalDir"), "xattrName");
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttrs() throws IOException {
        this.fsView.getXAttrs(new Path("/internalDir"));
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttrsWithNames() throws IOException {
        this.fsView.getXAttrs(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalListXAttr() throws IOException {
        this.fsView.listXAttrs(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveXAttr() throws IOException {
        this.fsView.removeXAttr(new Path("/internalDir"), "xattrName");
    }
}

