/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.Errno;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.security.UserGroupInformation;

public class SecureIOUtils {
    private static final boolean skipSecurity;
    private static final FileSystem rawFilesystem;

    public static FileInputStream openForRead(File f, String expectedOwner, String expectedGroup) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return new FileInputStream(f);
        }
        return SecureIOUtils.forceSecureOpenForRead(f, expectedOwner, expectedGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileInputStream forceSecureOpenForRead(File f, String expectedOwner, String expectedGroup) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        boolean success = false;
        try {
            NativeIO.Stat stat = NativeIO.fstat(fis.getFD());
            SecureIOUtils.checkStat(f, stat.getOwner(), stat.getGroup(), expectedOwner, expectedGroup);
            success = true;
            FileInputStream fileInputStream = fis;
            return fileInputStream;
        }
        finally {
            if (!success) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOutputStream insecureCreateForWrite(File f, int permissions) throws IOException {
        if (f.exists()) {
            throw new AlreadyExistsException("File " + f + " already exists");
        }
        FileOutputStream fos = new FileOutputStream(f);
        boolean success = false;
        try {
            rawFilesystem.setPermission(new Path(f.getAbsolutePath()), new FsPermission((short)permissions));
            success = true;
            FileOutputStream fileOutputStream = fos;
            return fileOutputStream;
        }
        finally {
            if (!success) {
                fos.close();
            }
        }
    }

    public static FileOutputStream createForWrite(File f, int permissions) throws IOException {
        if (skipSecurity) {
            return SecureIOUtils.insecureCreateForWrite(f, permissions);
        }
        try {
            FileDescriptor fd = NativeIO.open(f.getAbsolutePath(), 193, permissions);
            return new FileOutputStream(fd);
        }
        catch (NativeIOException nioe) {
            if (nioe.getErrno() == Errno.EEXIST) {
                throw new AlreadyExistsException(nioe);
            }
            throw nioe;
        }
    }

    private static void checkStat(File f, String owner, String group, String expectedOwner, String expectedGroup) throws IOException {
        if (expectedOwner != null && !expectedOwner.equals(owner)) {
            throw new IOException("Owner '" + owner + "' for path " + f + " did not match " + "expected owner '" + expectedOwner + "'");
        }
        if (expectedGroup != null && !expectedGroup.equals(group)) {
            throw new IOException("Group '" + group + "' for path " + f + " did not match " + "expected group '" + expectedGroup + "'");
        }
    }

    static {
        boolean shouldBeSecure = UserGroupInformation.isSecurityEnabled();
        boolean canBeSecure = NativeIO.isAvailable();
        if (!canBeSecure && shouldBeSecure) {
            throw new RuntimeException("Secure IO is not possible without native code extensions.");
        }
        try {
            rawFilesystem = FileSystem.getLocal(new Configuration()).getRaw();
        }
        catch (IOException ie) {
            throw new RuntimeException("Couldn't obtain an instance of RawLocalFileSystem.");
        }
        skipSecurity = !canBeSecure;
    }

    public static class AlreadyExistsException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AlreadyExistsException(String msg) {
            super(msg);
        }

        public AlreadyExistsException(Throwable cause) {
            super(cause);
        }
    }
}

