/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.UUID;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata {
    public static final String PIG_INPUT_RPC_PORT = "PIG_INPUT_RPC_PORT";
    public static final String PIG_INPUT_INITIAL_ADDRESS = "PIG_INPUT_INITIAL_ADDRESS";
    public static final String PIG_INPUT_PARTITIONER = "PIG_INPUT_PARTITIONER";
    public static final String PIG_OUTPUT_RPC_PORT = "PIG_OUTPUT_RPC_PORT";
    public static final String PIG_OUTPUT_INITIAL_ADDRESS = "PIG_OUTPUT_INITIAL_ADDRESS";
    public static final String PIG_OUTPUT_PARTITIONER = "PIG_OUTPUT_PARTITIONER";
    public static final String PIG_RPC_PORT = "PIG_RPC_PORT";
    public static final String PIG_INITIAL_ADDRESS = "PIG_INITIAL_ADDRESS";
    public static final String PIG_PARTITIONER = "PIG_PARTITIONER";
    public static final String PIG_INPUT_FORMAT = "PIG_INPUT_FORMAT";
    public static final String PIG_OUTPUT_FORMAT = "PIG_OUTPUT_FORMAT";
    public static final String PIG_ALLOW_DELETES = "PIG_ALLOW_DELETES";
    public static final String PIG_WIDEROW_INPUT = "PIG_WIDEROW_INPUT";
    public static final String PIG_USE_SECONDARY = "PIG_USE_SECONDARY";
    public static final String PIG_INPUT_SPLIT_SIZE = "PIG_INPUT_SPLIT_SIZE";
    private static final String DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyInputFormat";
    private static final String DEFAULT_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.ColumnFamilyOutputFormat";
    private static final String PARTITION_FILTER_SIGNATURE = "cassandra.partition.filter";
    private static final ByteBuffer BOUND = ByteBufferUtil.EMPTY_BYTE_BUFFER;
    private static final Logger logger = LoggerFactory.getLogger(CassandraStorage.class);
    private ByteBuffer slice_start = BOUND;
    private ByteBuffer slice_end = BOUND;
    private boolean slice_reverse = false;
    private boolean allow_deletes = false;
    private String username;
    private String password;
    private String keyspace;
    private String column_family;
    private String loadSignature;
    private String storeSignature;
    private Configuration conf;
    private RecordReader<ByteBuffer, Map<ByteBuffer, IColumn>> reader;
    private RecordWriter<ByteBuffer, List<Mutation>> writer;
    private String inputFormatClass;
    private String outputFormatClass;
    private int limit;
    private boolean widerows = false;
    private boolean usePartitionFilter = false;
    private int splitSize = 65536;
    private ByteBuffer lastKey;
    private Map<ByteBuffer, IColumn> lastRow;
    private boolean hasNext = true;

    public CassandraStorage() {
        this(1024);
    }

    public CassandraStorage(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public Tuple getNextWide() throws IOException {
        CfDef cfDef = this.getCfDef(this.loadSignature);
        ByteBuffer key = null;
        Tuple tuple = null;
        DefaultDataBag bag = new DefaultDataBag();
        try {
            block2: while (true) {
                this.hasNext = this.reader.nextKeyValue();
                if (!this.hasNext) {
                    if (tuple == null) {
                        tuple = TupleFactory.getInstance().newTuple();
                    }
                    if (this.lastRow != null) {
                        if (tuple.size() == 0) {
                            key = (ByteBuffer)this.reader.getCurrentKey();
                            tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, IColumn> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        this.lastKey = null;
                        this.lastRow = null;
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    if (tuple.size() == 1) {
                        tuple.append((Object)bag);
                        return tuple;
                    }
                    return null;
                }
                if (key != null && !((ByteBuffer)this.reader.getCurrentKey()).equals(key)) {
                    this.lastKey = (ByteBuffer)this.reader.getCurrentKey();
                    this.lastRow = (SortedMap)this.reader.getCurrentValue();
                    tuple.append((Object)bag);
                    return tuple;
                }
                if (key == null) {
                    key = (ByteBuffer)this.reader.getCurrentKey();
                    if (this.lastKey != null && !key.equals(this.lastKey)) {
                        if (tuple == null) {
                            tuple = this.keyToTuple(this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        } else {
                            this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                        }
                        for (Map.Entry<ByteBuffer, IColumn> entry : this.lastRow.entrySet()) {
                            bag.add(this.columnToTuple(entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                        }
                        tuple.append((Object)bag);
                        this.lastKey = key;
                        this.lastRow = (SortedMap)this.reader.getCurrentValue();
                        return tuple;
                    }
                    if (tuple == null) {
                        tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    } else {
                        this.addKeyToTuple(tuple, this.lastKey, cfDef, this.parseType(cfDef.getKey_validation_class()));
                    }
                }
                SortedMap row = (SortedMap)this.reader.getCurrentValue();
                if (this.lastRow != null) {
                    for (Map.Entry<Object, Object> entry : this.lastRow.entrySet()) {
                        bag.add(this.columnToTuple((IColumn)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                    }
                    this.lastKey = null;
                    this.lastRow = null;
                }
                Iterator<Map.Entry<Object, Object>> i$ = row.entrySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Map.Entry<Object, Object> entry = i$.next();
                    bag.add(this.columnToTuple((IColumn)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Tuple getNext() throws IOException {
        if (this.widerows) {
            return this.getNextWide();
        }
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            CfDef cfDef = this.getCfDef(this.loadSignature);
            ByteBuffer key = (ByteBuffer)this.reader.getCurrentKey();
            Map cf = (Map)this.reader.getCurrentValue();
            assert (key != null && cf != null);
            Tuple tuple = this.keyToTuple(key, cfDef, this.parseType(cfDef.getKey_validation_class()));
            DefaultDataBag bag = new DefaultDataBag();
            HashMap<ByteBuffer, Boolean> added = new HashMap<ByteBuffer, Boolean>();
            for (ColumnDef columnDef : cfDef.column_metadata) {
                if (cf.containsKey(columnDef.name)) {
                    tuple.append((Object)this.columnToTuple((IColumn)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type())));
                } else {
                    tuple.append((Object)TupleFactory.getInstance().newTuple());
                }
                added.put(columnDef.name, true);
            }
            for (Map.Entry entry : cf.entrySet()) {
                if (added.containsKey(entry.getKey())) continue;
                bag.add(this.columnToTuple((IColumn)entry.getValue(), cfDef, this.parseType(cfDef.getComparator_type())));
            }
            tuple.append((Object)bag);
            if (this.usePartitionFilter) {
                for (ColumnDef columnDef : this.getIndexes()) {
                    Tuple throwaway = this.columnToTuple((IColumn)cf.get(columnDef.name), cfDef, this.parseType(cfDef.getComparator_type()));
                    tuple.append(throwaway.get(1));
                }
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Tuple composeComposite(AbstractCompositeType comparator, ByteBuffer name) throws IOException {
        List<AbstractCompositeType.CompositeComponent> result = comparator.deconstruct(name);
        Tuple t = TupleFactory.getInstance().newTuple(result.size());
        for (int i = 0; i < result.size(); ++i) {
            this.setTupleValue(t, i, result.get((int)i).comparator.compose(result.get((int)i).value));
        }
        return t;
    }

    private Tuple keyToTuple(ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple tuple = TupleFactory.getInstance().newTuple(1);
        this.addKeyToTuple(tuple, key, cfDef, comparator);
        return tuple;
    }

    private void addKeyToTuple(Tuple tuple, ByteBuffer key, CfDef cfDef, AbstractType comparator) throws IOException {
        if (comparator instanceof AbstractCompositeType) {
            this.setTupleValue(tuple, 0, this.composeComposite((AbstractCompositeType)comparator, key));
        } else {
            this.setTupleValue(tuple, 0, this.getDefaultMarshallers(cfDef).get((Object)MarshallerType.KEY_VALIDATOR).compose(key));
        }
    }

    private Tuple columnToTuple(IColumn col, CfDef cfDef, AbstractType comparator) throws IOException {
        Tuple pair = TupleFactory.getInstance().newTuple(2);
        if (comparator instanceof AbstractCompositeType) {
            this.setTupleValue(pair, 0, this.composeComposite((AbstractCompositeType)comparator, col.name()));
        } else {
            this.setTupleValue(pair, 0, comparator.compose(col.name()));
        }
        if (col instanceof org.apache.cassandra.db.Column) {
            Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
            if (validators.get(col.name()) == null) {
                Map<MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
                this.setTupleValue(pair, 1, marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR).compose(col.value()));
            } else {
                this.setTupleValue(pair, 1, validators.get(col.name()).compose(col.value()));
            }
            return pair;
        }
        ArrayList<Tuple> subcols = new ArrayList<Tuple>();
        for (IColumn subcol : col.getSubColumns()) {
            subcols.add(this.columnToTuple(subcol, cfDef, this.parseType(cfDef.getSubcomparator_type())));
        }
        pair.set(1, (Object)new DefaultDataBag(subcols));
        return pair;
    }

    private void setTupleValue(Tuple pair, int position, Object value) throws ExecException {
        if (value instanceof BigInteger) {
            pair.set(position, (Object)((BigInteger)value).intValue());
        } else if (value instanceof ByteBuffer) {
            pair.set(position, (Object)new DataByteArray(ByteBufferUtil.getArray((ByteBuffer)value)));
        } else if (value instanceof UUID) {
            pair.set(position, (Object)new DataByteArray(UUIDGen.decompose((UUID)value)));
        } else if (value instanceof Date) {
            pair.set(position, (Object)DateType.instance.decompose((Date)value).getLong());
        } else {
            pair.set(position, value);
        }
    }

    private CfDef getCfDef(String signature) {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        return CassandraStorage.cfdefFromString(property.getProperty(signature));
    }

    private List<IndexExpression> getIndexExpressions() {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        if (property.getProperty(PARTITION_FILTER_SIGNATURE) != null) {
            return CassandraStorage.indexExpressionsFromString(property.getProperty(PARTITION_FILTER_SIGNATURE));
        }
        return null;
    }

    private Map<MarshallerType, AbstractType> getDefaultMarshallers(CfDef cfDef) throws IOException {
        EnumMap<MarshallerType, AbstractType> marshallers = new EnumMap<MarshallerType, AbstractType>(MarshallerType.class);
        AbstractType comparator = this.parseType(cfDef.getComparator_type());
        AbstractType subcomparator = this.parseType(cfDef.getSubcomparator_type());
        AbstractType default_validator = this.parseType(cfDef.getDefault_validation_class());
        AbstractType key_validator = this.parseType(cfDef.getKey_validation_class());
        marshallers.put(MarshallerType.COMPARATOR, comparator);
        marshallers.put(MarshallerType.DEFAULT_VALIDATOR, default_validator);
        marshallers.put(MarshallerType.KEY_VALIDATOR, key_validator);
        marshallers.put(MarshallerType.SUBCOMPARATOR, subcomparator);
        return marshallers;
    }

    private Map<ByteBuffer, AbstractType> getValidatorMap(CfDef cfDef) throws IOException {
        HashMap<ByteBuffer, AbstractType> validators = new HashMap<ByteBuffer, AbstractType>();
        for (ColumnDef cd : cfDef.getColumn_metadata()) {
            if (cd.getValidation_class() == null || cd.getValidation_class().isEmpty()) continue;
            AbstractType<?> validator = null;
            try {
                validator = TypeParser.parse(cd.getValidation_class());
                validators.put(cd.name, validator);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            catch (SyntaxException e) {
                throw new IOException(e);
            }
        }
        return validators;
    }

    private AbstractType parseType(String type) throws IOException {
        try {
            if (type != null && type.equals("org.apache.cassandra.db.marshal.CounterColumnType")) {
                return LongType.instance;
            }
            return TypeParser.parse(type);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        catch (SyntaxException e) {
            throw new IOException(e);
        }
    }

    public InputFormat getInputFormat() {
        try {
            return (InputFormat)FBUtilities.construct(this.inputFormatClass, "inputformat");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] keyValue = param.split("=");
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cassandra://")) {
                throw new Exception("Bad scheme.");
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CassandraStorage.getQueryMap(urlParts[1]);
                AbstractType comparator = BytesType.instance;
                if (urlQuery.containsKey("comparator")) {
                    comparator = TypeParser.parse(urlQuery.get("comparator"));
                }
                if (urlQuery.containsKey("slice_start")) {
                    this.slice_start = comparator.fromString(urlQuery.get("slice_start"));
                }
                if (urlQuery.containsKey("slice_end")) {
                    this.slice_end = comparator.fromString(urlQuery.get("slice_end"));
                }
                if (urlQuery.containsKey("reversed")) {
                    this.slice_reverse = Boolean.parseBoolean(urlQuery.get("reversed"));
                }
                if (urlQuery.containsKey("limit")) {
                    this.limit = Integer.parseInt(urlQuery.get("limit"));
                }
                if (urlQuery.containsKey("allow_deletes")) {
                    this.allow_deletes = Boolean.parseBoolean(urlQuery.get("allow_deletes"));
                }
                if (urlQuery.containsKey("widerows")) {
                    this.widerows = Boolean.parseBoolean(urlQuery.get("widerows"));
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cassandra://[username:password@]<keyspace>/<columnfamily>[?slice_start=<start>&slice_end=<end>[&reversed=true][&limit=1][&allow_deletes=true][widerows=true][use_secondary=true]]': " + e.getMessage());
        }
    }

    private void setConnectionInformation() throws IOException {
        if (System.getenv(PIG_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(this.conf, System.getenv(PIG_RPC_PORT));
            ConfigHelper.setOutputRpcPort(this.conf, System.getenv(PIG_RPC_PORT));
        }
        if (System.getenv(PIG_INPUT_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(this.conf, System.getenv(PIG_INPUT_RPC_PORT));
        }
        if (System.getenv(PIG_OUTPUT_RPC_PORT) != null) {
            ConfigHelper.setOutputRpcPort(this.conf, System.getenv(PIG_OUTPUT_RPC_PORT));
        }
        if (System.getenv(PIG_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(this.conf, System.getenv(PIG_INITIAL_ADDRESS));
            ConfigHelper.setOutputInitialAddress(this.conf, System.getenv(PIG_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_INPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(this.conf, System.getenv(PIG_INPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_OUTPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setOutputInitialAddress(this.conf, System.getenv(PIG_OUTPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(this.conf, System.getenv(PIG_PARTITIONER));
            ConfigHelper.setOutputPartitioner(this.conf, System.getenv(PIG_PARTITIONER));
        }
        if (System.getenv(PIG_INPUT_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(this.conf, System.getenv(PIG_INPUT_PARTITIONER));
        }
        if (System.getenv(PIG_OUTPUT_PARTITIONER) != null) {
            ConfigHelper.setOutputPartitioner(this.conf, System.getenv(PIG_OUTPUT_PARTITIONER));
        }
        this.inputFormatClass = System.getenv(PIG_INPUT_FORMAT) != null ? this.getFullyQualifiedClassName(System.getenv(PIG_INPUT_FORMAT)) : DEFAULT_INPUT_FORMAT;
        this.outputFormatClass = System.getenv(PIG_OUTPUT_FORMAT) != null ? this.getFullyQualifiedClassName(System.getenv(PIG_OUTPUT_FORMAT)) : DEFAULT_OUTPUT_FORMAT;
        if (System.getenv(PIG_ALLOW_DELETES) != null) {
            this.allow_deletes = Boolean.parseBoolean(System.getenv(PIG_ALLOW_DELETES));
        }
    }

    private String getFullyQualifiedClassName(String classname) {
        return classname.contains(".") ? classname : "org.apache.cassandra.hadoop." + classname;
    }

    public void setLocation(String location, Job job) throws IOException {
        this.conf = job.getConfiguration();
        this.conf.setBoolean("pig.noSplitCombination", true);
        this.setLocationFromUri(location);
        if (ConfigHelper.getInputSlicePredicate(this.conf) == null) {
            SliceRange range = new SliceRange(this.slice_start, this.slice_end, this.slice_reverse, this.limit);
            SlicePredicate predicate = new SlicePredicate().setSlice_range(range);
            ConfigHelper.setInputSlicePredicate(this.conf, predicate);
        }
        if (System.getenv(PIG_WIDEROW_INPUT) != null) {
            this.widerows = Boolean.valueOf(System.getenv(PIG_WIDEROW_INPUT));
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.valueOf(System.getenv(PIG_USE_SECONDARY));
        }
        if (System.getenv(PIG_INPUT_SPLIT_SIZE) != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.valueOf(System.getenv(PIG_INPUT_SPLIT_SIZE)));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (this.usePartitionFilter && this.getIndexExpressions() != null) {
            ConfigHelper.setInputRange(this.conf, this.getIndexExpressions());
        }
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family, this.widerows);
        this.setConnectionInformation();
        if (ConfigHelper.getInputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_INPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.setLocation(location, job);
        CfDef cfDef = this.getCfDef(this.loadSignature);
        if (cfDef.column_type.equals("Super")) {
            return null;
        }
        ResourceSchema schema = new ResourceSchema();
        Map<MarshallerType, AbstractType> marshallers = this.getDefaultMarshallers(cfDef);
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        ResourceSchema.ResourceFieldSchema keyFieldSchema = new ResourceSchema.ResourceFieldSchema();
        keyFieldSchema.setName("key");
        keyFieldSchema.setType(this.getPigType(marshallers.get((Object)MarshallerType.KEY_VALIDATOR)));
        ResourceSchema bagSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagField = new ResourceSchema.ResourceFieldSchema();
        bagField.setType((byte)120);
        bagField.setName("columns");
        ResourceSchema bagTupleSchema = new ResourceSchema();
        ResourceSchema.ResourceFieldSchema bagTupleField = new ResourceSchema.ResourceFieldSchema();
        bagTupleField.setType((byte)110);
        ResourceSchema.ResourceFieldSchema bagcolSchema = new ResourceSchema.ResourceFieldSchema();
        ResourceSchema.ResourceFieldSchema bagvalSchema = new ResourceSchema.ResourceFieldSchema();
        bagcolSchema.setName("name");
        bagvalSchema.setName("value");
        bagcolSchema.setType(this.getPigType(marshallers.get((Object)MarshallerType.COMPARATOR)));
        bagvalSchema.setType(this.getPigType(marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR)));
        bagTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagcolSchema, bagvalSchema});
        bagTupleField.setSchema(bagTupleSchema);
        bagSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{bagTupleField});
        bagField.setSchema(bagSchema);
        ArrayList<ResourceSchema.ResourceFieldSchema> allSchemaFields = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        allSchemaFields.add(keyFieldSchema);
        for (ColumnDef cdef : cfDef.column_metadata) {
            ResourceSchema innerTupleSchema = new ResourceSchema();
            ResourceSchema.ResourceFieldSchema innerTupleField = new ResourceSchema.ResourceFieldSchema();
            innerTupleField.setType((byte)110);
            innerTupleField.setSchema(innerTupleSchema);
            innerTupleField.setName(new String(cdef.getName()));
            ResourceSchema.ResourceFieldSchema idxColSchema = new ResourceSchema.ResourceFieldSchema();
            idxColSchema.setName("name");
            idxColSchema.setType(this.getPigType(marshallers.get((Object)MarshallerType.COMPARATOR)));
            ResourceSchema.ResourceFieldSchema valSchema = new ResourceSchema.ResourceFieldSchema();
            AbstractType validator = validators.get(cdef.name);
            if (validator == null) {
                validator = marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR);
            }
            valSchema.setName("value");
            valSchema.setType(this.getPigType(validator));
            innerTupleSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{idxColSchema, valSchema});
            allSchemaFields.add(innerTupleField);
        }
        allSchemaFields.add(bagField);
        if (this.usePartitionFilter) {
            for (ColumnDef cdef : this.getIndexes()) {
                ResourceSchema.ResourceFieldSchema idxSchema = new ResourceSchema.ResourceFieldSchema();
                idxSchema.setName("index_" + new String(cdef.getName()));
                AbstractType validator = validators.get(cdef.name);
                if (validator == null) {
                    validator = marshallers.get((Object)MarshallerType.DEFAULT_VALIDATOR);
                }
                idxSchema.setType(this.getPigType(validator));
                allSchemaFields.add(idxSchema);
            }
        }
        schema.setFields(allSchemaFields.toArray(new ResourceSchema.ResourceFieldSchema[allSchemaFields.size()]));
        return schema;
    }

    private byte getPigType(AbstractType type) {
        if (type instanceof LongType || type instanceof DateType) {
            return 15;
        }
        if (type instanceof IntegerType || type instanceof Int32Type) {
            return 10;
        }
        if (type instanceof AsciiType) {
            return 55;
        }
        if (type instanceof UTF8Type) {
            return 55;
        }
        if (type instanceof FloatType) {
            return 20;
        }
        if (type instanceof DoubleType) {
            return 25;
        }
        if (type instanceof AbstractCompositeType) {
            return 110;
        }
        return 50;
    }

    public ResourceStatistics getStatistics(String location, Job job) {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) {
        if (!this.usePartitionFilter) {
            return null;
        }
        List<ColumnDef> indexes = this.getIndexes();
        String[] partitionKeys = new String[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            partitionKeys[i] = new String(indexes.get(i).getName());
        }
        return partitionKeys;
    }

    public void setPartitionFilter(Expression partitionFilter) {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CassandraStorage.class);
        property.setProperty(PARTITION_FILTER_SIGNATURE, CassandraStorage.indexExpressionsToString(this.filterToIndexExpressions(partitionFilter)));
    }

    private List<IndexExpression> filterToIndexExpressions(Expression expression) {
        ArrayList<IndexExpression> indexExpressions = new ArrayList<IndexExpression>();
        Expression.BinaryExpression be = (Expression.BinaryExpression)expression;
        ByteBuffer name = ByteBuffer.wrap(be.getLhs().toString().getBytes());
        ByteBuffer value = ByteBuffer.wrap(be.getRhs().toString().getBytes());
        switch (expression.getOpType()) {
            case OP_EQ: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.EQ, value));
                break;
            }
            case OP_GE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GTE, value));
                break;
            }
            case OP_GT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.GT, value));
                break;
            }
            case OP_LE: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LTE, value));
                break;
            }
            case OP_LT: {
                indexExpressions.add(new IndexExpression(name, IndexOperator.LT, value));
                break;
            }
            case OP_AND: {
                indexExpressions.addAll(this.filterToIndexExpressions(be.getLhs()));
                indexExpressions.addAll(this.filterToIndexExpressions(be.getRhs()));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported expression type: " + expression.getOpType().name());
            }
        }
        return indexExpressions;
    }

    private List<ColumnDef> getIndexes() {
        CfDef cfdef = this.getCfDef(this.loadSignature);
        ArrayList<ColumnDef> indexes = new ArrayList<ColumnDef>();
        for (ColumnDef cdef : cfdef.column_metadata) {
            if (cdef.index_type == null) continue;
            indexes.add(cdef);
        }
        return indexes;
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public void setUDFContextSignature(String signature) {
        this.loadSignature = signature;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.storeSignature = signature;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return this.relativeToAbsolutePath(location, curDir);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.conf = job.getConfiguration();
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setOutputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        ConfigHelper.setOutputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        if (ConfigHelper.getOutputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_OUTPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getOutputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getOutputPartitioner(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (System.getenv(PIG_USE_SECONDARY) != null) {
            this.usePartitionFilter = Boolean.valueOf(System.getenv(PIG_USE_SECONDARY));
        }
        this.initSchema(this.storeSignature);
    }

    public OutputFormat getOutputFormat() {
        try {
            return (OutputFormat)FBUtilities.construct(this.outputFormatClass, "outputformat");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
    }

    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    private ByteBuffer objToBB(Object o) {
        if (o == null) {
            return (ByteBuffer)o;
        }
        if (o instanceof String) {
            return ByteBuffer.wrap(new DataByteArray((String)o).get());
        }
        if (o instanceof Integer) {
            return Int32Type.instance.decompose((Integer)o);
        }
        if (o instanceof Long) {
            return LongType.instance.decompose((Long)o);
        }
        if (o instanceof Float) {
            return FloatType.instance.decompose((Float)o);
        }
        if (o instanceof Double) {
            return DoubleType.instance.decompose((Double)o);
        }
        if (o instanceof UUID) {
            return ByteBuffer.wrap(UUIDGen.decompose((UUID)o));
        }
        if (o instanceof Tuple) {
            List objects = ((Tuple)o).getAll();
            ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
            int totalLength = 0;
            for (Object sub : objects) {
                ByteBuffer buffer = this.objToBB(sub);
                serialized.add(buffer);
                totalLength += 2 + buffer.remaining() + 1;
            }
            ByteBuffer out = ByteBuffer.allocate(totalLength);
            for (ByteBuffer bb : serialized) {
                int length = bb.remaining();
                out.put((byte)(length >> 8 & 0xFF));
                out.put((byte)(length & 0xFF));
                out.put(bb);
                out.put((byte)0);
            }
            out.flip();
            return out;
        }
        return ByteBuffer.wrap(((DataByteArray)o).get());
    }

    public void putNext(Tuple t) throws IOException {
        if (t.size() < 1) {
            logger.warn("Empty output skipped, filter empty tuples to suppress this warning");
            return;
        }
        ByteBuffer key = this.objToBB(t.get(0));
        if (t.getType(1) == 110) {
            this.writeColumnsFromTuple(key, t, 1);
        } else if (t.getType(1) == 120) {
            if (t.size() > 2) {
                throw new IOException("No arguments allowed after bag");
            }
            this.writeColumnsFromBag(key, (DefaultDataBag)t.get(1));
        } else {
            throw new IOException("Second argument in output must be a tuple or bag");
        }
    }

    private void writeColumnsFromTuple(ByteBuffer key, Tuple t, int offset) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (int i = offset; i < t.size(); ++i) {
            if (t.getType(i) == 120) {
                this.writeColumnsFromBag(key, (DefaultDataBag)t.get(i));
                continue;
            }
            if (t.getType(i) == 110) {
                Tuple inner = (Tuple)t.get(i);
                if (inner.size() <= 0) continue;
                mutationList.add(this.mutationFromTuple(inner));
                continue;
            }
            if (this.usePartitionFilter) continue;
            throw new IOException("Output type was not a bag or a tuple");
        }
        if (mutationList.size() > 0) {
            this.writeMutations(key, mutationList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Mutation mutationFromTuple(Tuple t) throws IOException {
        Mutation mutation = new Mutation();
        if (t.get(1) == null) {
            if (!this.allow_deletes) throw new IOException("null found but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
            mutation.deletion = new Deletion();
            mutation.deletion.predicate = new SlicePredicate();
            mutation.deletion.predicate.column_names = Arrays.asList(this.objToBB(t.get(0)));
            mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
            return mutation;
        } else {
            Column column = new Column();
            column.setName(this.objToBB(t.get(0)));
            column.setValue(this.objToBB(t.get(1)));
            column.setTimestamp(FBUtilities.timestampMicros());
            mutation.column_or_supercolumn = new ColumnOrSuperColumn();
            mutation.column_or_supercolumn.column = column;
        }
        return mutation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeColumnsFromBag(ByteBuffer key, DefaultDataBag bag) throws IOException {
        ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
        for (Tuple pair : bag) {
            Mutation mutation = new Mutation();
            if (DataType.findType((Object)pair.get(1)) == 120) {
                SuperColumn sc = new SuperColumn();
                sc.setName(this.objToBB(pair.get(0)));
                ArrayList<Column> columns = new ArrayList<Column>();
                for (Tuple subcol : (DefaultDataBag)pair.get(1)) {
                    Column column = new Column();
                    column.setName(this.objToBB(subcol.get(0)));
                    column.setValue(this.objToBB(subcol.get(1)));
                    column.setTimestamp(FBUtilities.timestampMicros());
                    columns.add(column);
                }
                if (columns.isEmpty()) {
                    if (!this.allow_deletes) throw new IOException("SuperColumn deletion attempted with empty bag, but deletes are disabled, set PIG_ALLOW_DELETES=true in environment or allow_deletes=true in URL to enable");
                    mutation.deletion = new Deletion();
                    mutation.deletion.super_column = this.objToBB(pair.get(0));
                    mutation.deletion.setTimestamp(FBUtilities.timestampMicros());
                } else {
                    sc.columns = columns;
                    mutation.column_or_supercolumn = new ColumnOrSuperColumn();
                    mutation.column_or_supercolumn.super_column = sc;
                }
            } else {
                mutation = this.mutationFromTuple(pair);
            }
            mutationList.add(mutation);
            if (mutationList.size() < 10) continue;
            this.writeMutations(key, mutationList);
            mutationList.clear();
        }
        if (mutationList.size() <= 0) return;
        this.writeMutations(key, mutationList);
    }

    private void writeMutations(ByteBuffer key, List<Mutation> mutations) throws IOException {
        try {
            this.writer.write((Object)key, mutations);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void cleanupOnFailure(String failure, Job job) {
    }

    private void initSchema(String signature) {
        Properties properties = UDFContext.getUDFContext().getUDFProperties(CassandraStorage.class);
        if (!properties.containsKey(signature)) {
            try {
                Cassandra.Client client = ConfigHelper.getClientFromInputAddressList(this.conf);
                client.set_keyspace(this.keyspace);
                if (this.username != null && this.password != null) {
                    HashMap<String, String> credentials = new HashMap<String, String>(2);
                    credentials.put("username", this.username);
                    credentials.put("password", this.password);
                    try {
                        client.login(new AuthenticationRequest(credentials));
                    }
                    catch (AuthenticationException e) {
                        logger.error("Authentication exception: invalid username and/or password");
                        throw new RuntimeException(e);
                    }
                    catch (AuthorizationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                CfDef cfDef = null;
                KsDef ksDef = client.describe_keyspace(this.keyspace);
                List defs = ksDef.getCf_defs();
                for (CfDef def : defs) {
                    if (!this.column_family.equalsIgnoreCase(def.getName())) continue;
                    cfDef = def;
                    break;
                }
                if (cfDef == null) {
                    throw new RuntimeException(String.format("Column family '%s' not found in keyspace '%s'", this.column_family, this.keyspace));
                }
                properties.setProperty(signature, CassandraStorage.cfdefToString(cfDef));
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidRequestException e) {
                throw new RuntimeException(e);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String cfdefToString(CfDef cfDef) {
        assert (cfDef != null);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)cfDef));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private static CfDef cfdefFromString(String st) {
        assert (st != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        CfDef cfDef = new CfDef();
        try {
            deserializer.deserialize((TBase)cfDef, Hex.hexToBytes(st));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return cfDef;
    }

    private static String indexExpressionsToString(List<IndexExpression> indexExpressions) {
        assert (indexExpressions != null);
        IndexClause indexClause = new IndexClause();
        indexClause.setExpressions(indexExpressions);
        indexClause.setStart_key("".getBytes());
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return Hex.bytesToHex(serializer.serialize((TBase)indexClause));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<IndexExpression> indexExpressionsFromString(String ie) {
        assert (ie != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        IndexClause indexClause = new IndexClause();
        try {
            deserializer.deserialize((TBase)indexClause, Hex.hexToBytes(ie));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return indexClause.getExpressions();
    }

    private static enum MarshallerType {
        COMPARATOR,
        DEFAULT_VALIDATOR,
        KEY_VALIDATOR,
        SUBCOMPARATOR;

    }
}

