/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.CollationController;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    public static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor("MemtablePostFlusher");
    public final Table table;
    public final String columnFamily;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private volatile boolean valid = true;
    private final DataTracker data;
    private final AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    private static final int INTERN_CUTOFF = 256;
    public final ConcurrentMap<ByteBuffer, ByteBuffer> internedNames = new NonBlockingHashMap();
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private volatile AbstractCompactionStrategy compactionStrategy;
    public final Directories directories;
    volatile double liveRatio = 1.0;
    private final AtomicLong liveRatioComputedAt = new AtomicLong(32L);
    public final ColumnFamilyMetrics metric;

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        this.maybeReloadCompactionStrategy();
        this.indexManager.reload();
        if (this.getMemtableThreadSafe().initialComparator != this.metadata.comparator) {
            this.switchMemtable(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadCompactionStrategy() {
        if (this.metadata.compactionStrategyClass.equals(this.compactionStrategy.getClass()) && this.metadata.compactionStrategyOptions.equals(this.compactionStrategy.options)) {
            return;
        }
        CompactionManager.instance.getCompactionLock().lock();
        try {
            this.compactionStrategy.shutdown();
            this.compactionStrategy = this.metadata.createCompactionStrategyInstance(this);
        }
        finally {
            CompactionManager.instance.getCompactionLock().unlock();
        }
    }

    @Override
    public void setCompactionStrategyClass(String compactionStrategyClass) {
        try {
            this.metadata.compactionStrategyClass = CFMetaData.createCompactionStrategy(compactionStrategyClass);
            this.maybeReloadCompactionStrategy();
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String getCompactionStrategyClass() {
        return this.metadata.compactionStrategyClass.getName();
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata.compressionParameters().asThriftOptions();
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) {
        try {
            this.metadata.compressionParameters = CompressionParameters.create(opts);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setCrcCheckChance(double crcCheckChance) {
        try {
            for (SSTableReader sstable : this.table.getAllSSTables()) {
                if (!sstable.compression) continue;
                sstable.getCompressionMetadata().parameters.setCrcCheckChance(crcCheckChance);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private ColumnFamilyStore(Table table, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata, Directories directories, boolean loadSSTables) {
        assert (metadata != null) : "null metadata for " + table + ":" + columnFamilyName;
        this.table = table;
        this.columnFamily = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.partitioner = partitioner;
        this.directories = directories;
        this.indexManager = new SecondaryIndexManager(this);
        this.metric = new ColumnFamilyMetrics(this);
        this.fileIndexGenerator.set(generation);
        CFMetaData.Caching caching = metadata.getCaching();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting CFS {}", (Object)this.columnFamily);
        }
        this.data = new DataTracker(this);
        if (loadSSTables) {
            Directories.SSTableLister sstableFiles = directories.sstableLister().skipTemporary(true);
            Collection<SSTableReader> sstables = SSTableReader.batchOpen(sstableFiles.list().entrySet(), metadata, this.partitioner);
            if (metadata.getDefaultValidator().isCommutative()) {
                HashSet<Integer> compactedSSTables = new HashSet<Integer>();
                for (SSTableReader sstable : sstables) {
                    compactedSSTables.addAll(sstable.getAncestors());
                }
                HashSet<SSTableReader> liveSSTables = new HashSet<SSTableReader>();
                for (SSTableReader sstable : sstables) {
                    if (compactedSSTables.contains(sstable.descriptor.generation)) {
                        logger.info("{} is already compacted and will be removed.", (Object)sstable);
                        sstable.markCompacted();
                        sstable.releaseReference();
                        continue;
                    }
                    liveSSTables.add(sstable);
                }
                this.data.addInitialSSTables(liveSSTables);
            } else {
                this.data.addInitialSSTables(sstables);
            }
        }
        if (caching == CFMetaData.Caching.ALL || caching == CFMetaData.Caching.KEYS_ONLY) {
            CacheService.instance.keyCache.loadSaved(this);
        }
        this.compactionStrategy = metadata.createCompactionStrategyInstance(this);
        for (ColumnDefinition info : metadata.getColumn_metadata().values()) {
            if (info.getIndexType() == null) continue;
            this.indexManager.addIndexedColumn(info);
        }
        String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
        this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.table.name + ",columnfamily=" + this.columnFamily;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate() {
        try {
            this.valid = false;
            this.unregisterMBean();
            SystemTable.removeTruncationRecord(this.metadata.cfId);
            this.data.unreferenceSSTables();
            this.indexManager.invalidate();
        }
        catch (Exception e) {
            logger.warn("Failed unregistering mbean: " + this.mbeanName, (Throwable)e);
        }
    }

    void maybeRemoveUnreadableSSTables(File directory) {
        this.data.removeUnreadableSSTables(directory);
    }

    void unregisterMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName nameObj;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(nameObj = new ObjectName(this.mbeanName))) {
            mbs.unregisterMBean(nameObj);
        }
        this.metric.release();
    }

    @Override
    public long getMinRowSize() {
        return (Long)this.metric.minRowSize.value();
    }

    @Override
    public long getMaxRowSize() {
        return (Long)this.metric.maxRowSize.value();
    }

    @Override
    public long getMeanRowSize() {
        return (Long)this.metric.meanRowSize.value();
    }

    public int getMeanColumns() {
        return this.data.getMeanColumns();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, boolean loadSSTables) {
        return ColumnFamilyStore.createColumnFamilyStore(table, columnFamily, StorageService.getPartitioner(), Schema.instance.getCFMetaData(table.name, columnFamily), loadSSTables);
    }

    public static ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, IPartitioner partitioner, CFMetaData metadata) {
        return ColumnFamilyStore.createColumnFamilyStore(table, columnFamily, partitioner, metadata, true);
    }

    private static synchronized ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, IPartitioner partitioner, CFMetaData metadata, boolean loadSSTables) {
        Directories directories = Directories.create(table.name, columnFamily);
        Directories.SSTableLister lister = directories.sstableLister().includeBackups(true);
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            Descriptor desc = entry.getKey();
            generations.add(desc.generation);
            if (desc.isCompatible()) continue;
            throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", Descriptor.Version.CURRENT, desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(table, columnFamily, partitioner, value, metadata, directories, loadSSTables);
    }

    public static void scrubDataDirectories(String table, String columnFamily) {
        CFMetaData cfm;
        logger.debug("Removing compacted SSTable files from {} (see http://wiki.apache.org/cassandra/MemtableSSTable)", (Object)columnFamily);
        Directories directories = Directories.create(table, columnFamily);
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().list().entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            Set<Component> components = sstableFiles.getValue();
            if (components.contains(Component.COMPACTED_MARKER) || desc.temporary) {
                SSTable.delete(desc, components);
                continue;
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                FileUtils.deleteWithConfirm(desc.filenameFor(component));
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(table + "-" + columnFamily + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file.getName()).matches() || file.delete()) continue;
                logger.warn("could not delete " + file.getAbsolutePath());
            }
        }
        if ((cfm = Schema.instance.getCFMetaData(table, columnFamily)) != null) {
            for (ColumnDefinition def : cfm.getColumn_metadata().values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.indexColumnFamilyName(def));
            }
        }
    }

    public void initRowCache() {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        long start = System.currentTimeMillis();
        int cachedRowsRead = CacheService.instance.rowCache.loadSaved(this);
        if (cachedRowsRead > 0) {
            logger.info(String.format("completed loading (%d ms; %d keys) row cache for %s.%s", System.currentTimeMillis() - start, cachedRowsRead, this.table.name, this.columnFamily));
        }
    }

    public static synchronized void loadNewSSTables(String ksName, String cfName) {
        Table table = Table.open(ksName);
        table.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadNewSSTables() {
        logger.info("Loading new SSTables for " + this.table.name + "/" + this.columnFamily + "...");
        HashSet<Descriptor> currentDescriptors = new HashSet<Descriptor>();
        for (SSTableReader sstable : this.data.getView().sstables) {
            currentDescriptors.add(sstable.descriptor);
        }
        HashSet<SSTableReader> newSSTables = new HashSet<SSTableReader>();
        Directories.SSTableLister lister = this.directories.sstableLister().skipTemporary(true);
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            SSTableReader reader;
            Descriptor descriptor = entry.getKey();
            if (currentDescriptors.contains(descriptor) || descriptor.temporary) continue;
            if (!descriptor.isCompatible()) {
                throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", Descriptor.Version.CURRENT, descriptor));
            }
            Descriptor newDescriptor = new Descriptor(descriptor.version, descriptor.directory, descriptor.ksname, descriptor.cfname, this.fileIndexGenerator.incrementAndGet(), false);
            logger.info("Renaming new SSTable {} to {}", (Object)descriptor, (Object)newDescriptor);
            SSTableWriter.rename(descriptor, newDescriptor, entry.getValue());
            try {
                reader = SSTableReader.open(newDescriptor, entry.getValue(), this.metadata, this.partitioner);
            }
            catch (IOException e) {
                SSTableReader.logOpenException(entry.getKey(), e);
                continue;
            }
            newSSTables.add(reader);
        }
        if (newSSTables.isEmpty()) {
            logger.info("No new SSTables were found for " + this.table.name + "/" + this.columnFamily);
            return;
        }
        logger.info("Loading new SSTables and building secondary indexes for " + this.table.name + "/" + this.columnFamily + ": " + newSSTables);
        SSTableReader.acquireReferences(newSSTables);
        this.data.addSSTables(newSSTables);
        try {
            this.indexManager.maybeBuildSecondaryIndexes(newSSTables, this.indexManager.allIndexesNames());
        }
        finally {
            SSTableReader.releaseReferences(newSSTables);
        }
        logger.info("Done loading load new SSTables for " + this.table.name + "/" + this.columnFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Table.open(ksName).getColumnFamilyStore(cfName);
        HashSet<String> indexes = new HashSet<String>(Arrays.asList(idxNames));
        Collection<SSTableReader> sstables = cfs.getSSTables();
        try {
            cfs.indexManager.setIndexRemoved(indexes);
            SSTableReader.acquireReferences(sstables);
            logger.info(String.format("User Requested secondary index re-build for %s/%s indexes", ksName, cfName));
            cfs.indexManager.maybeBuildSecondaryIndexes(sstables, indexes);
            cfs.indexManager.setIndexBuilt(indexes);
        }
        finally {
            SSTableReader.releaseReferences(sstables);
        }
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily;
    }

    public String getTempSSTablePath(File directory) {
        return this.getTempSSTablePath(directory, Descriptor.Version.CURRENT);
    }

    private String getTempSSTablePath(File directory, Descriptor.Version version) {
        Descriptor desc = new Descriptor(version, directory, this.table.name, this.columnFamily, this.fileIndexGenerator.incrementAndGet(), true);
        return desc.filenameFor(Component.DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> switchMemtable(final boolean writeCommitLog, boolean forceSwitch) {
        Table.switchLock.writeLock().lock();
        try {
            ListenableFuture ctx = writeCommitLog ? CommitLog.instance.getContext() : Futures.immediateFuture((Object)ReplayPosition.NONE);
            final ArrayList<ColumnFamilyStore> icc = new ArrayList<ColumnFamilyStore>();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                if (!forceSwitch && cfs.getMemtableThreadSafe().isClean()) continue;
                icc.add(cfs);
            }
            final CountDownLatch latch = new CountDownLatch(icc.size());
            for (ColumnFamilyStore cfs : icc) {
                Memtable memtable = cfs.data.switchMemtable();
                if (memtable.isClean()) {
                    cfs.replaceFlushed(memtable, null);
                    latch.countDown();
                    continue;
                }
                logger.info("Enqueuing flush of {}", (Object)memtable);
                memtable.flushAndSignal(latch, (Future<ReplayPosition>)ctx);
            }
            if (this.metric.memtableSwitchCount.count() == Long.MAX_VALUE) {
                this.metric.memtableSwitchCount.clear();
            }
            this.metric.memtableSwitchCount.inc();
            Future<?> future = postFlushExecutor.submit(new WrappedRunnable((Future)ctx){
                final /* synthetic */ Future val$ctx;
                {
                    this.val$ctx = future;
                }

                @Override
                public void runMayThrow() throws InterruptedException, ExecutionException {
                    latch.await();
                    if (!icc.isEmpty()) {
                        for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexesNotBackedByCfs()) {
                            logger.info("Flushing SecondaryIndex {}", (Object)index);
                            index.forceBlockingFlush();
                        }
                    }
                    if (writeCommitLog) {
                        CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, (ReplayPosition)this.val$ctx.get());
                    }
                }
            });
            return future;
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
    }

    public Future<?> forceFlush() {
        boolean clean = true;
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            clean &= cfs.getMemtableThreadSafe().isClean();
        }
        if (clean) {
            return postFlushExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    logger.debug("forceFlush requested but everything is clean in {}", (Object)ColumnFamilyStore.this.columnFamily);
                }
            });
        }
        return this.switchMemtable(true, false);
    }

    public void forceBlockingFlush() throws ExecutionException, InterruptedException {
        this.forceFlush().get();
    }

    public void maybeUpdateRowCache(DecoratedKey key, ColumnFamily columnFamily) {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        RowCacheKey cacheKey = new RowCacheKey(this.metadata.cfId, key);
        if (CacheService.instance.rowCache.isPutCopying()) {
            this.invalidateCachedRow(cacheKey);
            return;
        }
        IRowCacheEntry cachedRow = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(cacheKey);
        if (cachedRow != null) {
            if (cachedRow instanceof RowCacheSentinel) {
                this.invalidateCachedRow(cacheKey);
            } else {
                ((ColumnFamily)cachedRow).addAllWithSCCopy(columnFamily, HeapAllocator.instance);
            }
        }
    }

    public void apply(DecoratedKey key, ColumnFamily columnFamily, SecondaryIndexManager.Updater indexer) {
        long start = System.nanoTime();
        Memtable mt = this.getMemtableThreadSafe();
        mt.put(key, columnFamily, indexer);
        this.maybeUpdateRowCache(key, columnFamily);
        this.metric.writeLatency.addNano(System.nanoTime() - start);
        while (true) {
            long last = this.liveRatioComputedAt.get();
            long operations = this.metric.writeLatency.latency.count();
            if (operations < 2L * last) break;
            if (!this.liveRatioComputedAt.compareAndSet(last, operations)) continue;
            logger.debug("computing liveRatio of {} at {} ops", (Object)this, (Object)operations);
            mt.updateLiveRatio();
        }
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        cf.maybeResetDeletionTimes(gcBefore);
        return cf.getColumnCount() == 0 && !cf.isMarkedForDelete() ? null : cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        return ColumnFamilyStore.removeDeleted(cf, gcBefore, SecondaryIndexManager.nullUpdater);
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        if (cf == null) {
            return null;
        }
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore, indexer);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private static void removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        if (cf.isSuper()) {
            ColumnFamilyStore.removeDeletedSuper(cf, gcBefore);
        } else {
            ColumnFamilyStore.removeDeletedStandard(cf, gcBefore, indexer);
        }
    }

    public static void removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore) {
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore, SecondaryIndexManager.nullUpdater);
    }

    private static void removeDeletedStandard(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            IColumn c = iter.next();
            if (c.getLocalDeletionTime() >= gcBefore && !cf.deletionInfo().isDeleted(c)) continue;
            iter.remove();
            indexer.remove(c);
        }
    }

    private static void removeDeletedSuper(ColumnFamily cf, int gcBefore) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            SuperColumn c = (SuperColumn)iter.next();
            Iterator<IColumn> subIter = c.getSubColumns().iterator();
            while (subIter.hasNext()) {
                IColumn subColumn = subIter.next();
                if (subColumn.getLocalDeletionTime() >= gcBefore && !cf.deletionInfo().isDeleted(c.name(), subColumn.timestamp()) && !c.deletionInfo().isDeleted(subColumn)) continue;
                subIter.remove();
            }
            c.maybeResetDeletionTimes(gcBefore);
            if (!c.getSubColumns().isEmpty() || c.isMarkedForDelete()) continue;
            iter.remove();
        }
    }

    public Set<SSTableReader> getOverlappingSSTables(Collection<SSTableReader> sstables) {
        logger.debug("Checking for sstables overlapping {}", sstables);
        if (sstables.isEmpty()) {
            return ImmutableSet.of();
        }
        DataTracker.SSTableIntervalTree tree = this.data.getView().intervalTree;
        Sets.SetView results = null;
        for (SSTableReader sstable : sstables) {
            ImmutableSet overlaps = ImmutableSet.copyOf(tree.search(Interval.create(sstable.first, sstable.last)));
            results = results == null ? overlaps : Sets.union((Set)results, (Set)overlaps).immutableCopy();
        }
        results = Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
        return results;
    }

    public Set<SSTableReader> getAndReferenceOverlappingSSTables(Collection<SSTableReader> sstables) {
        Set<SSTableReader> overlapped;
        while (!SSTableReader.acquireReferences(overlapped = this.getOverlappingSSTables(sstables))) {
        }
        return overlapped;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.columnFamily));
        this.addSSTables(Arrays.asList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        if (operation != OperationType.CLEANUP || this.isIndex()) {
            return SSTable.getTotalBytes(sstables);
        }
        long expectedFileSize = 0L;
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.table.name);
        for (SSTableReader sstable : sstables) {
            List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(ranges);
            for (Pair<Long, Long> position : positions) {
                expectedFileSize += (Long)position.right - (Long)position.left;
            }
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public void forceCleanup(CounterId.OneShotRenewer renewer) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performCleanup(this, renewer);
    }

    public void scrub() throws ExecutionException, InterruptedException {
        this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        CompactionManager.instance.performScrub(this);
    }

    public void sstablesRewrite(boolean excludeCurrentVersion) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performSSTableRewrite(this, excludeCurrentVersion);
    }

    public void markCompacted(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        this.data.markCompacted(sstables, compactionType);
    }

    public void replaceCompactedSSTables(Collection<SSTableReader> sstables, Iterable<SSTableReader> replacements, OperationType compactionType) {
        this.data.replaceCompactedSSTables(sstables, replacements, compactionType);
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.data.replaceFlushed(memtable, sstable);
        if (sstable != null) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long getMemtableColumnsCount() {
        return (Long)this.metric.memtableColumnsCount.value();
    }

    @Override
    public long getMemtableDataSize() {
        return (Long)this.metric.memtableDataSize.value();
    }

    public long getTotalMemtableLiveSize() {
        return this.getMemtableDataSize() + this.indexManager.getTotalLiveSize();
    }

    @Override
    public int getMemtableSwitchCount() {
        return (int)this.metric.memtableSwitchCount.count();
    }

    private Memtable getMemtableThreadSafe() {
        return this.data.getMemtable();
    }

    public DataTracker getDataTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    public Set<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompactingSSTables();
    }

    @Override
    public long[] getRecentSSTablesPerReadHistogram() {
        return this.metric.recentSSTablesPerRead.getBuckets(true);
    }

    @Override
    public long[] getSSTablesPerReadHistogram() {
        return this.metric.sstablesPerRead.getBuckets(false);
    }

    @Override
    public long getReadCount() {
        return this.metric.readLatency.latency.count();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.metric.readLatency.getRecentLatency();
    }

    @Override
    public long[] getLifetimeReadLatencyHistogramMicros() {
        return this.metric.readLatency.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return this.metric.readLatency.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.metric.readLatency.totalLatency.count();
    }

    @Override
    public int getPendingTasks() {
        return (Integer)this.metric.pendingTasks.value();
    }

    @Override
    public long getWriteCount() {
        return this.metric.writeLatency.latency.count();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.metric.writeLatency.totalLatency.count();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.metric.writeLatency.getRecentLatency();
    }

    @Override
    public long[] getLifetimeWriteLatencyHistogramMicros() {
        return this.metric.writeLatency.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return this.metric.writeLatency.recentLatencyHistogram.getBuckets(true);
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public int gcBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getThroughCache(UUID cfId, QueryFilter filter) {
        assert (this.isRowCacheEnabled()) : String.format("Row cache is not enabled on column family [" + this.getColumnFamilyName() + "]", new Object[0]);
        RowCacheKey key = new RowCacheKey(cfId, filter.key);
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                return this.getTopLevelColumns(filter, Integer.MIN_VALUE, false);
            }
            Tracing.trace("Row cache hit");
            return (ColumnFamily)cached;
        }
        Tracing.trace("Row cache miss");
        RowCacheSentinel sentinel = new RowCacheSentinel();
        boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
        try {
            ColumnFamily data = this.getTopLevelColumns(QueryFilter.getIdentityFilter(filter.key, new QueryPath(this.columnFamily)), Integer.MIN_VALUE, true);
            if (sentinelSuccess && data != null) {
                CacheService.instance.rowCache.replace(key, sentinel, data);
            }
            ColumnFamily columnFamily = data;
            return columnFamily;
        }
        finally {
            if (sentinelSuccess && this.data == null) {
                CacheService.instance.rowCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) {
        assert (this.columnFamily.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        ColumnFamily result = null;
        long start = System.nanoTime();
        try {
            if (this.isRowCacheEnabled()) {
                UUID cfId = Schema.instance.getId(this.table.name, this.columnFamily);
                if (cfId == null) {
                    logger.trace("no id found for {}.{}", (Object)this.table.name, (Object)this.columnFamily);
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                ColumnFamily cached = this.getThroughCache(cfId, filter);
                if (cached == null) {
                    logger.trace("cached row is empty");
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = this.filterColumnFamily(cached, filter, gcBefore);
            } else {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore, false);
                if (cf == null) {
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
            }
        }
        finally {
            this.metric.readLatency.addNano(System.nanoTime() - start);
        }
        return result;
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter, int gcBefore) {
        ColumnFamily cf = cached.cloneMeShallow(ArrayBackedSortedColumns.factory(), filter.filter.isReversed());
        OnDiskAtomIterator ci = filter.getMemtableColumnIterator(cached, null);
        filter.collateOnDiskAtom(cf, Collections.singletonList(ci), gcBefore);
        return cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private DataTracker.View markCurrentViewReferenced() {
        DataTracker.View currentView;
        do {
            currentView = this.data.getView();
        } while (!SSTableReader.acquireReferences(currentView.sstables));
        return currentView;
    }

    public Collection<SSTableReader> markCurrentSSTablesReferenced() {
        return this.markCurrentViewReferenced().sstables;
    }

    private ViewFragment markReferenced(AbstractViewSSTableFinder finder) {
        DataTracker.View view;
        List<SSTableReader> sstables;
        do {
            view = this.data.getView();
            if (!view.intervalTree.isEmpty()) continue;
            sstables = Collections.emptyList();
            break;
        } while (!SSTableReader.acquireReferences(sstables = finder.findSSTables(view)));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    public ViewFragment markReferenced(final DecoratedKey key) {
        assert (!key.isMinimum());
        return this.markReferenced(new AbstractViewSSTableFinder(){

            @Override
            List<SSTableReader> findSSTables(DataTracker.View view) {
                return view.intervalTree.search(key);
            }
        });
    }

    public ViewFragment markReferenced(final AbstractBounds<RowPosition> rowBounds) {
        return this.markReferenced(new AbstractViewSSTableFinder(){

            @Override
            List<SSTableReader> findSSTables(DataTracker.View view) {
                return this.sstablesForRowBounds(rowBounds, view);
            }
        });
    }

    public ViewFragment markReferenced(final Collection<AbstractBounds<RowPosition>> rowBoundsCollection) {
        return this.markReferenced(new AbstractViewSSTableFinder(){

            @Override
            List<SSTableReader> findSSTables(DataTracker.View view) {
                HashSet sstables = Sets.newHashSet();
                for (AbstractBounds rowBounds : rowBoundsCollection) {
                    sstables.addAll(this.sstablesForRowBounds(rowBounds, view));
                }
                return ImmutableList.copyOf((Collection)sstables);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSSTablesForKey(String key) {
        DecoratedKey dk = new DecoratedKey((Token)this.partitioner.getToken(ByteBuffer.wrap(key.getBytes())), ByteBuffer.wrap(key.getBytes()));
        ViewFragment view = this.markReferenced(dk);
        try {
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : view.sstables) {
                if (sstr.getPosition(dk, SSTableReader.Operator.EQ, false) == null) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
        finally {
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore, boolean forCache) {
        Tracing.trace("Executing single-partition query on {}", this.columnFamily);
        CollationController controller = new CollationController(this, forCache && !CacheService.instance.rowCache.isPutCopying(), filter, gcBefore);
        ColumnFamily columns = controller.getTopLevelColumns();
        this.metric.updateSSTableIterated(controller.getSstablesIterated());
        return columns;
    }

    public AbstractScanIterator getSequentialIterator(ByteBuffer superColumn, final AbstractBounds<RowPosition> range, IDiskAtomFilter columnFilter) {
        assert (!(range instanceof Range) || !((Range)range).isWrapAround() || ((RowPosition)range.right).isMinimum()) : range;
        RowPosition startWith = (RowPosition)range.left;
        final RowPosition stopAt = (RowPosition)range.right;
        QueryFilter filter = new QueryFilter(null, new QueryPath(this.columnFamily, superColumn, null), columnFilter);
        final ViewFragment view = this.markReferenced(range);
        Tracing.trace("Executing seq scan across {} sstables for {}", view.sstables.size(), range.getString(this.metadata.getKeyValidator()));
        try {
            final CloseableIterator<Row> iterator = RowIteratorFactory.getIterator(view.memtables, view.sstables, startWith, stopAt, filter, this);
            final int gcBefore = (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
            return new AbstractScanIterator(){

                protected Row computeNext() {
                    if (!iterator.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    Row current = (Row)iterator.next();
                    DecoratedKey key = current.key;
                    if (!stopAt.isMinimum() && stopAt.compareTo(key) < 0) {
                        return (Row)this.endOfData();
                    }
                    if (!range.contains(key)) {
                        return this.computeNext();
                    }
                    logger.trace("scanned {}", (Object)key);
                    return current.cf != null && current.cf.isSuper() ? new Row(current.key, ColumnFamilyStore.removeDeleted(current.cf, gcBefore)) : current;
                }

                @Override
                public void close() throws IOException {
                    SSTableReader.releaseReferences(view.sstables);
                    iterator.close();
                }
            };
        }
        catch (RuntimeException e) {
            SSTableReader.releaseReferences(view.sstables);
            throw e;
        }
    }

    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds<RowPosition> range, int maxResults, IDiskAtomFilter columnFilter, List<IndexExpression> rowFilter) {
        return this.getRangeSlice(superColumn, range, maxResults, columnFilter, rowFilter, false, false);
    }

    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds<RowPosition> range, int maxResults, IDiskAtomFilter columnFilter, List<IndexExpression> rowFilter, boolean countCQL3Rows, boolean isPaging) {
        return this.filter(this.getSequentialIterator(superColumn, range, columnFilter), ExtendedFilter.create(this, columnFilter, rowFilter, maxResults, countCQL3Rows, isPaging));
    }

    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IDiskAtomFilter dataFilter) {
        return this.search(clause, range, maxResults, dataFilter, false);
    }

    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IDiskAtomFilter dataFilter, boolean countCQL3Rows) {
        Tracing.trace("Executing indexed scan for {}", range.getString(this.metadata.getKeyValidator()));
        return this.indexManager.search(clause, range, maxResults, dataFilter, countCQL3Rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> filter(AbstractScanIterator rowIterator, ExtendedFilter filter) {
        logger.trace("Filtering {} for rows matching {}", (Object)rowIterator, (Object)filter);
        ArrayList<Row> rows = new ArrayList<Row>();
        int columnsCount = 0;
        int total = 0;
        int matched = 0;
        try {
            while (rowIterator.hasNext() && rows.size() < filter.maxRows() && columnsCount < filter.maxColumns()) {
                Row rawRow = (Row)rowIterator.next();
                ++total;
                ColumnFamily data = rawRow.cf;
                if (rowIterator.needsFiltering()) {
                    QueryPath path;
                    ColumnFamily cf;
                    IDiskAtomFilter extraFilter = filter.getExtraFilter(data);
                    if (extraFilter != null && (cf = filter.cfs.getColumnFamily(new QueryFilter(rawRow.key, path = new QueryPath(this.columnFamily), extraFilter))) != null) {
                        data.addAll(cf, HeapAllocator.instance);
                    }
                    if (!filter.isSatisfiedBy(data, null)) continue;
                    logger.trace("{} satisfies all filter expressions", (Object)data);
                    data = filter.prune(data);
                }
                rows.add(new Row(rawRow.key, data));
                ++matched;
                if (data != null) {
                    columnsCount += filter.lastCounted(data);
                }
                filter.updateFilter(columnsCount);
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        finally {
            try {
                rowIterator.close();
                Tracing.trace("Scanned {} rows and matched {}", total, matched);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public AbstractType<?> getComparator() {
        return this.metadata.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotWithoutFlush(String snapshotName) {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            DataTracker.View currentView = cfs.markCurrentViewReferenced();
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.getPath());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Snapshot for " + this.table + " keyspace data file " + ssTable.getFilename() + " created in " + snapshotDirectory);
                }
                if (!(cfs.compactionStrategy instanceof LeveledCompactionStrategy)) continue;
                cfs.directories.snapshotLeveledManifest(snapshotName);
            }
            finally {
                SSTableReader.releaseReferences(currentView.sstables);
            }
        }
    }

    public List<SSTableReader> getSnapshotSSTableReader(String tag) throws IOException {
        Map<Descriptor, Set<Component>> snapshots = this.directories.sstableLister().snapshots(tag).list();
        ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>(snapshots.size());
        for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
            readers.add(SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, this.partitioner));
        }
        return readers;
    }

    public void snapshot(String snapshotName) {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.snapshotWithoutFlush(snapshotName);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.directories.snapshotExists(snapshotName);
    }

    public long getSnapshotCreationTime(String snapshotName) {
        return this.directories.snapshotCreationTime(snapshotName);
    }

    public void clearSnapshot(String snapshotName) {
        this.directories.clearSnapshot(snapshotName);
    }

    public boolean hasUnreclaimedSpace() {
        return this.getLiveDiskSpaceUsed() < this.getTotalDiskSpaceUsed();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.metric.totalDiskSpaceUsed.count();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.metric.liveDiskSpaceUsed.count();
    }

    @Override
    public int getLiveSSTableCount() {
        return (Integer)this.metric.liveSSTableCount.value();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        if (!this.isRowCacheEnabled() || this.metadata.cfId == null) {
            return null;
        }
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(new RowCacheKey(this.metadata.cfId, key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (ColumnFamily)cached;
    }

    public boolean containsCachedRow(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey(this.metadata.cfId, key));
    }

    public void invalidateCachedRow(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        UUID cfId = Schema.instance.getId(this.table.name, this.columnFamily);
        if (cfId == null) {
            return;
        }
        this.invalidateCachedRow(new RowCacheKey(cfId, key));
    }

    @Override
    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getTables().size());
        for (Table table : Table.all()) {
            stores.add(table.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public static List<ColumnFamilyStore> allUserDefined() {
        ArrayList<ColumnFamilyStore> cfses = new ArrayList<ColumnFamilyStore>();
        for (Table table : Sets.difference((Set)ImmutableSet.copyOf(Table.all()), Schema.systemKeyspaceNames)) {
            cfses.addAll(table.getColumnFamilyStores());
        }
        return cfses;
    }

    public Iterable<DecoratedKey> keySamples(Range<Token> range) {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples(range);
        }
        return Iterables.concat((Iterable[])samples);
    }

    public void clearUnsafe() {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.data.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> truncate() throws ExecutionException, InterruptedException {
        logger.debug("truncating {}", (Object)this.columnFamily);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.forceBlockingFlush();
            try {
                long starttime = System.currentTimeMillis();
                while (System.currentTimeMillis() - starttime < 1L) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        Table.switchLock.writeLock().lock();
        try {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                Memtable mt = cfs.getMemtableThreadSafe();
                if (mt.isClean()) continue;
                mt.cfs.data.renewMemtable();
            }
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
        long truncatedAt = System.currentTimeMillis();
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.snapshot(Table.getTimestampedSnapshotName(this.columnFamily));
        }
        return CompactionManager.instance.submitTruncate(this, truncatedAt);
    }

    @Override
    public long getBloomFilterFalsePositives() {
        return (Long)this.metric.bloomFilterFalsePositives.value();
    }

    @Override
    public long getRecentBloomFilterFalsePositives() {
        return (Long)this.metric.recentBloomFilterFalsePositives.value();
    }

    @Override
    public double getBloomFilterFalseRatio() {
        return (Double)this.metric.bloomFilterFalseRatio.value();
    }

    @Override
    public double getRecentBloomFilterFalseRatio() {
        return (Double)this.metric.recentBloomFilterFalseRatio.value();
    }

    @Override
    public long getBloomFilterDiskSpaceUsed() {
        return (Long)this.metric.bloomFilterDiskSpaceUsed.value();
    }

    public String toString() {
        return "CFS(Keyspace='" + this.table.name + '\'' + ", ColumnFamily='" + this.columnFamily + '\'' + ')';
    }

    @Override
    public void disableAutoCompaction() {
        this.minCompactionThreshold.set(0);
        this.maxCompactionThreshold.set(0);
    }

    public void enableAutoCompaction() {
        this.minCompactionThreshold.reset();
        this.maxCompactionThreshold.reset();
    }

    public AbstractCompactionStrategy getCompactionStrategy() {
        return this.compactionStrategy;
    }

    @Override
    public void setCompactionThresholds(int minThreshold, int maxThreshold) {
        this.validateCompactionThresholds(minThreshold, maxThreshold);
        this.minCompactionThreshold.set(minThreshold);
        this.maxCompactionThreshold.set(maxThreshold);
        if (this.compactionStrategy != null) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        this.validateCompactionThresholds(minCompactionThreshold, this.maxCompactionThreshold.value());
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        this.validateCompactionThresholds(this.minCompactionThreshold.value(), maxCompactionThreshold);
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    private void validateCompactionThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold > maxThreshold && maxThreshold != 0) {
            throw new RuntimeException(String.format("The min_compaction_threshold cannot be larger than the max_compaction_threshold. Min is '%d', Max is '%d'.", minThreshold, maxThreshold));
        }
    }

    public boolean isCompactionDisabled() {
        return this.getMinimumCompactionThreshold() <= 0 || this.getMaximumCompactionThreshold() <= 0;
    }

    @Override
    public long estimateKeys() {
        return this.data.estimatedKeys();
    }

    @Override
    public long[] getEstimatedRowSizeHistogram() {
        return (long[])this.metric.estimatedRowSizeHistogram.value();
    }

    @Override
    public long[] getEstimatedColumnCountHistogram() {
        return (long[])this.metric.estimatedColumnCountHistogram.value();
    }

    @Override
    public double getCompressionRatio() {
        return (Double)this.metric.compressionRatio.value();
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    private ByteBuffer intern(ByteBuffer name) {
        ByteBuffer concurrentName;
        ByteBuffer internedName = (ByteBuffer)this.internedNames.get(name);
        if (internedName == null && (concurrentName = this.internedNames.putIfAbsent(internedName = ByteBufferUtil.clone(name), internedName)) != null) {
            internedName = concurrentName;
        }
        return internedName;
    }

    public ByteBuffer internOrCopy(ByteBuffer name, Allocator allocator) {
        if (this.internedNames.size() >= 256) {
            return allocator.clone(name);
        }
        return this.intern(name);
    }

    public ByteBuffer maybeIntern(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return null;
        }
        return this.intern(name);
    }

    public SSTableWriter createCompactionWriter(long estimatedRows, File location, Collection<SSTableReader> sstables) {
        ReplayPosition rp = ReplayPosition.getReplayPosition(sstables);
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector().replayPosition(rp);
        for (SSTableReader sstable : sstables) {
            sstableMetadataCollector.addAncestor(sstable.descriptor.generation);
            for (Integer i : sstable.getAncestors()) {
                if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                sstableMetadataCollector.addAncestor(i);
            }
        }
        return new SSTableWriter(this.getTempSSTablePath(location), estimatedRows, this.metadata, this.partitioner, sstableMetadataCollector);
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(this.indexManager.getIndexesBackedByCfs(), Collections.singleton(this));
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.data.getMemtablesPendingFlush();
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexes();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getLevelSize(0) : 0;
    }

    @Override
    public int[] getSSTableCountPerLevel() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getAllLevelSize() : null;
    }

    public long oldestUnflushedMemtable() {
        DataTracker.View view = this.data.getView();
        long oldest = view.memtable.creationTime();
        for (Memtable memtable : view.memtablesPendingFlush) {
            oldest = Math.min(oldest, memtable.creationTime());
        }
        return oldest;
    }

    public boolean isEmpty() {
        DataTracker.View view = this.data.getView();
        return view.sstables.isEmpty() && view.memtable.getOperations() == 0L && view.memtablesPendingFlush.isEmpty();
    }

    private boolean isRowCacheEnabled() {
        return this.metadata.getCaching() != CFMetaData.Caching.NONE && this.metadata.getCaching() != CFMetaData.Caching.KEYS_ONLY && CacheService.instance.rowCache.getCapacity() != 0L;
    }

    public ReplayPosition discardSSTables(long truncatedAt) {
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables()) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (truncatedSSTables.isEmpty()) {
            return ReplayPosition.NONE;
        }
        this.markCompacted(truncatedSSTables, OperationType.UNKNOWN);
        return ReplayPosition.getReplayPosition(truncatedSSTables);
    }

    @Override
    public double getDroppableTombstoneRatio() {
        return this.getDataTracker().getDroppableTombstoneRatio();
    }

    public long getTruncationTime() {
        Pair<ReplayPosition, Long> truncationRecord = SystemTable.getTruncationRecords().get(this.metadata.cfId);
        return truncationRecord == null ? Long.MIN_VALUE : (Long)truncationRecord.right;
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static abstract class AbstractScanIterator
    extends AbstractIterator<Row>
    implements CloseableIterator<Row> {
        public boolean needsFiltering() {
            return true;
        }
    }

    abstract class AbstractViewSSTableFinder {
        AbstractViewSSTableFinder() {
        }

        abstract List<SSTableReader> findSSTables(DataTracker.View var1);

        protected List<SSTableReader> sstablesForRowBounds(AbstractBounds<RowPosition> rowBounds, DataTracker.View view) {
            RowPosition stopInTree = ((RowPosition)rowBounds.right).isMinimum() ? (RowPosition)view.intervalTree.max() : (RowPosition)rowBounds.right;
            return view.intervalTree.search(Interval.create(rowBounds.left, stopInTree));
        }
    }
}

