/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerChecker {
    private static Logger LOG = LoggerFactory.getLogger(LedgerChecker.class);
    public final BookieClient bookieClient;

    public LedgerChecker(BookKeeper bkc) {
        this.bookieClient = bkc.getBookieClient();
    }

    private void verifyLedgerFragment(LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) throws InvalidFragmentException {
        long firstStored = fragment.getFirstStoredEntryId();
        long lastStored = fragment.getLastStoredEntryId();
        if (firstStored == -1L) {
            if (lastStored != -1L) {
                throw new InvalidFragmentException();
            }
            cb.operationComplete(0, fragment);
            return;
        }
        if (firstStored == lastStored) {
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(1L, fragment, cb);
            this.bookieClient.readEntry(fragment.getAddress(), fragment.getLedgerId(), firstStored, manycb, null);
        } else {
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(2L, fragment, cb);
            this.bookieClient.readEntry(fragment.getAddress(), fragment.getLedgerId(), firstStored, manycb, null);
            this.bookieClient.readEntry(fragment.getAddress(), fragment.getLedgerId(), lastStored, manycb, null);
        }
    }

    public void checkLedger(LedgerHandle lh, final BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
        final HashSet<LedgerFragment> fragments = new HashSet<LedgerFragment>();
        Long curEntryId = null;
        ArrayList<InetSocketAddress> curEnsemble = null;
        for (Map.Entry<Long, ArrayList<InetSocketAddress>> e : lh.getLedgerMetadata().getEnsembles().entrySet()) {
            if (curEntryId != null) {
                for (int i = 0; i < curEnsemble.size(); ++i) {
                    fragments.add(new LedgerFragment(lh, curEntryId, e.getKey() - 1L, i));
                }
            }
            curEntryId = e.getKey();
            curEnsemble = e.getValue();
        }
        if (!(curEntryId == null || lh.getLedgerMetadata().isClosed() && lh.getLastAddConfirmed() < curEntryId)) {
            long lastEntry = lh.getLastAddConfirmed();
            if (lastEntry < curEntryId) {
                lastEntry = curEntryId;
            }
            final HashSet<LedgerFragment> finalSegmentFragments = new HashSet<LedgerFragment>();
            for (int i = 0; i < curEnsemble.size(); ++i) {
                finalSegmentFragments.add(new LedgerFragment(lh, curEntryId, lastEntry, i));
            }
            if (curEntryId == lastEntry) {
                long entryToRead = curEntryId;
                EntryExistsCallback eecb = new EntryExistsCallback(lh.getLedgerMetadata().getWriteQuorumSize(), new BookkeeperInternalCallbacks.GenericCallback<Boolean>(){

                    @Override
                    public void operationComplete(int rc, Boolean result) {
                        if (result.booleanValue()) {
                            fragments.addAll(finalSegmentFragments);
                        }
                        LedgerChecker.this.checkFragments(fragments, cb);
                    }
                });
                for (int bi : lh.getDistributionSchedule().getWriteSet(entryToRead)) {
                    InetSocketAddress addr = curEnsemble.get(bi);
                    this.bookieClient.readEntry(addr, lh.getId(), entryToRead, eecb, null);
                }
                return;
            }
            fragments.addAll(finalSegmentFragments);
        }
        this.checkFragments(fragments, cb);
    }

    private void checkFragments(Set<LedgerFragment> fragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
        if (fragments.size() == 0) {
            cb.operationComplete(0, fragments);
            return;
        }
        FullLedgerCallback allFragmentsCb = new FullLedgerCallback(fragments.size(), cb);
        for (LedgerFragment r : fragments) {
            LOG.debug("Checking fragment {}", (Object)r);
            try {
                this.verifyLedgerFragment(r, allFragmentsCb);
            }
            catch (InvalidFragmentException ife) {
                LOG.error("Invalid fragment found : {}", (Object)r);
                allFragmentsCb.operationComplete(-14, r);
            }
        }
    }

    private static class FullLedgerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> {
        final Set<LedgerFragment> badFragments = new HashSet<LedgerFragment>();
        final AtomicLong numFragments;
        final BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb;

        FullLedgerCallback(long numFragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
            this.numFragments = new AtomicLong(numFragments);
            this.cb = cb;
        }

        @Override
        public void operationComplete(int rc, LedgerFragment result) {
            if (rc != 0) {
                this.badFragments.add(result);
            }
            if (this.numFragments.decrementAndGet() == 0L) {
                this.cb.operationComplete(0, this.badFragments);
            }
        }
    }

    private static class EntryExistsCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean entryMayExist = new AtomicBoolean(false);
        final AtomicInteger numReads;
        final BookkeeperInternalCallbacks.GenericCallback<Boolean> cb;

        EntryExistsCallback(int numReads, BookkeeperInternalCallbacks.GenericCallback<Boolean> cb) {
            this.numReads = new AtomicInteger(numReads);
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ChannelBuffer buffer, Object ctx) {
            if (rc != -13) {
                this.entryMayExist.set(true);
            }
            if (this.numReads.decrementAndGet() == 0) {
                this.cb.operationComplete(rc, this.entryMayExist.get());
            }
        }
    }

    private static class ReadManyEntriesCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean completed = new AtomicBoolean(false);
        final AtomicLong numEntries;
        final LedgerFragment fragment;
        final BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb;

        ReadManyEntriesCallback(long numEntries, LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) {
            this.numEntries = new AtomicLong(numEntries);
            this.fragment = fragment;
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ChannelBuffer buffer, Object ctx) {
            if (rc == 0) {
                if (this.numEntries.decrementAndGet() == 0L && !this.completed.getAndSet(true)) {
                    this.cb.operationComplete(rc, this.fragment);
                }
            } else if (!this.completed.getAndSet(true)) {
                this.cb.operationComplete(rc, this.fragment);
            }
        }
    }

    static class InvalidFragmentException
    extends Exception {
        private static final long serialVersionUID = 1467201276417062353L;

        InvalidFragmentException() {
        }
    }
}

