/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInfo {
    static Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    static final int NO_MASTER_KEY = -1;
    static final int STATE_FENCED_BIT = 1;
    private FileChannel fc;
    private File lf;
    byte[] masterKey;
    public static final int signature = ByteBuffer.wrap("BKLE".getBytes()).getInt();
    public static final int headerVersion = 0;
    static final long START_OF_DATA = 1024L;
    private long size;
    private int useCount;
    private boolean isClosed;
    private long sizeSinceLastwrite;
    private int stateBits;
    private boolean needFlushHeader = false;
    protected String mode;

    public FileInfo(File lf, byte[] masterKey) throws IOException {
        this.lf = lf;
        this.masterKey = masterKey;
        this.mode = "rw";
    }

    public File getLf() {
        return this.lf;
    }

    public long getSizeSinceLastwrite() {
        return this.sizeSinceLastwrite;
    }

    public synchronized void readHeader() throws IOException {
        int length;
        ByteBuffer bb;
        if (this.lf.exists()) {
            if (this.fc != null) {
                return;
            }
            this.fc = new RandomAccessFile(this.lf, this.mode).getChannel();
            this.sizeSinceLastwrite = this.size = this.fc.size();
            bb = ByteBuffer.allocate((int)Math.min(this.size, 1024L));
            while (bb.hasRemaining()) {
                this.fc.read(bb);
            }
            bb.flip();
            if (bb.getInt() != signature) {
                throw new IOException("Missing ledger signature");
            }
            int version = bb.getInt();
            if (version != 0) {
                throw new IOException("Incompatible ledger version " + version);
            }
            length = bb.getInt();
            if (length < 0) {
                throw new IOException("Length " + length + " is invalid");
            }
            if (length > bb.remaining()) {
                throw new BufferUnderflowException();
            }
        } else {
            throw new IOException("Ledger index file does not exist");
        }
        this.masterKey = new byte[length];
        bb.get(this.masterKey);
        this.stateBits = bb.getInt();
        this.needFlushHeader = false;
    }

    private synchronized void checkOpen(boolean create) throws IOException {
        if (this.fc != null) {
            return;
        }
        boolean exists = this.lf.exists();
        if (this.masterKey == null && !exists) {
            throw new IOException(this.lf + " not found");
        }
        if (!exists) {
            if (create) {
                FileInfo.checkParents(this.lf);
                this.fc = new RandomAccessFile(this.lf, this.mode).getChannel();
                this.size = this.fc.size();
                if (this.size == 0L) {
                    this.writeHeader();
                }
            }
        } else {
            try {
                this.readHeader();
            }
            catch (BufferUnderflowException buf) {
                LOG.warn("Exception when reading header of {} : {}", (Object)this.lf, (Object)buf);
                if (null != this.masterKey) {
                    LOG.warn("Attempting to write header of {} again.", (Object)this.lf);
                    this.writeHeader();
                }
                throw new IOException("Error reading header " + this.lf);
            }
        }
    }

    private void writeHeader() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        bb.putInt(signature);
        bb.putInt(0);
        bb.putInt(this.masterKey.length);
        bb.put(this.masterKey);
        bb.putInt(this.stateBits);
        bb.rewind();
        this.fc.position(0L);
        this.fc.write(bb);
    }

    public synchronized boolean isFenced() throws IOException {
        this.checkOpen(false);
        return (this.stateBits & 1) == 1;
    }

    public synchronized boolean setFenced() throws IOException {
        this.checkOpen(false);
        LOG.debug("Try to set fenced state in file info {} : state bits {}.", (Object)this.lf, (Object)this.stateBits);
        if ((this.stateBits & 1) != 1) {
            this.stateBits |= 1;
            this.needFlushHeader = true;
            return true;
        }
        return false;
    }

    public synchronized void flushHeader() throws IOException {
        if (this.needFlushHeader) {
            this.checkOpen(true);
            this.writeHeader();
            this.needFlushHeader = false;
        }
    }

    public synchronized long size() throws IOException {
        this.checkOpen(false);
        long rc = this.size - 1024L;
        if (rc < 0L) {
            rc = 0L;
        }
        return rc;
    }

    public synchronized int read(ByteBuffer bb, long position) throws IOException {
        return this.readAbsolute(bb, position + 1024L);
    }

    private int readAbsolute(ByteBuffer bb, long start) throws IOException {
        this.checkOpen(false);
        if (this.fc == null) {
            return 0;
        }
        int total = 0;
        while (bb.remaining() > 0) {
            int rc = this.fc.read(bb, start);
            if (rc <= 0) {
                throw new IOException("Short read");
            }
            total += rc;
            start += (long)rc;
        }
        return total;
    }

    public synchronized void close(boolean force) throws IOException {
        this.isClosed = true;
        this.checkOpen(force);
        if (this.useCount == 0 && this.fc != null) {
            this.fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long write(ByteBuffer[] buffs, long position) throws IOException {
        this.checkOpen(true);
        long total = 0L;
        try {
            this.fc.position(position + 1024L);
            while (buffs[buffs.length - 1].remaining() > 0) {
                long rc = this.fc.write(buffs);
                if (rc <= 0L) {
                    throw new IOException("Short write");
                }
                total += rc;
            }
        }
        finally {
            this.fc.force(true);
            long newsize = position + 1024L + total;
            if (newsize > this.size) {
                this.size = newsize;
            }
        }
        this.sizeSinceLastwrite = this.fc.size();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToNewLocation(File newFile, long size) throws IOException {
        this.checkOpen(false);
        if (this.fc != null) {
            File rlocFile;
            if (size > this.fc.size()) {
                size = this.fc.size();
            }
            if (!(rlocFile = new File(newFile.getParentFile(), newFile.getName() + ".rloc")).exists()) {
                FileInfo.checkParents(rlocFile);
                if (!rlocFile.createNewFile()) {
                    throw new IOException("Creating new cache index file " + rlocFile + " failed ");
                }
            }
            FileChannel newFc = new RandomAccessFile(rlocFile, "rw").getChannel();
            try {
                long written;
                long count;
                for (written = 0L; written < size; written += count) {
                    count = this.fc.transferTo(written, size, newFc);
                    if (count > 0L) continue;
                    throw new IOException("Copying to new location " + rlocFile + " failed");
                }
                if (written <= 0L && size > 0L) {
                    throw new IOException("Copying to new location " + rlocFile + " failed");
                }
            }
            finally {
                newFc.force(true);
                newFc.close();
            }
            this.fc.close();
            if (!this.delete()) {
                LOG.error("Failed to delete the previous index file " + this.lf);
                throw new IOException("Failed to delete the previous index file " + this.lf);
            }
            if (!rlocFile.renameTo(newFile)) {
                LOG.error("Failed to rename " + rlocFile + " to " + newFile);
                throw new IOException("Failed to rename " + rlocFile + " to " + newFile);
            }
            this.fc = new RandomAccessFile(newFile, this.mode).getChannel();
        }
        this.lf = newFile;
    }

    public synchronized byte[] getMasterKey() throws IOException {
        this.checkOpen(false);
        return this.masterKey;
    }

    public synchronized void use() {
        ++this.useCount;
    }

    @VisibleForTesting
    synchronized int getUseCount() {
        return this.useCount;
    }

    public synchronized void release() {
        --this.useCount;
        if (this.isClosed && this.useCount == 0 && this.fc != null) {
            try {
                this.fc.close();
            }
            catch (IOException e) {
                LOG.error("Error closing file channel", (Throwable)e);
            }
        }
    }

    public boolean delete() {
        return this.lf.delete();
    }

    private static final void checkParents(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent.exists()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Counldn't mkdirs for " + parent);
        }
    }
}

