/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.base.Charsets;
import bk-shade.com.google.common.util.concurrent.AbstractFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerCacheImpl;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.bookie.ReadOnlyEntryLogger;
import org.apache.bookkeeper.bookie.ReadOnlyFileInfo;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.Tool;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieShell
implements Tool {
    static final Logger LOG = LoggerFactory.getLogger(BookieShell.class);
    static final String ENTRY_FORMATTER_CLASS = "entryFormatterClass";
    static final String CMD_METAFORMAT = "metaformat";
    static final String CMD_BOOKIEFORMAT = "bookieformat";
    static final String CMD_RECOVER = "recover";
    static final String CMD_LEDGER = "ledger";
    static final String CMD_LISTLEDGERS = "listledgers";
    static final String CMD_LEDGERMETADATA = "ledgermetadata";
    static final String CMD_LISTUNDERREPLICATED = "listunderreplicated";
    static final String CMD_WHOISAUDITOR = "whoisauditor";
    static final String CMD_SIMPLETEST = "simpletest";
    static final String CMD_READLOG = "readlog";
    static final String CMD_READJOURNAL = "readjournal";
    static final String CMD_LASTMARK = "lastmark";
    static final String CMD_AUTORECOVERY = "autorecovery";
    static final String CMD_HELP = "help";
    final ServerConfiguration bkConf = new ServerConfiguration();
    File[] ledgerDirectories;
    File journalDirectory;
    EntryLogger entryLogger = null;
    Journal journal = null;
    EntryFormatter formatter;
    int pageSize;
    int entriesPerPage;
    static final int LIST_BATCH_SIZE = 1000;
    final Map<String, MyCommand> commands = new HashMap<String, MyCommand>();

    public BookieShell() {
        this.commands.put(CMD_METAFORMAT, new MetaFormatCmd());
        this.commands.put(CMD_BOOKIEFORMAT, new BookieFormatCmd());
        this.commands.put(CMD_RECOVER, new RecoverCmd());
        this.commands.put(CMD_LEDGER, new LedgerCmd());
        this.commands.put(CMD_LISTLEDGERS, new ListLedgersCmd());
        this.commands.put(CMD_LISTUNDERREPLICATED, new ListUnderreplicatedCmd());
        this.commands.put(CMD_WHOISAUDITOR, new WhoIsAuditorCmd());
        this.commands.put(CMD_LEDGERMETADATA, new LedgerMetadataCmd());
        this.commands.put(CMD_SIMPLETEST, new SimpleTestCmd());
        this.commands.put(CMD_READLOG, new ReadLogCmd());
        this.commands.put(CMD_READJOURNAL, new ReadJournalCmd());
        this.commands.put(CMD_LASTMARK, new LastMarkCmd());
        this.commands.put(CMD_AUTORECOVERY, new AutoRecoveryCmd());
        this.commands.put(CMD_HELP, new HelpCmd());
    }

    static void printLedgerMetadata(ReadMetadataCallback cb) throws Exception {
        LedgerMetadata md = (LedgerMetadata)cb.get();
        System.out.println("ledgerID: " + cb.getLedgerId());
        System.out.println(new String(md.serialize(), Charsets.UTF_8));
    }

    @Override
    public void setConf(Configuration conf) throws Exception {
        this.bkConf.loadConf(conf);
        this.journalDirectory = Bookie.getCurrentDirectory(this.bkConf.getJournalDir());
        this.ledgerDirectories = Bookie.getCurrentDirectories(this.bkConf.getLedgerDirs());
        this.formatter = EntryFormatter.newEntryFormatter((Configuration)this.bkConf, ENTRY_FORMATTER_CLASS);
        LOG.info("Using entry formatter " + this.formatter.getClass().getName());
        this.pageSize = this.bkConf.getPageSize();
        this.entriesPerPage = this.pageSize / 8;
    }

    private void printShellUsage() {
        System.err.println("Usage: BookieShell [-conf configuration] <command>");
        System.err.println();
        ArrayList<String> commandNames = new ArrayList<String>();
        for (MyCommand c : this.commands.values()) {
            commandNames.add("       " + c.getUsage());
        }
        Collections.sort(commandNames);
        for (String s : commandNames) {
            System.err.println(s);
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length <= 0) {
            this.printShellUsage();
            return -1;
        }
        String cmdName = args[0];
        Command cmd = this.commands.get(cmdName);
        if (null == cmd) {
            System.err.println("ERROR: Unknown command " + cmdName);
            this.printShellUsage();
            return -1;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return cmd.runCmd(newArgs);
    }

    public static void main(String[] argv) throws Exception {
        BookieShell shell = new BookieShell();
        if (argv.length <= 0) {
            shell.printShellUsage();
            System.exit(-1);
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        if ("-conf".equals(argv[0])) {
            if (argv.length <= 1) {
                shell.printShellUsage();
                System.exit(-1);
            }
            conf.addConfiguration((Configuration)new PropertiesConfiguration(new File(argv[1]).toURI().toURL()));
            String[] newArgv = new String[argv.length - 2];
            System.arraycopy(argv, 2, newArgv, 0, newArgv.length);
            argv = newArgv;
        }
        shell.setConf((Configuration)conf);
        int res = shell.run(argv);
        System.exit(res);
    }

    private File getLedgerFile(long ledgerId) {
        File d;
        String ledgerName = LedgerCacheImpl.getLedgerName(ledgerId);
        File lf = null;
        File[] arr$ = this.ledgerDirectories;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(lf = new File(d = arr$[i$], ledgerName)).exists(); ++i$) {
            lf = null;
        }
        return lf;
    }

    ReadOnlyFileInfo getFileInfo(long ledgerId) throws IOException {
        File ledgerFile = this.getLedgerFile(ledgerId);
        if (null == ledgerFile) {
            throw new FileNotFoundException("No index file found for ledger " + ledgerId + ". It may be not flushed yet.");
        }
        ReadOnlyFileInfo fi = new ReadOnlyFileInfo(ledgerFile, null);
        fi.readHeader();
        return fi;
    }

    private synchronized void initEntryLogger() throws IOException {
        if (null == this.entryLogger) {
            this.entryLogger = new ReadOnlyEntryLogger(this.bkConf);
        }
    }

    protected void scanEntryLog(long logId, EntryLogger.EntryLogScanner scanner) throws IOException {
        this.initEntryLogger();
        this.entryLogger.scanEntryLog(logId, scanner);
    }

    private synchronized Journal getJournal() throws IOException {
        if (null == this.journal) {
            this.journal = new Journal(this.bkConf, new LedgerDirsManager(this.bkConf));
        }
        return this.journal;
    }

    protected void scanJournal(long journalId, Journal.JournalScanner scanner) throws IOException {
        this.getJournal().scanJournal(journalId, 0L, scanner);
    }

    protected void readLedgerMeta(long ledgerId) throws Exception {
        System.out.println("===== LEDGER: " + ledgerId + " =====");
        ReadOnlyFileInfo fi = this.getFileInfo(ledgerId);
        byte[] masterKey = fi.getMasterKey();
        if (null == masterKey) {
            System.out.println("master key  : NULL");
        } else {
            System.out.println("master key  : " + BookieShell.bytes2Hex(fi.getMasterKey()));
        }
        long size = fi.size();
        if (size % 8L == 0L) {
            System.out.println("size        : " + size);
        } else {
            System.out.println("size : " + size + " (not aligned with 8, may be corrupted or under flushing now)");
        }
        System.out.println("entries     : " + size / 8L);
    }

    protected void readLedgerIndexEntries(long ledgerId) throws IOException {
        long curSize;
        System.out.println("===== LEDGER: " + ledgerId + " =====");
        ReadOnlyFileInfo fi = this.getFileInfo(ledgerId);
        long size = fi.size();
        System.out.println("size        : " + size);
        long curEntry = 0L;
        LedgerEntryPage lep = new LedgerEntryPage(this.pageSize, this.entriesPerPage);
        lep.usePage();
        try {
            for (curSize = 0L; curSize < size; curSize += (long)this.pageSize) {
                lep.setLedger(ledgerId);
                lep.setFirstEntry(curEntry);
                lep.readPage(fi);
                for (int i = 0; i < this.entriesPerPage; ++i) {
                    long offset = lep.getOffset(i * 8);
                    if (0L == offset) {
                        System.out.println("entry " + curEntry + "\t:\tN/A");
                    } else {
                        long entryLogId = offset >> 32;
                        long pos = offset & 0xFFFFFFFFL;
                        System.out.println("entry " + curEntry + "\t:\t(log:" + entryLogId + ", pos: " + pos + ")");
                    }
                    ++curEntry;
                }
            }
        }
        catch (IOException ie) {
            LOG.error("Failed to read index page : ", (Throwable)ie);
            if (curSize + (long)this.pageSize < size) {
                System.out.println("Failed to read index page @ " + curSize + ", the index file may be corrupted : " + ie.getMessage());
            }
            System.out.println("Failed to read last index page @ " + curSize + ", the index file may be corrupted or last index page is not fully flushed yet : " + ie.getMessage());
        }
    }

    protected void scanEntryLog(long logId, final boolean printMsg) throws Exception {
        System.out.println("Scan entry log " + logId + " (" + Long.toHexString(logId) + ".log)");
        this.scanEntryLog(logId, new EntryLogger.EntryLogScanner(){

            @Override
            public boolean accept(long ledgerId) {
                return true;
            }

            @Override
            public void process(long ledgerId, long startPos, ByteBuffer entry) {
                BookieShell.this.formatEntry(startPos, entry, printMsg);
            }
        });
    }

    protected void scanJournal(long journalId, final boolean printMsg) throws Exception {
        System.out.println("Scan journal " + journalId + " (" + Long.toHexString(journalId) + ".txn)");
        this.scanJournal(journalId, new Journal.JournalScanner(){
            boolean printJournalVersion = false;

            @Override
            public void process(int journalVersion, long offset, ByteBuffer entry) throws IOException {
                if (!this.printJournalVersion) {
                    System.out.println("Journal Version : " + journalVersion);
                    this.printJournalVersion = true;
                }
                BookieShell.this.formatEntry(offset, entry, printMsg);
            }
        });
    }

    protected void printLastLogMark() throws IOException {
        Journal.LastLogMark lastLogMark = this.getJournal().getLastLogMark();
        System.out.println("LastLogMark: Journal Id - " + lastLogMark.getTxnLogId() + "(" + Long.toHexString(lastLogMark.getTxnLogId()) + ".txn), Pos - " + lastLogMark.getTxnLogPosition());
    }

    private void formatEntry(long pos, ByteBuffer recBuff, boolean printMsg) {
        long ledgerId = recBuff.getLong();
        long entryId = recBuff.getLong();
        int entrySize = recBuff.limit();
        System.out.println("--------- Lid=" + ledgerId + ", Eid=" + entryId + ", ByteOffset=" + pos + ", EntrySize=" + entrySize + " ---------");
        if (entryId == -4096L) {
            int masterKeyLen = recBuff.getInt();
            byte[] masterKey = new byte[masterKeyLen];
            recBuff.get(masterKey);
            System.out.println("Type:           META");
            System.out.println("MasterKey:      " + BookieShell.bytes2Hex(masterKey));
            System.out.println();
            return;
        }
        if (entryId == -8192L) {
            System.out.println("Type:           META");
            System.out.println("Fenced");
            System.out.println();
            return;
        }
        long lastAddConfirmed = recBuff.getLong();
        System.out.println("Type:           DATA");
        System.out.println("LastConfirmed:  " + lastAddConfirmed);
        if (!printMsg) {
            System.out.println();
            return;
        }
        recBuff.position(40);
        System.out.println("Data:");
        System.out.println();
        try {
            byte[] ret = new byte[recBuff.remaining()];
            recBuff.get(ret);
            this.formatter.formatEntry(ret);
        }
        catch (Exception e) {
            System.out.println("N/A. Corrupted.");
        }
        System.out.println();
    }

    static String bytes2Hex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : data) {
            formatter.format("%02x", b);
        }
        return sb.toString();
    }

    private static int getOptionIntValue(CommandLine cmdLine, String option, int defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                System.err.println("ERROR: invalid value for option " + option + " : " + val);
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private static long getOptionLongValue(CommandLine cmdLine, String option, long defaultVal) {
        if (cmdLine.hasOption(option)) {
            String val = cmdLine.getOptionValue(option);
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                System.err.println("ERROR: invalid value for option " + option + " : " + val);
                return defaultVal;
            }
        }
        return defaultVal;
    }

    class WhoIsAuditorCmd
    extends MyCommand {
        Options opts;

        public WhoIsAuditorCmd() {
            super(BookieShell.CMD_WHOISAUDITOR);
            this.opts = new Options();
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Print the node which holds the auditor lock";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_WHOISAUDITOR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            ZooKeeper zk = null;
            try {
                ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(BookieShell.this.bkConf.getZkTimeout());
                zk = ZkUtils.createConnectedZookeeperClient(BookieShell.this.bkConf.getZkServers(), w);
                InetSocketAddress bookieId = AuditorElector.getCurrentAuditor(BookieShell.this.bkConf, zk);
                if (bookieId == null) {
                    LOG.info("No auditor elected");
                    int n = -1;
                    return n;
                }
                LOG.info("Auditor: {}/{}:{}", new Object[]{bookieId.getAddress().getCanonicalHostName(), bookieId.getAddress().getHostAddress(), bookieId.getPort()});
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
            return 0;
        }
    }

    class AutoRecoveryCmd
    extends MyCommand {
        Options opts;

        public AutoRecoveryCmd() {
            super(BookieShell.CMD_AUTORECOVERY);
            this.opts = new Options();
            this.opts.addOption("e", "enable", false, "Enable auto recovery of underreplicated ledgers");
            this.opts.addOption("d", "disable", false, "Disable auto recovery of underreplicated ledgers");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Enable or disable autorecovery in the cluster.";
        }

        @Override
        String getUsage() {
            return "autorecovery [-enable|-disable]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean disable = cmdLine.hasOption("d");
            boolean enable = cmdLine.hasOption("e");
            if (!disable && !enable || enable && disable) {
                LOG.error("One and only one of -enable and -disable must be specified");
                this.printUsage();
                return 1;
            }
            ZooKeeper zk = null;
            try {
                ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(BookieShell.this.bkConf.getZkTimeout());
                zk = ZkUtils.createConnectedZookeeperClient(BookieShell.this.bkConf.getZkServers(), w);
                LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(BookieShell.this.bkConf, zk);
                LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();
                if (enable) {
                    if (underreplicationManager.isLedgerReplicationEnabled()) {
                        LOG.warn("Autorecovery already enabled. Doing nothing");
                    } else {
                        LOG.info("Enabling autorecovery");
                        underreplicationManager.enableLedgerReplication();
                    }
                } else if (!underreplicationManager.isLedgerReplicationEnabled()) {
                    LOG.warn("Autorecovery already disabled. Doing nothing");
                } else {
                    LOG.info("Disabling autorecovery");
                    underreplicationManager.disableLedgerReplication();
                }
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
            return 0;
        }
    }

    class HelpCmd
    extends MyCommand {
        HelpCmd() {
            super(BookieShell.CMD_HELP);
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            String[] args = cmdLine.getArgs();
            if (args.length == 0) {
                BookieShell.this.printShellUsage();
                return 0;
            }
            String cmdName = args[0];
            Command cmd = BookieShell.this.commands.get(cmdName);
            if (null == cmd) {
                System.err.println("Unknown command " + cmdName);
                BookieShell.this.printShellUsage();
                return -1;
            }
            cmd.printUsage();
            return 0;
        }

        @Override
        String getDescription() {
            return "Describe the usage of this program or its subcommands.";
        }

        @Override
        String getUsage() {
            return "help         [COMMAND]";
        }

        @Override
        Options getOptions() {
            return new Options();
        }
    }

    class LastMarkCmd
    extends MyCommand {
        LastMarkCmd() {
            super(BookieShell.CMD_LASTMARK);
        }

        @Override
        public int runCmd(CommandLine c) throws Exception {
            BookieShell.this.printLastLogMark();
            return 0;
        }

        @Override
        String getDescription() {
            return "Print last log marker.";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_LASTMARK;
        }

        @Override
        Options getOptions() {
            return new Options();
        }
    }

    class ReadJournalCmd
    extends MyCommand {
        Options rjOpts;

        ReadJournalCmd() {
            super(BookieShell.CMD_READJOURNAL);
            this.rjOpts = new Options();
            this.rjOpts.addOption("m", "msg", false, "Print message body");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long journalId;
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                System.err.println("ERROR: missing journal id or journal file name");
                this.printUsage();
                return -1;
            }
            boolean printMsg = false;
            if (cmdLine.hasOption("m")) {
                printMsg = true;
            }
            try {
                journalId = Long.parseLong(leftArgs[0]);
            }
            catch (NumberFormatException nfe) {
                File f = new File(leftArgs[0]);
                String name = f.getName();
                if (!name.endsWith(".txn")) {
                    System.err.println("ERROR: invalid journal file name " + leftArgs[0]);
                    this.printUsage();
                    return -1;
                }
                String idString = name.split("\\.")[0];
                journalId = Long.parseLong(idString, 16);
            }
            BookieShell.this.scanJournal(journalId, printMsg);
            return 0;
        }

        @Override
        String getDescription() {
            return "Scan a journal file and format the entries into readable format.";
        }

        @Override
        String getUsage() {
            return "readjournal  [-msg] <journal_id | journal_file_name>";
        }

        @Override
        Options getOptions() {
            return this.rjOpts;
        }
    }

    class ReadLogCmd
    extends MyCommand {
        Options rlOpts;

        ReadLogCmd() {
            super(BookieShell.CMD_READLOG);
            this.rlOpts = new Options();
            this.rlOpts.addOption("m", "msg", false, "Print message body");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long logId;
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                System.err.println("ERROR: missing entry log id or entry log file name");
                this.printUsage();
                return -1;
            }
            boolean printMsg = false;
            if (cmdLine.hasOption("m")) {
                printMsg = true;
            }
            try {
                logId = Long.parseLong(leftArgs[0]);
            }
            catch (NumberFormatException nfe) {
                File f = new File(leftArgs[0]);
                String name = f.getName();
                if (!name.endsWith(".log")) {
                    System.err.println("ERROR: invalid entry log file name " + leftArgs[0]);
                    this.printUsage();
                    return -1;
                }
                String idString = name.split("\\.")[0];
                logId = Long.parseLong(idString, 16);
            }
            BookieShell.this.scanEntryLog(logId, printMsg);
            return 0;
        }

        @Override
        String getDescription() {
            return "Scan an entry file and format the entries into readable format.";
        }

        @Override
        String getUsage() {
            return "readlog      [-msg] <entry_log_id | entry_log_file_name>";
        }

        @Override
        Options getOptions() {
            return this.rlOpts;
        }
    }

    class SimpleTestCmd
    extends MyCommand {
        Options lOpts;

        SimpleTestCmd() {
            super(BookieShell.CMD_SIMPLETEST);
            this.lOpts = new Options();
            this.lOpts.addOption("e", "ensemble", true, "Ensemble size (default 3)");
            this.lOpts.addOption("w", "writeQuorum", true, "Write quorum size (default 2)");
            this.lOpts.addOption("a", "ackQuorum", true, "Ack quorum size (default 2)");
            this.lOpts.addOption("n", "numEntries", true, "Entries to write (default 1000)");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            byte[] data = new byte[100];
            int ensemble = BookieShell.getOptionIntValue(cmdLine, "ensemble", 3);
            int writeQuorum = BookieShell.getOptionIntValue(cmdLine, "writeQuorum", 2);
            int ackQuorum = BookieShell.getOptionIntValue(cmdLine, "ackQuorum", 2);
            int numEntries = BookieShell.getOptionIntValue(cmdLine, "numEntries", 1000);
            ClientConfiguration conf = new ClientConfiguration();
            conf.addConfiguration((Configuration)BookieShell.this.bkConf);
            BookKeeper bk = new BookKeeper(conf);
            LedgerHandle lh = bk.createLedger(ensemble, writeQuorum, ackQuorum, BookKeeper.DigestType.MAC, new byte[0]);
            System.out.println("Ledger ID: " + lh.getId());
            long lastReport = System.nanoTime();
            for (int i = 0; i < numEntries; ++i) {
                lh.addEntry(data);
                if (TimeUnit.SECONDS.convert(System.nanoTime() - lastReport, TimeUnit.NANOSECONDS) <= 1L) continue;
                System.out.println(i + " entries written");
                lastReport = System.nanoTime();
            }
            lh.close();
            bk.close();
            System.out.println(numEntries + " entries written to ledger " + lh.getId());
            return 0;
        }

        @Override
        String getDescription() {
            return "Simple test to create a ledger and write entries to it";
        }

        @Override
        String getUsage() {
            return "simpletest   [-ensemble N] [-writeQuorum N] [-ackQuorum N] [-numEntries N]";
        }

        @Override
        Options getOptions() {
            return this.lOpts;
        }
    }

    class LedgerMetadataCmd
    extends MyCommand {
        Options lOpts;

        LedgerMetadataCmd() {
            super(BookieShell.CMD_LEDGERMETADATA);
            this.lOpts = new Options();
            this.lOpts.addOption("l", "ledgerid", true, "Ledger ID");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long lid = BookieShell.getOptionLongValue(cmdLine, "ledgerid", -1L);
            if (lid == -1L) {
                System.err.println("Must specify a ledger id");
                return -1;
            }
            ZooKeeper zk = null;
            try {
                ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(BookieShell.this.bkConf.getZkTimeout());
                zk = ZkUtils.createConnectedZookeeperClient(BookieShell.this.bkConf.getZkServers(), w);
                LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(BookieShell.this.bkConf, zk);
                LedgerManager m = mFactory.newLedgerManager();
                ReadMetadataCallback cb = new ReadMetadataCallback(lid);
                m.readLedgerMetadata(lid, cb);
                BookieShell.printLedgerMetadata(cb);
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
            return 0;
        }

        @Override
        String getDescription() {
            return "Print the metadata for a ledger";
        }

        @Override
        String getUsage() {
            return "ledgermetadata -ledgerid <ledgerid>";
        }

        @Override
        Options getOptions() {
            return this.lOpts;
        }
    }

    static class ReadMetadataCallback
    extends AbstractFuture<LedgerMetadata>
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
        final long ledgerId;

        ReadMetadataCallback(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        @Override
        public void operationComplete(int rc, LedgerMetadata result) {
            if (rc != 0) {
                this.setException(BKException.create(rc));
            } else {
                this.set(result);
            }
        }
    }

    class ListLedgersCmd
    extends MyCommand {
        Options lOpts;

        ListLedgersCmd() {
            super(BookieShell.CMD_LISTLEDGERS);
            this.lOpts = new Options();
            this.lOpts.addOption("m", "meta", false, "Print metadata");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            ZooKeeper zk = null;
            try {
                ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(BookieShell.this.bkConf.getZkTimeout());
                zk = ZkUtils.createConnectedZookeeperClient(BookieShell.this.bkConf.getZkServers(), w);
                LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(BookieShell.this.bkConf, zk);
                LedgerManager m = mFactory.newLedgerManager();
                LedgerManager.LedgerRangeIterator iter = m.getLedgerRanges();
                if (cmdLine.hasOption("m")) {
                    ArrayList<ReadMetadataCallback> futures = new ArrayList<ReadMetadataCallback>(1000);
                    while (iter.hasNext()) {
                        LedgerManager.LedgerRange r = iter.next();
                        for (Long lid : r.getLedgers()) {
                            ReadMetadataCallback cb = new ReadMetadataCallback(lid);
                            m.readLedgerMetadata(lid, cb);
                            futures.add(cb);
                        }
                        if (futures.size() < 1000) continue;
                        while (futures.size() > 0) {
                            ReadMetadataCallback cb = (ReadMetadataCallback)futures.remove(0);
                            BookieShell.printLedgerMetadata(cb);
                        }
                    }
                    while (futures.size() > 0) {
                        ReadMetadataCallback cb = (ReadMetadataCallback)futures.remove(0);
                        BookieShell.printLedgerMetadata(cb);
                    }
                } else {
                    while (iter.hasNext()) {
                        LedgerManager.LedgerRange r = iter.next();
                        for (Long lid : r.getLedgers()) {
                            System.out.println(Long.toString(lid));
                        }
                    }
                }
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
            return 0;
        }

        @Override
        String getDescription() {
            return "List all ledgers on the cluster (this may take a long time)";
        }

        @Override
        String getUsage() {
            return "listledgers  [-meta]";
        }

        @Override
        Options getOptions() {
            return this.lOpts;
        }
    }

    class ListUnderreplicatedCmd
    extends MyCommand {
        Options opts;

        public ListUnderreplicatedCmd() {
            super(BookieShell.CMD_LISTUNDERREPLICATED);
            this.opts = new Options();
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "List ledgers marked as underreplicated";
        }

        @Override
        String getUsage() {
            return BookieShell.CMD_LISTUNDERREPLICATED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            ZooKeeper zk = null;
            try {
                ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(BookieShell.this.bkConf.getZkTimeout());
                zk = ZkUtils.createConnectedZookeeperClient(BookieShell.this.bkConf.getZkServers(), w);
                LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(BookieShell.this.bkConf, zk);
                LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();
                Iterator<Long> iter = underreplicationManager.listLedgersToRereplicate();
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
            }
            finally {
                if (zk != null) {
                    zk.close();
                }
            }
            return 0;
        }
    }

    class LedgerCmd
    extends MyCommand {
        Options lOpts;

        LedgerCmd() {
            super(BookieShell.CMD_LEDGER);
            this.lOpts = new Options();
            this.lOpts.addOption("m", "meta", false, "Print meta information");
        }

        @Override
        public int runCmd(CommandLine cmdLine) throws Exception {
            long ledgerId;
            String[] leftArgs = cmdLine.getArgs();
            if (leftArgs.length <= 0) {
                System.err.println("ERROR: missing ledger id");
                this.printUsage();
                return -1;
            }
            boolean printMeta = false;
            if (cmdLine.hasOption("m")) {
                printMeta = true;
            }
            try {
                ledgerId = Long.parseLong(leftArgs[0]);
            }
            catch (NumberFormatException nfe) {
                System.err.println("ERROR: invalid ledger id " + leftArgs[0]);
                this.printUsage();
                return -1;
            }
            if (printMeta) {
                BookieShell.this.readLedgerMeta(ledgerId);
            }
            BookieShell.this.readLedgerIndexEntries(ledgerId);
            return 0;
        }

        @Override
        String getDescription() {
            return "Dump ledger index entries into readable format.";
        }

        @Override
        String getUsage() {
            return "ledger       [-m] <ledger_id>";
        }

        @Override
        Options getOptions() {
            return this.lOpts;
        }
    }

    class RecoverCmd
    extends MyCommand {
        Options opts;

        public RecoverCmd() {
            super(BookieShell.CMD_RECOVER);
            this.opts = new Options();
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Recover the ledger data for failed bookie";
        }

        @Override
        String getUsage() {
            return "recover      <bookieSrc> [bookieDest]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            String[] args = cmdLine.getArgs();
            if (args.length < 1) {
                throw new MissingArgumentException("'bookieSrc' argument required");
            }
            ClientConfiguration adminConf = new ClientConfiguration(BookieShell.this.bkConf);
            BookKeeperAdmin admin = new BookKeeperAdmin(adminConf);
            try {
                int n = this.bkRecovery(admin, args);
                return n;
            }
            finally {
                if (null != admin) {
                    admin.close();
                }
            }
        }

        private int bkRecovery(BookKeeperAdmin bkAdmin, String[] args) throws InterruptedException, BKException {
            String[] bookieSrcString = args[0].split(":");
            if (bookieSrcString.length != 2) {
                System.err.println("BookieSrc inputted has invalid format(host:port expected): " + args[0]);
                return -1;
            }
            InetSocketAddress bookieSrc = new InetSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
            InetSocketAddress bookieDest = null;
            if (args.length >= 2) {
                String[] bookieDestString = args[1].split(":");
                if (bookieDestString.length < 2) {
                    System.err.println("BookieDest inputted has invalid format(host:port expected): " + args[1]);
                    return -1;
                }
                bookieDest = new InetSocketAddress(bookieDestString[0], Integer.parseInt(bookieDestString[1]));
            }
            bkAdmin.recoverBookieData(bookieSrc, bookieDest);
            return 0;
        }
    }

    class BookieFormatCmd
    extends MyCommand {
        Options opts;

        public BookieFormatCmd() {
            super(BookieShell.CMD_BOOKIEFORMAT);
            this.opts = new Options();
            this.opts.addOption("n", "nonInteractive", false, "Whether to confirm if old data exists..?");
            this.opts.addOption("f", "force", false, "If [nonInteractive] is specified, then whether to force delete the old data without prompt..?");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Format the current server contents";
        }

        @Override
        String getUsage() {
            return "bookieformat [-nonInteractive] [-force]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean interactive = !cmdLine.hasOption("n");
            boolean force = cmdLine.hasOption("f");
            ServerConfiguration conf = new ServerConfiguration(BookieShell.this.bkConf);
            boolean result = Bookie.format(conf, interactive, force);
            return result ? 0 : 1;
        }
    }

    class MetaFormatCmd
    extends MyCommand {
        Options opts;

        MetaFormatCmd() {
            super(BookieShell.CMD_METAFORMAT);
            this.opts = new Options();
            this.opts.addOption("n", "nonInteractive", false, "Whether to confirm if old data exists..?");
            this.opts.addOption("f", "force", false, "If [nonInteractive] is specified, then whether to force delete the old data without prompt.");
        }

        @Override
        Options getOptions() {
            return this.opts;
        }

        @Override
        String getDescription() {
            return "Format bookkeeper metadata in zookeeper";
        }

        @Override
        String getUsage() {
            return "metaformat   [-nonInteractive] [-force]";
        }

        @Override
        int runCmd(CommandLine cmdLine) throws Exception {
            boolean interactive = !cmdLine.hasOption("n");
            boolean force = cmdLine.hasOption("f");
            ClientConfiguration adminConf = new ClientConfiguration(BookieShell.this.bkConf);
            boolean result = BookKeeperAdmin.format(adminConf, interactive, force);
            return result ? 0 : 1;
        }
    }

    abstract class MyCommand
    implements Command {
        String cmdName;

        abstract Options getOptions();

        abstract String getDescription();

        abstract String getUsage();

        abstract int runCmd(CommandLine var1) throws Exception;

        MyCommand(String cmdName) {
            this.cmdName = cmdName;
        }

        @Override
        public int runCmd(String[] args) throws Exception {
            try {
                BasicParser parser = new BasicParser();
                CommandLine cmdLine = parser.parse(this.getOptions(), args);
                return this.runCmd(cmdLine);
            }
            catch (ParseException e) {
                LOG.error("Error parsing command line arguments : ", (Throwable)e);
                this.printUsage();
                return -1;
            }
        }

        @Override
        public void printUsage() {
            HelpFormatter hf = new HelpFormatter();
            System.err.println(this.cmdName + ": " + this.getDescription());
            hf.printHelp(this.getUsage(), this.getOptions());
        }
    }

    static interface Command {
        public int runCmd(String[] var1) throws Exception;

        public void printUsage();
    }
}

