/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public abstract class AbstractAvroMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File outputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;
    protected String[] excludes = new String[0];
    protected String[] testExcludes = new String[0];
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String[] includedFiles;
        boolean hasTestDir;
        boolean hasSourceDir = null != this.sourceDirectory && this.sourceDirectory.isDirectory();
        boolean bl = hasTestDir = null != this.testSourceDirectory && this.testSourceDirectory.isDirectory();
        if (!hasSourceDir && !hasTestDir) {
            throw new MojoExecutionException("neither sourceDirectory: " + this.sourceDirectory + " or testSourceDirectory: " + this.testSourceDirectory + " are directories");
        }
        if (hasSourceDir) {
            includedFiles = this.getIncludedFiles(this.sourceDirectory.getAbsolutePath(), this.excludes, this.getIncludes());
            this.compileFiles(includedFiles, this.sourceDirectory, this.outputDirectory);
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (hasTestDir) {
            includedFiles = this.getIncludedFiles(this.testSourceDirectory.getAbsolutePath(), this.testExcludes, this.getTestIncludes());
            this.compileFiles(includedFiles, this.testSourceDirectory, this.testOutputDirectory);
            this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
        }
    }

    private String[] getIncludedFiles(String absPath, String[] excludes, String[] includes) {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(absPath);
        fs.setFollowSymlinks(false);
        for (String include : includes) {
            fs.addInclude(include);
        }
        for (String exclude : excludes) {
            fs.addExclude(exclude);
        }
        return fileSetManager.getIncludedFiles(fs);
    }

    private void compileFiles(String[] files, File sourceDir, File outDir) throws MojoExecutionException {
        for (String filename : files) {
            try {
                this.doCompile(filename, sourceDir, outDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error compiling protocol file " + filename + " to " + outDir, (Exception)e);
            }
        }
    }

    protected abstract void doCompile(String var1, File var2, File var3) throws IOException;

    protected abstract String[] getIncludes();

    protected abstract String[] getTestIncludes();
}

