/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.receivers;

import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.accumulo.trace.instrument.receivers.SpanReceiver;
import org.apache.accumulo.trace.thrift.RemoteSpan;
import org.apache.log4j.Logger;

public abstract class AsyncSpanReceiver<SpanKey, Destination>
implements SpanReceiver {
    private static final Logger log = Logger.getLogger(AsyncSpanReceiver.class);
    private final Map<SpanKey, Destination> clients = new HashMap<SpanKey, Destination>();
    protected final String host;
    protected final String service;
    Timer timer = new Timer("SpanSender", true);
    final AbstractQueue<RemoteSpan> sendQueue = new ConcurrentLinkedQueue<RemoteSpan>();

    protected abstract Destination createDestination(SpanKey var1) throws Exception;

    protected abstract void send(Destination var1, RemoteSpan var2) throws Exception;

    protected abstract SpanKey getSpanKey(Map<String, String> var1);

    public AsyncSpanReceiver(String host, String service, long millis) {
        this.host = host;
        this.service = service;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AsyncSpanReceiver.this.sendSpans();
                }
                catch (Exception ex) {
                    log.warn((Object)"Exception sending spans to destination", (Throwable)ex);
                }
            }
        }, millis, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSpans() {
        while (!this.sendQueue.isEmpty()) {
            boolean sent = false;
            RemoteSpan s = (RemoteSpan)this.sendQueue.peek();
            if (s.stop - s.start < 1L) {
                AbstractQueue<RemoteSpan> abstractQueue = this.sendQueue;
                synchronized (abstractQueue) {
                    this.sendQueue.remove();
                    this.sendQueue.notifyAll();
                    continue;
                }
            }
            SpanKey dest = this.getSpanKey(s.data);
            Destination client = this.clients.get(dest);
            if (client == null) {
                try {
                    this.clients.put(dest, this.createDestination(dest));
                }
                catch (Exception ex) {
                    log.warn((Object)"Exception creating connection to span receiver", (Throwable)ex);
                }
            }
            if (client != null) {
                try {
                    this.send(client, s);
                    AbstractQueue<RemoteSpan> ex = this.sendQueue;
                    synchronized (ex) {
                        this.sendQueue.remove();
                        this.sendQueue.notifyAll();
                    }
                    sent = true;
                }
                catch (Exception ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
            if (sent) continue;
            break;
        }
    }

    @Override
    public void span(long traceId, long spanId, long parentId, long start, long stop, String description, Map<String, String> data) {
        SpanKey dest = this.getSpanKey(data);
        if (dest != null) {
            this.sendQueue.add(new RemoteSpan(this.host, this.service, traceId, spanId, parentId, start, stop, description, data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        AbstractQueue<RemoteSpan> abstractQueue = this.sendQueue;
        synchronized (abstractQueue) {
            while (!this.sendQueue.isEmpty()) {
                try {
                    this.sendQueue.wait();
                }
                catch (InterruptedException e) {
                    log.warn((Object)"flush interrupted");
                    break;
                }
            }
        }
    }
}

