/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.tabletserver.Tablet;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MutationLog {
    private FSDataOutputStream logout;
    public static final byte MUTATION_EVENT = 1;
    public static final byte CLOSE_EVENT = 2;

    public MutationLog(Path logfile) throws IOException {
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)conf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        if (!fs.exists(logfile)) {
            this.logout = fs.create(logfile);
        }
    }

    public void log(Mutation m) throws IOException {
        this.logout.writeByte(1);
        m.write((DataOutput)this.logout);
        this.logout.flush();
    }

    public void close() throws IOException {
        this.logout.writeByte(2);
        this.logout.close();
    }

    public static Iterator<Mutation> replay(Path logfile, Tablet t, long min_timestamp) throws IOException {
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)conf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        final FSDataInputStream login = fs.open(logfile);
        final ServerMutation mutation = new ServerMutation();
        return new Iterator<Mutation>(){
            byte eventType;
            {
                this.eventType = login.readByte();
            }

            @Override
            public boolean hasNext() {
                return this.eventType != 2;
            }

            @Override
            public Mutation next() {
                try {
                    mutation.readFields((DataInput)login);
                    this.eventType = login.readByte();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return mutation;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

