/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.log4j.Logger;

public abstract class MasterRepo implements Repo<Master> {
  
  private static final long serialVersionUID = 1L;
  protected static final Logger log = Logger.getLogger(MasterRepo.class);
  
  @Override
  public long isReady(long tid, Master environment) throws Exception {
    return 0;
  }
  
  @Override
  public void undo(long tid, Master environment) throws Exception {}
  
  @Override
  public String getDescription() {
    return this.getClass().getSimpleName();
  }
  
  @Override
  public String getReturn() {
    return null;
  }
  
  @Override
  abstract public Repo<Master> call(long tid, Master environment) throws Exception;
  
}
