/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;

public class AdminUtil<T> {
    public void print(ZooStore<T> zs, IZooReaderWriter zk, String lockPath) throws KeeperException, InterruptedException {
        HashMap<Long, ArrayList<String>> heldLocks = new HashMap<Long, ArrayList<String>>();
        HashMap waitingLocks = new HashMap();
        List<String> lockedIds = zk.getChildren(lockPath);
        for (String id : lockedIds) {
            try {
                List<String> list = zk.getChildren(lockPath + "/" + id);
                ArrayList<String> arrayList = new ArrayList<String>(list);
                Collections.sort(arrayList);
                int pos = 0;
                boolean sawWriteLock = false;
                for (String node : arrayList) {
                    try {
                        HashMap<Long, ArrayList<String>> locks;
                        ArrayList<String> tables;
                        byte[] data = zk.getData(lockPath + "/" + id + "/" + node, null);
                        String[] lda = new String(data).split(":");
                        if (lda[0].charAt(0) == 'W') {
                            sawWriteLock = true;
                        }
                        if ((tables = (ArrayList<String>)(locks = pos == 0 ? heldLocks : (lda[0].charAt(0) == 'R' && !sawWriteLock ? heldLocks : waitingLocks)).get(Long.parseLong(lda[1], 16))) == null) {
                            tables = new ArrayList<String>();
                            locks.put(Long.parseLong(lda[1], 16), tables);
                        }
                        tables.add(lda[0].charAt(0) + ":" + id);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pos;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Failed to read locks for " + id + " continuing");
            }
        }
        List<Long> transactions = zs.list();
        for (Long l : transactions) {
            List wlocks;
            zs.reserve(l);
            String debug = (String)((Object)zs.getProperty(l, "debug"));
            List hlocks = (List)heldLocks.remove(l);
            if (hlocks == null) {
                hlocks = Collections.emptyList();
            }
            if ((wlocks = (List)waitingLocks.remove(l)) == null) {
                wlocks = Collections.emptyList();
            }
            String top = null;
            Repo<T> repo = zs.top(l);
            if (repo != null) {
                top = repo.getDescription();
            }
            TStore.TStatus status = null;
            status = zs.getStatus(l);
            zs.unreserve(l, 0L);
            System.out.printf("txid: %016x  status: %-18s  op: %-15s  locked: %-15s locking: %-15s top: %s%n", new Object[]{l, status, debug, hlocks, wlocks, top});
        }
        if (heldLocks.size() != 0 || waitingLocks.size() != 0) {
            System.out.println();
            System.out.println("The following locks did not have an associated FATE operation");
            System.out.println();
            for (Map.Entry entry : heldLocks.entrySet()) {
                System.out.printf("txid: %016x  locked: %s%n", entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : waitingLocks.entrySet()) {
                System.out.printf("txid: %016x  locking: %s%n", entry.getKey(), entry.getValue());
            }
        }
    }

    public void prepDelete(ZooStore<T> zs, IZooReaderWriter zk, String path, String txidStr) {
        this.checkGlobalLock(zk, path);
        long txid = Long.parseLong(txidStr, 16);
        zs.reserve(txid);
        zs.delete(txid);
        zs.unreserve(txid, 0L);
    }

    public void prepFail(ZooStore<T> zs, IZooReaderWriter zk, String path, String txidStr) {
        this.checkGlobalLock(zk, path);
        long txid = Long.parseLong(txidStr, 16);
        zs.reserve(txid);
        zs.setStatus(txid, TStore.TStatus.FAILED_IN_PROGRESS);
        zs.unreserve(txid, 0L);
    }

    public void deleteLocks(ZooStore<T> zs, IZooReaderWriter zk, String path, String txidStr) throws KeeperException, InterruptedException {
        List<String> lockedIds = zk.getChildren(path);
        for (String id : lockedIds) {
            List<String> lockNodes = zk.getChildren(path + "/" + id);
            for (String node : lockNodes) {
                String lockPath = path + "/" + id + "/" + node;
                byte[] data = zk.getData(path + "/" + id + "/" + node, null);
                String[] lda = new String(data).split(":");
                if (!lda[1].equals(txidStr)) continue;
                zk.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
            }
        }
    }

    public void checkGlobalLock(IZooReaderWriter zk, String path) {
        try {
            if (ZooLock.getLockData(zk.getZooKeeper(), path) != null) {
                System.err.println("ERROR: Master lock is held, not running");
                System.exit(-1);
            }
        }
        catch (KeeperException e) {
            System.err.println("ERROR: Could not read master lock, not running " + e.getMessage());
            System.exit(-1);
        }
        catch (InterruptedException e) {
            System.err.println("ERROR: Could not read master lock, not running" + e.getMessage());
            System.exit(-1);
        }
    }
}

