/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.file;

import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.io.file.FileCleaner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static Logger logger = LoggerFactory.getLogger(Files.class);
    public static final int BYTE_BUFFER_LENGTH = 16384;

    private Files() {
    }

    @Deprecated
    public static File createTempFile(String tempFileName) throws IOException {
        return Files.createTempFile(PropertyOrPlatformTempDir.defaultInstance(), tempFileName);
    }

    public static File createTempFile(IDirectory directory, String tempFileName) throws IOException {
        File tempDir = directory.asFile();
        return Files.createTempFile(tempDir, tempFileName);
    }

    public static File createTempFile(File tempDir, String tempFileName) throws IOException, FileAlreadyExistsException {
        File tempFile = new File(tempDir, tempFileName);
        if (!tempFile.createNewFile()) {
            throw new FileAlreadyExistsException("Could not create Tempfile", tempFile);
        }
        return tempFile;
    }

    public static File createOrCheckDir(String dir) throws IOException {
        File tempFile = new File(dir);
        if (tempFile.exists() && tempFile.isDirectory()) {
            return tempFile;
        }
        return Files.createDir(tempFile);
    }

    public static File createOrCheckUserDir(String prefix) throws IOException {
        File tempDir = new File(System.getProperty("user.home"));
        File tempFile = new File(tempDir, prefix);
        if (tempFile.exists() && tempFile.isDirectory()) {
            return tempFile;
        }
        return Files.createDir(tempFile);
    }

    @Deprecated
    public static File createTempDir(String prefix) throws IOException {
        return Files.createTempDir(PropertyOrPlatformTempDir.defaultInstance(), prefix);
    }

    public static File createTempDir(IDirectory directory, String prefix) throws IOException {
        File tempDir = directory.asFile();
        return Files.createTempDir(tempDir, prefix);
    }

    public static File createTempDir(File tempDir, String prefix) throws IOException {
        File tempFile = new File(tempDir, prefix + "-" + UUID.randomUUID().toString());
        return Files.createDir(tempFile);
    }

    public static File createDir(File tempFile) throws IOException {
        if (!tempFile.mkdirs()) {
            throw new IOException("Could not create Tempdir: " + tempFile);
        }
        return tempFile;
    }

    public static boolean forceDelete(File fileOrDir) {
        boolean ret = false;
        try {
            if (fileOrDir != null && fileOrDir.exists()) {
                FileUtils.forceDelete((File)fileOrDir);
                logger.debug("Could delete {}", (Object)fileOrDir);
                ret = true;
            }
        }
        catch (IOException e) {
            logger.warn("Could not delete {}. Will try to delete it again when program exits.", (Object)fileOrDir);
            FileCleaner.forceDeleteOnExit(fileOrDir);
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, long size, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try {
            int read;
            byte[] buf = new byte[16384];
            int left = buf.length;
            if ((long)left > size) {
                left = (int)size;
            }
            while ((read = in.read(buf, 0, left)) > 0) {
                out.write(buf, 0, read);
                if ((long)left <= (size -= (long)read)) continue;
                left = (int)size;
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try {
            int read;
            byte[] buf = new byte[16384];
            while ((read = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String content, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        OutputStreamWriter w = new OutputStreamWriter(out);
        try {
            w.write(content);
            w.flush();
        }
        finally {
            out.close();
        }
    }

    public static boolean moveFile(File source, File destination) {
        if (!source.renameTo(destination)) {
            try {
                Files.copyFile(source, destination);
                return source.delete();
            }
            catch (IOException iox) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File destination) throws IOException {
        FileInputStream reader = null;
        FileOutputStream writer = null;
        try {
            int read;
            reader = new FileInputStream(source);
            writer = new FileOutputStream(destination);
            byte[] buf = new byte[16384];
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

