/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.file;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCleaner {
    private static Logger logger = LoggerFactory.getLogger(FileCleaner.class);
    static final int MAX_FILES_TO_CLEAN = 10000;
    static final int MAX_RETRIES = 100;
    static Cleaner cleaner;

    public static synchronized void forceDeleteOnExit(File fileOrDir) {
        if (cleaner == null) {
            cleaner = new Cleaner();
            Thread cleanerThread = new Thread(new CleanerThreadRunner(cleaner));
            cleanerThread.setDaemon(true);
            cleanerThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new CleanerShutdownHook(cleaner)));
        }
        cleaner.forceDelete(fileOrDir);
    }

    static class Cleaner {
        private final Map<File, Integer> fileToClean = new HashMap<File, Integer>();

        Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clean() {
            while (true) {
                try {
                    while (true) {
                        Map<File, Integer> map = this.fileToClean;
                        synchronized (map) {
                            this.fileToClean.wait(1000L);
                            this.deleteFiles();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteFiles() {
            Map<File, Integer> map = this.fileToClean;
            synchronized (map) {
                HashMap<File, Integer> copy = new HashMap<File, Integer>(this.fileToClean);
                for (File f : copy.keySet()) {
                    try {
                        FileUtils.forceDelete((File)f);
                        this.fileToClean.remove(f);
                        logger.info("Could delete " + f);
                    }
                    catch (IOException iox) {
                        int newCounter = this.fileToClean.get(f) + 1;
                        if (newCounter > 100) {
                            logger.error("Could not delete {} after {} retries, leave it unchanged", (Object)f, (Object)newCounter);
                            this.fileToClean.remove(f);
                            continue;
                        }
                        this.fileToClean.put(f, newCounter);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceDelete(File fileOrDir) {
            if (fileOrDir.exists()) {
                Map<File, Integer> map = this.fileToClean;
                synchronized (map) {
                    if (this.fileToClean.size() < 10000) {
                        Integer oldValue = this.fileToClean.put(fileOrDir, 0);
                        if (oldValue != null) {
                            logger.error("forceDelete {}, but allready in list with {} tries.", (Object)fileOrDir, (Object)oldValue);
                        }
                    } else {
                        throw new RuntimeException("filesToClean exceeded 10000, something is wrong here (tried to delete " + fileOrDir + ")");
                    }
                    this.fileToClean.notify();
                }
            }
        }
    }

    static class CleanerShutdownHook
    implements Runnable {
        private final Cleaner _cleaner;

        CleanerShutdownHook(Cleaner cleaner) {
            this._cleaner = cleaner;
        }

        @Override
        public void run() {
            this._cleaner.deleteFiles();
        }
    }

    static class CleanerThreadRunner
    implements Runnable {
        private final Cleaner _cleaner;

        CleanerThreadRunner(Cleaner cleaner) {
            this._cleaner = cleaner;
        }

        @Override
        public void run() {
            this._cleaner.clean();
        }
    }
}

