/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.recordlevel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import parquet.Preconditions;
import parquet.common.schema.ColumnPath;
import parquet.filter2.recordlevel.FilteringPrimitiveConverter;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import parquet.io.PrimitiveColumnIO;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;

public class FilteringGroupConverter
extends GroupConverter {
    private final GroupConverter delegate;
    private final List<Integer> indexFieldPath;
    private final Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn;
    private final Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath;

    public FilteringGroupConverter(GroupConverter delegate, List<Integer> indexFieldPath, Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn, Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath) {
        this.delegate = (GroupConverter)Preconditions.checkNotNull((Object)delegate, (String)"delegate");
        this.indexFieldPath = (List)Preconditions.checkNotNull(indexFieldPath, (String)"indexFieldPath");
        this.columnIOsByIndexFieldPath = (Map)Preconditions.checkNotNull(columnIOsByIndexFieldPath, (String)"columnIOsByIndexFieldPath");
        this.valueInspectorsByColumn = (Map)Preconditions.checkNotNull(valueInspectorsByColumn, (String)"valueInspectorsByColumn");
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        Converter delegateConverter = (Converter)Preconditions.checkNotNull((Object)this.delegate.getConverter(fieldIndex), (String)"delegate converter");
        ArrayList<Integer> newIndexFieldPath = new ArrayList<Integer>(this.indexFieldPath.size() + 1);
        newIndexFieldPath.addAll(this.indexFieldPath);
        newIndexFieldPath.add(fieldIndex);
        if (delegateConverter.isPrimitive()) {
            PrimitiveColumnIO columnIO = this.getColumnIO(newIndexFieldPath);
            ColumnPath columnPath = ColumnPath.get((String[])columnIO.getColumnDescriptor().getPath());
            IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors = this.getValueInspectors(columnPath);
            return new FilteringPrimitiveConverter(delegateConverter.asPrimitiveConverter(), valueInspectors);
        }
        return new FilteringGroupConverter(delegateConverter.asGroupConverter(), newIndexFieldPath, this.valueInspectorsByColumn, this.columnIOsByIndexFieldPath);
    }

    private PrimitiveColumnIO getColumnIO(List<Integer> indexFieldPath) {
        PrimitiveColumnIO found = this.columnIOsByIndexFieldPath.get(indexFieldPath);
        Preconditions.checkArgument((found != null ? 1 : 0) != 0, (String)("Did not find PrimitiveColumnIO for index field path" + indexFieldPath));
        return found;
    }

    private IncrementallyUpdatedFilterPredicate.ValueInspector[] getValueInspectors(ColumnPath columnPath) {
        List<IncrementallyUpdatedFilterPredicate.ValueInspector> inspectorsList = this.valueInspectorsByColumn.get(columnPath);
        if (inspectorsList == null) {
            return new IncrementallyUpdatedFilterPredicate.ValueInspector[0];
        }
        return inspectorsList.toArray(new IncrementallyUpdatedFilterPredicate.ValueInspector[inspectorsList.size()]);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void end() {
        this.delegate.end();
    }
}

