/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import parquet.schema.DecimalMetadata;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public class TestTypeBuilders {
    @Test
    public void testPaperExample() {
        MessageType expected = new MessageType("Document", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")}), new GroupType(Type.Repetition.REPEATED, "Name", new Type[]{new GroupType(Type.Repetition.REPEATED, "Language", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Code"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Country")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Url")})});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).named("DocId")).optionalGroup().repeated(PrimitiveType.PrimitiveTypeName.INT64).named("Backward")).repeated(PrimitiveType.PrimitiveTypeName.INT64).named("Forward")).named("Links")).repeatedGroup().repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("Code")).required(PrimitiveType.PrimitiveTypeName.BINARY).named("Country")).named("Language")).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("Url")).named("Name")).named("Document");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testGroupTypeConstruction() {
        PrimitiveType f1 = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("f1");
        PrimitiveType f2 = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f2");
        PrimitiveType f3 = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f3");
        String name = "group";
        for (Type.Repetition repetition : Type.Repetition.values()) {
            GroupType expected = new GroupType(repetition, name, new Type[]{f1, new GroupType(repetition, "g1", new Type[]{f2, f3})});
            GroupType built = (GroupType)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).addField((Type)f1).group(repetition).addFields(new Type[]{f2, f3}).named("g1")).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
            switch (repetition) {
                case REQUIRED: {
                    built = (GroupType)((Types.GroupBuilder)Types.requiredGroup().addField((Type)f1).requiredGroup().addFields(new Type[]{f2, f3}).named("g1")).named(name);
                    break;
                }
                case OPTIONAL: {
                    built = (GroupType)((Types.GroupBuilder)Types.optionalGroup().addField((Type)f1).optionalGroup().addFields(new Type[]{f2, f3}).named("g1")).named(name);
                    break;
                }
                case REPEATED: {
                    built = (GroupType)((Types.GroupBuilder)Types.repeatedGroup().addField((Type)f1).repeatedGroup().addFields(new Type[]{f2, f3}).named("g1")).named(name);
                }
            }
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testPrimitiveTypeConstruction() {
        PrimitiveType.PrimitiveTypeName[] types;
        for (PrimitiveType.PrimitiveTypeName type : types = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY}) {
            String name = type.toString() + "_";
            for (Type.Repetition repetition : Type.Repetition.values()) {
                PrimitiveType expected = new PrimitiveType(repetition, type, name);
                PrimitiveType built = (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)type, (Type.Repetition)repetition).named(name);
                Assert.assertEquals((Object)expected, (Object)built);
                switch (repetition) {
                    case REQUIRED: {
                        built = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)type).named(name);
                        break;
                    }
                    case OPTIONAL: {
                        built = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)type).named(name);
                        break;
                    }
                    case REPEATED: {
                        built = (PrimitiveType)Types.repeated((PrimitiveType.PrimitiveTypeName)type).named(name);
                    }
                }
                Assert.assertEquals((Object)expected, (Object)built);
            }
        }
    }

    @Test
    public void testFixedTypeConstruction() {
        String name = "fixed_";
        int len = 5;
        for (Type.Repetition repetition : Type.Repetition.values()) {
            PrimitiveType expected = new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, len, name);
            PrimitiveType built = (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(len).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
            switch (repetition) {
                case REQUIRED: {
                    built = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len).named(name);
                    break;
                }
                case OPTIONAL: {
                    built = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len).named(name);
                    break;
                }
                case REPEATED: {
                    built = (PrimitiveType)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len).named(name);
                }
            }
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testEmptyGroup() {
        TestTypeBuilders.assertThrows("Should complain that required group is empty", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)Types.requiredGroup().named("g");
            }
        });
        TestTypeBuilders.assertThrows("Should complain that optional group is empty", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)Types.optionalGroup().named("g");
            }
        });
        TestTypeBuilders.assertThrows("Should complain that repeated group is empty", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)Types.repeatedGroup().named("g");
            }
        });
    }

    @Test
    @Ignore(value="Enforcing this breaks tests in parquet-thrift")
    public void testEmptyMessage() {
        TestTypeBuilders.assertThrows("Should complain that message is empty", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return Types.buildMessage().named("m");
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFixedWithoutLength() {
        Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).named("fixed");
    }

    @Test
    public void testFixedWithLength() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 7, "fixed");
        PrimitiveType fixed = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7).named("fixed");
        Assert.assertEquals((Object)expected, (Object)fixed);
    }

    @Test
    public void testFixedLengthEquals() {
        Type f4 = (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4).named("f4");
        Type f8 = (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8).named("f8");
        Assert.assertFalse((String)"Types with different lengths should not be equal", (boolean)f4.equals(f8));
    }

    @Test
    public void testDecimalAnnotation() {
        MessageType expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(18, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(18).scale(2).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 4, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testDecimalAnnotationMissingScale() {
        MessageType expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(9).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(9).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 7, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7).as(OriginalType.DECIMAL)).precision(9).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testDecimalAnnotationMissingPrecision() {
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).scale(2).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).scale(2).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).scale(2).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7).as(OriginalType.DECIMAL)).scale(2).named("aDecimal")).named("DecimalMessage");
            }
        });
    }

    @Test
    public void testDecimalAnnotationPrecisionScaleBound() {
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(3).scale(4).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(3).scale(4).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(3).scale(4).named("aDecimal")).named("DecimalMessage");
            }
        });
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7).as(OriginalType.DECIMAL)).precision(3).scale(4).named("aDecimal")).named("DecimalMessage");
            }
        });
    }

    @Test
    public void testDecimalAnnotationLengthCheck() {
        TestTypeBuilders.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4).as(OriginalType.DECIMAL)).precision(10).scale(2).named("aDecimal");
            }
        });
        TestTypeBuilders.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(10).scale(2).named("aDecimal");
            }
        });
        TestTypeBuilders.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8).as(OriginalType.DECIMAL)).precision(19).scale(4).named("aDecimal");
            }
        });
        TestTypeBuilders.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).length(8).as(OriginalType.DECIMAL)).precision(19).scale(4).named("aDecimal");
            }
        });
    }

    @Test
    public void testDECIMALAnnotationRejectsUnsupportedTypes() {
        PrimitiveType.PrimitiveTypeName[] unsupported;
        for (final PrimitiveType.PrimitiveTypeName type : unsupported = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
            TestTypeBuilders.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, new Callable<Type>(){

                @Override
                public Type call() throws Exception {
                    return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(OriginalType.DECIMAL)).precision(9).scale(2).named("d");
                }
            });
        }
    }

    @Test
    public void testBinaryAnnotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.UTF8, OriginalType.JSON, OriginalType.BSON}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "col", logicalType);
            PrimitiveType string = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)string);
        }
    }

    @Test
    public void testBinaryAnnotationsRejectsNonBinary() {
        OriginalType[] types;
        for (final OriginalType logicalType : types = new OriginalType[]{OriginalType.UTF8, OriginalType.JSON, OriginalType.BSON}) {
            PrimitiveType.PrimitiveTypeName[] nonBinary;
            for (final PrimitiveType.PrimitiveTypeName type : nonBinary = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
                TestTypeBuilders.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, new Callable<Type>(){

                    @Override
                    public Type call() throws Exception {
                        return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col");
                    }
                });
            }
            TestTypeBuilders.assertThrows("Should reject non-binary type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, new Callable<Type>(){

                @Override
                public Type call() throws Exception {
                    return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1).as(logicalType)).named("col");
                }
            });
        }
    }

    @Test
    public void testInt32Annotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.DATE, OriginalType.TIME_MILLIS, OriginalType.UINT_8, OriginalType.UINT_16, OriginalType.UINT_32, OriginalType.INT_8, OriginalType.INT_16, OriginalType.INT_32}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt32AnnotationsRejectNonInt32() {
        OriginalType[] types;
        for (final OriginalType logicalType : types = new OriginalType[]{OriginalType.DATE, OriginalType.TIME_MILLIS, OriginalType.UINT_8, OriginalType.UINT_16, OriginalType.UINT_32, OriginalType.INT_8, OriginalType.INT_16, OriginalType.INT_32}) {
            PrimitiveType.PrimitiveTypeName[] nonInt32;
            for (final PrimitiveType.PrimitiveTypeName type : nonInt32 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuilders.assertThrows("Should reject non-int32 type: " + type, IllegalStateException.class, new Callable<Type>(){

                    @Override
                    public Type call() throws Exception {
                        return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col");
                    }
                });
            }
            TestTypeBuilders.assertThrows("Should reject non-int32 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, new Callable<Type>(){

                @Override
                public Type call() throws Exception {
                    return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1).as(logicalType)).named("col");
                }
            });
        }
    }

    @Test
    public void testInt64Annotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.TIMESTAMP_MILLIS, OriginalType.UINT_64, OriginalType.INT_64}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt64AnnotationsRejectNonInt64() {
        OriginalType[] types;
        for (final OriginalType logicalType : types = new OriginalType[]{OriginalType.TIMESTAMP_MILLIS, OriginalType.UINT_64, OriginalType.INT_64}) {
            PrimitiveType.PrimitiveTypeName[] nonInt64;
            for (final PrimitiveType.PrimitiveTypeName type : nonInt64 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuilders.assertThrows("Should reject non-int64 type: " + type, IllegalStateException.class, new Callable<Type>(){

                    @Override
                    public Type call() throws Exception {
                        return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col");
                    }
                });
            }
            TestTypeBuilders.assertThrows("Should reject non-int64 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, new Callable<Type>(){

                @Override
                public Type call() throws Exception {
                    return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1).as(logicalType)).named("col");
                }
            });
        }
    }

    @Test
    public void testIntervalAnnotation() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 12, "interval", OriginalType.INTERVAL);
        PrimitiveType string = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12).as(OriginalType.INTERVAL)).named("interval");
        Assert.assertEquals((Object)expected, (Object)string);
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed() {
        PrimitiveType.PrimitiveTypeName[] nonFixed;
        for (final PrimitiveType.PrimitiveTypeName type : nonFixed = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
            TestTypeBuilders.assertThrows("Should reject non-fixed type: " + type, IllegalStateException.class, new Callable<Type>(){

                @Override
                public Type call() throws Exception {
                    return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(OriginalType.INTERVAL)).named("interval");
                }
            });
        }
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed12() {
        TestTypeBuilders.assertThrows("Should reject fixed with length != 12: 11", IllegalStateException.class, new Callable<Type>(){

            @Override
            public Type call() throws Exception {
                return (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(11).as(OriginalType.INTERVAL)).named("interval");
            }
        });
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, Callable callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            Assert.assertEquals((String)message, expected, actual.getClass());
        }
    }
}

