/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.recordlevel;

import org.junit.Assert;
import org.junit.Test;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateEvaluator;

public class TestIncrementallyUpdatedFilterPredicateEvaluator {
    public static IncrementallyUpdatedFilterPredicate.ValueInspector intIsNull() {
        return new IncrementallyUpdatedFilterPredicate.ValueInspector(){

            public void updateNull() {
                this.setResult(true);
            }

            public void update(int value) {
                this.setResult(false);
            }
        };
    }

    public static IncrementallyUpdatedFilterPredicate.ValueInspector intIsEven() {
        return new IncrementallyUpdatedFilterPredicate.ValueInspector(){

            public void updateNull() {
                this.setResult(false);
            }

            public void update(int value) {
                this.setResult(value % 2 == 0);
            }
        };
    }

    public static IncrementallyUpdatedFilterPredicate.ValueInspector doubleMoreThan10() {
        return new IncrementallyUpdatedFilterPredicate.ValueInspector(){

            public void updateNull() {
                this.setResult(false);
            }

            public void update(double value) {
                this.setResult(value > 10.0);
            }
        };
    }

    @Test
    public void testValueInspector() {
        IncrementallyUpdatedFilterPredicate.ValueInspector v = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        v.update(11);
        Assert.assertFalse((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)v));
        v.reset();
        v.update(12);
        Assert.assertTrue((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)v));
        v.reset();
        v.updateNull();
        Assert.assertFalse((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)v));
        v.reset();
        IncrementallyUpdatedFilterPredicate.ValueInspector intIsNull = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsNull();
        intIsNull.update(10);
        Assert.assertFalse((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)intIsNull));
        intIsNull.reset();
        intIsNull.updateNull();
        Assert.assertTrue((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)intIsNull));
        intIsNull.reset();
        v.reset();
        Assert.assertFalse((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)v));
        intIsNull.reset();
        Assert.assertTrue((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)intIsNull));
    }

    private void doOrTest(IncrementallyUpdatedFilterPredicate.ValueInspector v1, IncrementallyUpdatedFilterPredicate.ValueInspector v2, int v1Value, int v2Value, boolean expected) {
        v1.update(v1Value);
        v2.update(v2Value);
        IncrementallyUpdatedFilterPredicate.Or or = new IncrementallyUpdatedFilterPredicate.Or((IncrementallyUpdatedFilterPredicate)v1, (IncrementallyUpdatedFilterPredicate)v2);
        Assert.assertEquals((Object)expected, (Object)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)or));
        v1.reset();
        v2.reset();
    }

    private void doAndTest(IncrementallyUpdatedFilterPredicate.ValueInspector v1, IncrementallyUpdatedFilterPredicate.ValueInspector v2, int v1Value, int v2Value, boolean expected) {
        v1.update(v1Value);
        v2.update(v2Value);
        IncrementallyUpdatedFilterPredicate.And and = new IncrementallyUpdatedFilterPredicate.And((IncrementallyUpdatedFilterPredicate)v1, (IncrementallyUpdatedFilterPredicate)v2);
        Assert.assertEquals((Object)expected, (Object)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)and));
        v1.reset();
        v2.reset();
    }

    @Test
    public void testOr() {
        IncrementallyUpdatedFilterPredicate.ValueInspector v1 = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        IncrementallyUpdatedFilterPredicate.ValueInspector v2 = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        int F = 11;
        int T = 12;
        this.doOrTest(v1, v2, F, F, false);
        this.doOrTest(v1, v2, F, T, true);
        this.doOrTest(v1, v2, T, F, true);
        this.doOrTest(v1, v2, T, T, true);
    }

    @Test
    public void testAnd() {
        IncrementallyUpdatedFilterPredicate.ValueInspector v1 = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        IncrementallyUpdatedFilterPredicate.ValueInspector v2 = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        int F = 11;
        int T = 12;
        this.doAndTest(v1, v2, F, F, false);
        this.doAndTest(v1, v2, F, T, false);
        this.doAndTest(v1, v2, T, F, false);
        this.doAndTest(v1, v2, T, T, true);
    }

    @Test
    public void testShortCircuit() {
        IncrementallyUpdatedFilterPredicate.ValueInspector neverCalled = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

            public boolean accept(IncrementallyUpdatedFilterPredicate.Visitor visitor) {
                throw new ShortCircuitException();
            }
        };
        try {
            IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)neverCalled);
            Assert.fail((String)"this should throw");
        }
        catch (ShortCircuitException e) {
            // empty catch block
        }
        IncrementallyUpdatedFilterPredicate.ValueInspector v = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        v.update(10);
        IncrementallyUpdatedFilterPredicate.Or or = new IncrementallyUpdatedFilterPredicate.Or((IncrementallyUpdatedFilterPredicate)v, (IncrementallyUpdatedFilterPredicate)neverCalled);
        Assert.assertTrue((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)or));
        v.reset();
        v.update(11);
        IncrementallyUpdatedFilterPredicate.And and = new IncrementallyUpdatedFilterPredicate.And((IncrementallyUpdatedFilterPredicate)v, (IncrementallyUpdatedFilterPredicate)neverCalled);
        Assert.assertFalse((boolean)IncrementallyUpdatedFilterPredicateEvaluator.evaluate((IncrementallyUpdatedFilterPredicate)and));
        v.reset();
    }

    public static class ShortCircuitException
    extends RuntimeException {
        public ShortCircuitException() {
            super("this was supposed to short circuit and never get here!");
        }
    }
}

