/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import org.junit.Assert;
import org.junit.Test;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.ValidTypeMap;
import parquet.hadoop.metadata.ColumnPath;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;

public class TestValidTypeMap {
    public static Operators.IntColumn intColumn = FilterApi.intColumn((String)"int.column");
    public static Operators.LongColumn longColumn = FilterApi.longColumn((String)"long.column");
    public static Operators.FloatColumn floatColumn = FilterApi.floatColumn((String)"float.column");
    public static Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"double.column");
    public static Operators.BooleanColumn booleanColumn = FilterApi.booleanColumn((String)"boolean.column");
    public static Operators.BinaryColumn binaryColumn = FilterApi.binaryColumn((String)"binary.column");
    public static Operators.Column<InvalidColumnType> invalidColumn = new Operators.Column<InvalidColumnType>(ColumnPath.get((String[])new String[]{"invalid.column"}), InvalidColumnType.class){};

    @Test
    public void testValidTypes() {
        ValidTypeMap.assertTypeValid((Operators.Column)intColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, null);
        ValidTypeMap.assertTypeValid((Operators.Column)longColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, null);
        ValidTypeMap.assertTypeValid((Operators.Column)floatColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, null);
        ValidTypeMap.assertTypeValid((Operators.Column)doubleColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, null);
        ValidTypeMap.assertTypeValid((Operators.Column)booleanColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, null);
        ValidTypeMap.assertTypeValid((Operators.Column)binaryColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, null);
        ValidTypeMap.assertTypeValid((Operators.Column)binaryColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, null);
        ValidTypeMap.assertTypeValid((Operators.Column)binaryColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (OriginalType)OriginalType.UTF8);
        ValidTypeMap.assertTypeValid((Operators.Column)binaryColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (OriginalType)OriginalType.UTF8);
    }

    @Test
    public void testMismatchedTypes() {
        try {
            ValidTypeMap.assertTypeValid((Operators.Column)intColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, null);
            Assert.fail((String)"This should throw!");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"FilterPredicate column: int.column's declared type (java.lang.Integer) does not match the schema found in file metadata. Column int.column is of type: FullTypeDescriptor(PrimitiveType: DOUBLE, OriginalType: null)\nValid types for this column are: [class java.lang.Double]", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnsupportedType() {
        try {
            ValidTypeMap.assertTypeValid(invalidColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, null);
            Assert.fail((String)"This should throw!");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Column invalid.column was declared as type: parquet.filter2.predicate.TestValidTypeMap$InvalidColumnType which is not supported in FilterPredicates. Supported types for this column are: [class java.lang.Integer]", (Object)e.getMessage());
        }
        try {
            ValidTypeMap.assertTypeValid(invalidColumn, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (OriginalType)OriginalType.UTF8);
            Assert.fail((String)"This should throw!");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Column invalid.column was declared as type: parquet.filter2.predicate.TestValidTypeMap$InvalidColumnType which is not supported in FilterPredicates. There are no supported types for columns of FullTypeDescriptor(PrimitiveType: INT32, OriginalType: UTF8)", (Object)e.getMessage());
        }
    }

    private static class InvalidColumnType
    implements Comparable<InvalidColumnType> {
        private InvalidColumnType() {
        }

        @Override
        public int compareTo(InvalidColumnType o) {
            return 0;
        }
    }
}

