/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import org.junit.Assert;
import org.junit.Test;
import parquet.filter2.predicate.DummyUdp;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.LogicalInverter;
import parquet.filter2.predicate.Operators;

public class TestLogicalInverter {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"a.b.c");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"a.b.c");
    private static final Operators.UserDefined<Integer, DummyUdp> ud = FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class);
    private static final FilterPredicate complex = FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))), (FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(100.0)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(77))));
    private static final FilterPredicate complexInverse = FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))), (FilterPredicate)new Operators.LogicalNotUserDefined(FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class)))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.ltEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(100.0)), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(77))));

    @Test
    public void testBaseCases() {
        Assert.assertEquals((Object)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        Assert.assertEquals((Object)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        Assert.assertEquals((Object)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        Assert.assertEquals((Object)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        Assert.assertEquals((Object)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        Assert.assertEquals((Object)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))));
        FilterPredicate andPos = FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)));
        FilterPredicate andInv = FilterApi.or((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.notEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)));
        Assert.assertEquals((Object)andInv, (Object)LogicalInverter.invert((FilterPredicate)andPos));
        FilterPredicate orPos = FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)));
        FilterPredicate orInv = FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.notEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)));
        Assert.assertEquals((Object)orPos, (Object)LogicalInverter.invert((FilterPredicate)orInv));
        Assert.assertEquals((Object)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverter.invert((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Operators.UserDefined ud = FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class);
        Assert.assertEquals((Object)new Operators.LogicalNotUserDefined(ud), (Object)LogicalInverter.invert((FilterPredicate)ud));
        Assert.assertEquals((Object)ud, (Object)LogicalInverter.invert((FilterPredicate)FilterApi.not((FilterPredicate)ud)));
        Assert.assertEquals((Object)ud, (Object)LogicalInverter.invert((FilterPredicate)new Operators.LogicalNotUserDefined(ud)));
    }

    @Test
    public void testComplex() {
        Assert.assertEquals((Object)complexInverse, (Object)LogicalInverter.invert((FilterPredicate)complex));
    }
}

