/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import org.junit.Assert;
import org.junit.Test;
import parquet.filter2.predicate.DummyUdp;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.LogicalInverseRewriter;
import parquet.filter2.predicate.Operators;

public class TestLogicalInverseRewriter {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"a.b.c");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"a.b.c");
    private static final FilterPredicate complex = FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))), (FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class)))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(100.0)), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(77)))));
    private static final FilterPredicate complexCollapsed = FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))), (FilterPredicate)new Operators.LogicalNotUserDefined(FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class)))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(100.0)), (FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(77))));

    private static void assertNoOp(FilterPredicate p) {
        Assert.assertEquals((Object)p, (Object)LogicalInverseRewriter.rewrite((FilterPredicate)p));
    }

    @Test
    public void testBaseCases() {
        Operators.UserDefined ud = FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class);
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        TestLogicalInverseRewriter.assertNoOp(FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))));
        TestLogicalInverseRewriter.assertNoOp(FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))));
        TestLogicalInverseRewriter.assertNoOp((FilterPredicate)ud);
        Assert.assertEquals((Object)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))));
        Assert.assertEquals((Object)new Operators.LogicalNotUserDefined(ud), (Object)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)ud)));
        FilterPredicate notedAnd = FilterApi.not((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))));
        FilterPredicate distributedAnd = FilterApi.or((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.notEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)));
        Assert.assertEquals((Object)distributedAnd, (Object)LogicalInverseRewriter.rewrite((FilterPredicate)notedAnd));
        FilterPredicate andWithNots = FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))), (FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)));
        FilterPredicate andWithoutNots = FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)));
        Assert.assertEquals((Object)andWithoutNots, (Object)LogicalInverseRewriter.rewrite((FilterPredicate)andWithNots));
    }

    @Test
    public void testComplex() {
        Assert.assertEquals((Object)complexCollapsed, (Object)LogicalInverseRewriter.rewrite((FilterPredicate)complex));
    }
}

