/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import parquet.filter2.predicate.DummyUdp;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.Statistics;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.hadoop.metadata.ColumnPath;
import parquet.io.api.Binary;

public class TestFilterApiMethods {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"a.b.c");
    private static final Operators.LongColumn longColumn = FilterApi.longColumn((String)"a.b.l");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"x.y.z");
    private static final Operators.BinaryColumn binColumn = FilterApi.binaryColumn((String)"a.string.column");
    private static final FilterPredicate predicate = FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)))), (FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(100.0)));

    @Test
    public void testFilterPredicateCreation() {
        FilterPredicate outerAnd = predicate;
        Assert.assertTrue((boolean)(outerAnd instanceof Operators.And));
        FilterPredicate not = ((Operators.And)outerAnd).getLeft();
        FilterPredicate gt = ((Operators.And)outerAnd).getRight();
        Assert.assertTrue((boolean)(not instanceof Operators.Not));
        FilterPredicate or = ((Operators.Not)not).getPredicate();
        Assert.assertTrue((boolean)(or instanceof Operators.Or));
        FilterPredicate leftEq = ((Operators.Or)or).getLeft();
        FilterPredicate rightNotEq = ((Operators.Or)or).getRight();
        Assert.assertTrue((boolean)(leftEq instanceof Operators.Eq));
        Assert.assertTrue((boolean)(rightNotEq instanceof Operators.NotEq));
        Assert.assertEquals((Object)7, (Object)((Operators.Eq)leftEq).getValue());
        Assert.assertEquals((Object)17, (Object)((Operators.NotEq)rightNotEq).getValue());
        Assert.assertEquals((Object)ColumnPath.get((String[])new String[]{"a", "b", "c"}), (Object)((Operators.Eq)leftEq).getColumn().getColumnPath());
        Assert.assertEquals((Object)ColumnPath.get((String[])new String[]{"a", "b", "c"}), (Object)((Operators.NotEq)rightNotEq).getColumn().getColumnPath());
        Assert.assertTrue((boolean)(gt instanceof Operators.Gt));
        Assert.assertEquals((Object)100.0, (Object)((Operators.Gt)gt).getValue());
        Assert.assertEquals((Object)ColumnPath.get((String[])new String[]{"x", "y", "z"}), (Object)((Operators.Gt)gt).getColumn().getColumnPath());
    }

    @Test
    public void testToString() {
        FilterPredicate pred = FilterApi.or((FilterPredicate)predicate, (FilterPredicate)FilterApi.notEq((Operators.Column)binColumn, (Comparable)Binary.fromString((String)"foobarbaz")));
        Assert.assertEquals((Object)"or(and(not(or(eq(a.b.c, 7), noteq(a.b.c, 17))), gt(x.y.z, 100.0)), noteq(a.string.column, Binary{\"foobarbaz\"}))", (Object)pred.toString());
    }

    @Test
    public void testUdp() {
        FilterPredicate predicate = FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class));
        Assert.assertTrue((boolean)(predicate instanceof Operators.Or));
        FilterPredicate ud = ((Operators.Or)predicate).getRight();
        Assert.assertTrue((boolean)(ud instanceof Operators.UserDefinedByClass));
        Assert.assertEquals(DummyUdp.class, (Object)((Operators.UserDefinedByClass)ud).getUserDefinedPredicateClass());
        Assert.assertTrue((boolean)(((Operators.UserDefined)ud).getUserDefinedPredicate() instanceof DummyUdp));
    }

    @Test
    public void testSerializable() throws Exception {
        Operators.BinaryColumn binary = FilterApi.binaryColumn((String)"foo");
        FilterPredicate p = FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, DummyUdp.class), (FilterPredicate)predicate), (FilterPredicate)FilterApi.eq((Operators.Column)binary, (Comparable)Binary.fromString((String)"hi"))), (FilterPredicate)FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)new IsMultipleOf(7L)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(p);
        oos.close();
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        FilterPredicate read = (FilterPredicate)is.readObject();
        Assert.assertEquals((Object)p, (Object)read);
    }

    public static class IsMultipleOf
    extends UserDefinedPredicate<Long>
    implements Serializable {
        private long of;

        public IsMultipleOf(long of) {
            this.of = of;
        }

        public boolean keep(Long value) {
            if (value == null) {
                return false;
            }
            return value % this.of == 0L;
        }

        public boolean canDrop(Statistics<Long> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Long> statistics) {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IsMultipleOf that = (IsMultipleOf)o;
            return this.of == that.of;
        }

        public int hashCode() {
            return new Long(this.of).hashCode();
        }

        public String toString() {
            return "IsMultipleOf(" + this.of + ")";
        }
    }
}

