/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltastrings.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import parquet.column.values.Utils;
import parquet.column.values.ValuesReader;
import parquet.column.values.ValuesWriter;
import parquet.column.values.deltastrings.DeltaByteArrayReader;
import parquet.column.values.deltastrings.DeltaByteArrayWriter;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.io.api.Binary;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-writing-random")
public class BenchmarkDeltaByteArray {
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();
    static String[] values = Utils.getRandomStringSamples(1000000, 32);
    static String[] sortedVals = Arrays.copyOf(values, values.length);

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536, 65536);
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.length);
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536);
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.length);
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkSortedStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536, 65536);
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, sortedVals);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.length);
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkSortedStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536);
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, sortedVals);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.length);
    }

    static {
        Arrays.sort(sortedVals);
    }
}

