/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.values.Utils;
import parquet.column.values.ValuesReader;
import parquet.column.values.ValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import parquet.io.api.Binary;

public class TestDeltaLengthByteArray {
    String[] values = new String[]{"parquet", "hadoop", "mapreduce"};

    @Test
    public void testSerialization() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = new DeltaLengthByteArrayValuesWriter(65536, 65536);
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toByteArray(), this.values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)this.values[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testRandomStrings() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = new DeltaLengthByteArrayValuesWriter(65536, 65536);
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        String[] values = Utils.getRandomStringSamples(1000, 32);
        Utils.writeData((ValuesWriter)writer, values);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toByteArray(), values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)values[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testLengths() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = new DeltaLengthByteArrayValuesWriter(65536, 65536);
        DeltaBinaryPackingValuesReader reader = new DeltaBinaryPackingValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        int[] bin = Utils.readInts((ValuesReader)reader, writer.getBytes().toByteArray(), this.values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((long)this.values[i].length(), (long)bin[i]);
        }
    }
}

