/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.delta.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.io.IOException;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import parquet.column.values.ValuesReader;
import parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-reading-random")
public class BenchmarkReadingRandomIntegers {
    public static int blockSize = 128;
    public static int miniBlockNum = 4;
    public static byte[] deltaBytes;
    public static byte[] rleBytes;
    public static int[] data;
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();

    @BeforeClass
    public static void prepare() throws IOException {
        Random random = new Random();
        data = new int[100000 * blockSize];
        for (int i = 0; i < data.length; ++i) {
            BenchmarkReadingRandomIntegers.data[i] = random.nextInt(100) - 200;
        }
        DeltaBinaryPackingValuesWriter delta = new DeltaBinaryPackingValuesWriter(blockSize, miniBlockNum, 100, 20000);
        RunLengthBitPackingHybridValuesWriter rle = new RunLengthBitPackingHybridValuesWriter(32, 100, 20000);
        for (int i = 0; i < data.length; ++i) {
            delta.writeInteger(data[i]);
            rle.writeInteger(data[i]);
        }
        deltaBytes = delta.getBytes().toByteArray();
        rleBytes = rle.getBytes().toByteArray();
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=10)
    @Test
    public void readingDelta() throws IOException {
        for (int j = 0; j < 10; ++j) {
            DeltaBinaryPackingValuesReader reader = new DeltaBinaryPackingValuesReader();
            this.readData((ValuesReader)reader, deltaBytes);
        }
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=10)
    @Test
    public void readingRLE() throws IOException {
        for (int j = 0; j < 10; ++j) {
            RunLengthBitPackingHybridValuesReader reader = new RunLengthBitPackingHybridValuesReader(32);
            this.readData((ValuesReader)reader, rleBytes);
        }
    }

    private void readData(ValuesReader reader, byte[] deltaBytes) throws IOException {
        reader.initFromPage(data.length, deltaBytes, 0);
        for (int i = 0; i < data.length; ++i) {
            reader.readInteger();
        }
    }
}

