/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.delta.benchmark;

import java.util.Random;
import org.junit.Test;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;

public class BenchmarkIntegerOutputSize {
    public static int blockSize = 128;
    public static int miniBlockNum = 4;
    public static int dataSize = 10000 * blockSize;

    @Test
    public void testBigNumbers() {
        final Random r = new Random();
        this.testRandomIntegers(new IntFunc(){

            @Override
            public int getIntValue() {
                return r.nextInt();
            }
        }, 32);
    }

    @Test
    public void testRangedNumbersWithSmallVariations() {
        final Random r = new Random();
        this.testRandomIntegers(new IntFunc(){

            @Override
            public int getIntValue() {
                return 1000 + r.nextInt(20);
            }
        }, 10);
    }

    @Test
    public void testSmallNumbersWithSmallVariations() {
        final Random r = new Random();
        this.testRandomIntegers(new IntFunc(){

            @Override
            public int getIntValue() {
                return 40 + r.nextInt(20);
            }
        }, 6);
    }

    @Test
    public void testSmallNumberVariation() {
        final Random r = new Random();
        this.testRandomIntegers(new IntFunc(){

            @Override
            public int getIntValue() {
                return r.nextInt(20) - 10;
            }
        }, 4);
    }

    public void testRandomIntegers(IntFunc func, int bitWidth) {
        DeltaBinaryPackingValuesWriter delta = new DeltaBinaryPackingValuesWriter(blockSize, miniBlockNum, 100, 20000);
        RunLengthBitPackingHybridValuesWriter rle = new RunLengthBitPackingHybridValuesWriter(bitWidth, 100, 20000);
        for (int i = 0; i < dataSize; ++i) {
            int v = func.getIntValue();
            delta.writeInteger(v);
            rle.writeInteger(v);
        }
        System.out.println("delta size: " + delta.getBytes().size());
        System.out.println("estimated size" + this.estimatedSize());
        System.out.println("rle size: " + rle.getBytes().size());
    }

    private double estimatedSize() {
        int miniBlockSize = blockSize / miniBlockNum;
        double miniBlockFlushed = Math.ceil(((double)dataSize - 1.0) / (double)miniBlockSize);
        double blockFlushed = Math.ceil(((double)dataSize - 1.0) / (double)blockSize);
        double estimatedSize = 20.0 + 4.0 * miniBlockFlushed * (double)miniBlockSize + blockFlushed * (double)miniBlockNum + 5.0 * blockFlushed;
        return estimatedSize;
    }

    private static interface IntFunc {
        public int getIntValue();
    }
}

