/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page.mem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.page.DataPage;
import parquet.column.page.DataPageV1;
import parquet.column.page.DataPageV2;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageWriter;
import parquet.column.statistics.Statistics;
import parquet.io.ParquetEncodingException;

public class MemPageWriter
implements PageWriter {
    private static final Log LOG = Log.getLog(MemPageWriter.class);
    private final List<DataPage> pages = new ArrayList<DataPage>();
    private DictionaryPage dictionaryPage;
    private long memSize = 0L;
    private long totalValueCount = 0L;

    public void writePage(BytesInput bytesInput, int valueCount, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        if (valueCount == 0) {
            throw new ParquetEncodingException("illegal page of 0 values");
        }
        this.memSize += bytesInput.size();
        this.pages.add((DataPage)new DataPageV1(BytesInput.copy((BytesInput)bytesInput), valueCount, (int)bytesInput.size(), statistics, rlEncoding, dlEncoding, valuesEncoding));
        this.totalValueCount += (long)valueCount;
        if (Log.DEBUG) {
            LOG.debug((Object)("page written for " + bytesInput.size() + " bytes and " + valueCount + " records"));
        }
    }

    public void writePageV2(int rowCount, int nullCount, int valueCount, BytesInput repetitionLevels, BytesInput definitionLevels, Encoding dataEncoding, BytesInput data, Statistics<?> statistics) throws IOException {
        if (valueCount == 0) {
            throw new ParquetEncodingException("illegal page of 0 values");
        }
        long size = repetitionLevels.size() + definitionLevels.size() + data.size();
        this.memSize += size;
        this.pages.add((DataPage)DataPageV2.uncompressed((int)rowCount, (int)nullCount, (int)valueCount, (BytesInput)BytesInput.copy((BytesInput)repetitionLevels), (BytesInput)BytesInput.copy((BytesInput)definitionLevels), (Encoding)dataEncoding, (BytesInput)BytesInput.copy((BytesInput)data), statistics));
        this.totalValueCount += (long)valueCount;
        if (Log.DEBUG) {
            LOG.debug((Object)("page written for " + size + " bytes and " + valueCount + " records"));
        }
    }

    public long getMemSize() {
        return this.memSize;
    }

    public List<DataPage> getPages() {
        return this.pages;
    }

    public DictionaryPage getDictionaryPage() {
        return this.dictionaryPage;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public long allocatedSize() {
        return this.memSize;
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
        if (this.dictionaryPage != null) {
            throw new ParquetEncodingException("Only one dictionary page per block");
        }
        this.memSize += dictionaryPage.getBytes().size();
        this.dictionaryPage = dictionaryPage.copy();
        if (Log.DEBUG) {
            LOG.debug((Object)("dictionary page written for " + dictionaryPage.getBytes().size() + " bytes and " + dictionaryPage.getDictionarySize() + " records"));
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %,d bytes", prefix, this.memSize);
    }
}

