/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page.mem;

import java.util.Iterator;
import parquet.Log;
import parquet.Preconditions;
import parquet.column.page.DataPage;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageReader;
import parquet.io.ParquetDecodingException;

public class MemPageReader
implements PageReader {
    private static final Log LOG = Log.getLog(MemPageReader.class);
    private final long totalValueCount;
    private final Iterator<DataPage> pages;
    private final DictionaryPage dictionaryPage;

    public MemPageReader(long totalValueCount, Iterator<DataPage> pages, DictionaryPage dictionaryPage) {
        Preconditions.checkNotNull(pages, (String)"pages");
        this.totalValueCount = totalValueCount;
        this.pages = pages;
        this.dictionaryPage = dictionaryPage;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public DataPage readPage() {
        if (this.pages.hasNext()) {
            DataPage next = this.pages.next();
            if (Log.DEBUG) {
                LOG.debug((Object)("read page " + next));
            }
            return next;
        }
        throw new ParquetDecodingException("after last page");
    }

    public DictionaryPage readDictionaryPage() {
        return this.dictionaryPage;
    }
}

